/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.pattern;

import de.jave.gui.GTextArea;
import de.jave.gui.dialog.GDialog;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.pattern.Pattern;
import de.jave.jave.pattern.PatternList;
import de.jave.javeplayer.AsciiPacker;
import de.jave.text.TextTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutUtilities;

public final class PatternDialog {
    private final JDialog dialog;
    private final List list;
    private final PatternList patternList;
    private final GTextArea taPattern;
    private final GTextArea taPreview;
    private final TextField tfAuthor;
    private Pattern currentPattern;

    public PatternDialog(Component parent) {
        this.dialog = GDialog.createJDialog(parent, "Pattern Library", true);
        this.patternList = new PatternList();
        this.patternList.load();
        this.list = new List();
        int size = this.patternList.getPatternCount();
        for (int i = 0; i < size; ++i) {
            this.list.add(this.patternList.getPattern(i).getName());
        }
        this.list.setMultipleMode(false);
        this.list.select(0);
        this.list.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                PatternDialog.this.updatePreview();
            }
        });
        this.currentPattern = this.patternList.getPattern(0);
        this.taPattern = new GTextArea("", 6, 10);
        this.taPattern.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taPattern.setEditable(false);
        this.tfAuthor = new TextField(15);
        this.tfAuthor.setEditable(false);
        final SmartAction deleteAction = new SmartAction("Delete"){

            protected final void execute(Component parentComponent) {
                PatternDialog.this.performDeleteSelectedPattern(parentComponent);
            }
        };
        this.list.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                PatternDialog.this.updateDeleteActionEnabled(deleteAction);
            }
        });
        this.updateDeleteActionEnabled(deleteAction);
        SmartAction okAction = new SmartAction("&OK"){

            protected final void execute(Component parentComponent) {
                PatternDialog.this.performOk();
            }
        };
        SmartAction cancelAction = new SmartAction("&Cancel"){

            protected final void execute(Component parentComponent) {
                PatternDialog.this.performCancel();
            }
        };
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(okAction);
        buttonPanelBuilder.add(cancelAction);
        JPanel detailsPanel = new JPanel(new GridDialogLayout(2, false));
        detailsPanel.add(new JLabel("Author:"));
        detailsPanel.add(this.tfAuthor);
        GridDialogLayoutData data = new GridDialogLayoutData();
        data.setHorizontalSpan(2);
        detailsPanel.add((Component)new JButton(deleteAction), data);
        this.taPreview = new GTextArea("", 12, 30);
        this.taPreview.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taPreview.setEditable(false);
        JPanel patternPanel = new JPanel(new BorderLayout(LayoutUtilities.getComponentSpacing(), 1));
        patternPanel.add((Component)new JLabel("Pattern:"), "North");
        patternPanel.add((Component)this.list, "West");
        patternPanel.add((Component)this.taPattern.getContent(), "Center");
        patternPanel.add((Component)detailsPanel, "East");
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add((Component)new JLabel("Preview:"), "North");
        previewPanel.add((Component)this.taPreview.getContent(), "Center");
        this.dialog.getContentPane().setLayout(new BorderLayout(LayoutUtilities.getComponentSpacing(), LayoutUtilities.getComponentSpacing()));
        this.dialog.getContentPane().add((Component)patternPanel, "North");
        this.dialog.getContentPane().add((Component)previewPanel, "Center");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                PatternDialog.this.performCancel();
            }
        });
        this.updatePreview();
    }

    private void performCancel() {
        this.currentPattern = null;
        this.performOk();
    }

    private void updateDeleteActionEnabled(SmartAction deleteAction) {
        deleteAction.setEnabled(this.list.getSelectedIndex() != -1);
    }

    public final void addPattern(Pattern newPattern) {
        this.patternList.add(newPattern);
        this.patternList.save();
        this.updateList();
        this.updatePreview();
    }

    private void updateList() {
        this.list.removeAll();
        int size = this.patternList.getPatternCount();
        for (int i = 0; i < size; ++i) {
            this.list.add(this.patternList.getPattern(i).getName());
        }
        this.list.select(size - 1);
    }

    private void updatePreview() {
        int height;
        int width;
        int index = this.list.getSelectedIndex();
        this.currentPattern = this.patternList.getPattern(index);
        char[][] ch = AsciiPacker.decode(this.currentPattern.getCode());
        this.taPattern.setText(TextTools.toString(ch));
        this.tfAuthor.setText(this.currentPattern.getAuthor());
        int patternWidth = ch.length;
        int patternHeight = ch[0].length;
        for (width = patternWidth; width < 50; width += patternWidth) {
        }
        for (height = patternHeight; height < 12; height += patternHeight) {
        }
        char[][] cp = new char[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                cp[y][x] = ch[y % patternWidth][x % patternHeight];
            }
        }
        this.taPreview.setText(TextTools.toString(cp));
    }

    private void performOk() {
        this.dialog.setVisible(false);
    }

    private void performDeleteSelectedPattern(Component parentComponent) {
        int index = this.list.getSelectedIndex();
        this.currentPattern = this.patternList.getPattern(index);
        String question = "Do you really want to delete\nthe Pattern \"" + this.currentPattern.getName() + "\" ?";
        GDialog id = new GDialog(parentComponent, "Delete pattern", question, GDialog.YES_NO_CANCEL, 1);
        id.show();
        int result = id.getAnswer();
        if (result == -1 || result == 1 || result == 2) {
            return;
        }
        this.patternList.delete(index);
        this.patternList.save();
        this.updateList();
        this.list.select(index - 1);
        this.updatePreview();
    }

    public final Dialog getDialog() {
        return this.dialog;
    }

    public final Pattern getSelectedPattern() {
        return this.currentPattern;
    }

    public final boolean isCanceled() {
        return this.currentPattern == null;
    }

    public final void show() {
        this.dialog.setVisible(true);
    }
}

