/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.clipart;

import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.clipart.Clipart;
import de.jave.jave.clipart.ClipartGroup;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public final class ClipartTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon FOLDER_ICON = JaveImageProvider.getInstance().getImageIcon("folder_small.gif");
    private static final Icon FOLDER_OPEN_ICON = JaveImageProvider.getInstance().getImageIcon("folder_small_open.gif");
    private static final Icon DOCUMENT_ICON = JaveImageProvider.getInstance().getImageIcon("clipart_small.gif");

    public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (userObject instanceof Clipart) {
            Clipart clipart = (Clipart)userObject;
            this.setText(clipart.getName());
            this.setIcon(DOCUMENT_ICON);
        } else if (userObject instanceof ClipartGroup) {
            ClipartGroup clipartGroup = (ClipartGroup)userObject;
            this.setText(clipartGroup.getName());
            this.setIcon(expanded ? FOLDER_OPEN_ICON : FOLDER_ICON);
        } else {
            this.setIcon(null);
        }
        return this;
    }
}

