/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.clipart;

import de.jave.jave.clipart.Clipart;
import de.jave.lib.io.IoUtilities;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.disy.commons.core.message.Message;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public final class ClipartGroup {
    private String name;
    private final List cliparts = new ArrayList();

    public ClipartGroup(String name, Clipart[] cliparts) {
        this.name = name;
        this.cliparts.addAll(Arrays.asList(cliparts));
        this.sort();
    }

    public ClipartGroup(String name) {
        this(name, new Clipart[0]);
    }

    private void sort() {
        Collections.sort(this.cliparts, new Comparator(this){

            public final int compare(Object arg0, Object arg1) {
                Clipart clipart1 = (Clipart)arg0;
                Clipart clipart2 = (Clipart)arg1;
                return clipart1.getName().compareTo(clipart2.getName());
            }
        });
    }

    public final void add(Clipart clipart) {
        this.cliparts.add(clipart);
        this.sort();
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performSave(Component parentComponent, File baseDir) {
        BufferedWriter writer = null;
        try {
            File file = new File(baseDir, this.name + ".jcf");
            writer = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.cliparts.size(); ++i) {
                Clipart clipart = (Clipart)this.cliparts.get(i);
                writer.write(clipart.getName());
                writer.newLine();
                writer.write(clipart.getAuthor());
                writer.newLine();
                writer.write(clipart.getCode());
                writer.newLine();
                writer.newLine();
            }
            IoUtilities.close(writer);
            return;
        }
        catch (Exception e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("Error saving Clipart-File", e));
            return;
        }
        finally {
            IoUtilities.close(writer);
        }
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer("ClipartGroup '" + this.name + "':\n");
        for (int i = 0; i < this.cliparts.size(); ++i) {
            sb.append(" " + i + ": " + ((Clipart)this.cliparts.get(i)).toString() + "\n");
        }
        return sb.toString();
    }

    public final int getClipartCount() {
        return this.cliparts.size();
    }

    public final Clipart getClipart(int index) {
        return (Clipart)this.cliparts.get(index);
    }

    public static final ClipartGroup load(File file) throws Exception {
        ClipartGroup clipartGroup;
        String name = file.getName();
        if (name.endsWith(".jcf")) {
            name = name.substring(0, name.length() - 4);
        }
        BufferedReader br = null;
        try {
            String s1;
            br = new BufferedReader(new FileReader(file));
            ArrayList<Clipart> clipartList = new ArrayList<Clipart>();
            while ((s1 = br.readLine()) != null) {
                String s2 = br.readLine();
                if (s2 == null) {
                    throw new Exception("Unexpected End of Clipart File '" + file.getAbsolutePath() + ".jcf'.");
                }
                String s3 = br.readLine();
                if (s3 == null) {
                    throw new Exception("Unexpected End of Clipart File '" + file.getAbsolutePath() + ".jcf'.");
                }
                clipartList.add(new Clipart(s1, s3, s2));
                br.readLine();
            }
            Clipart[] cliparts = clipartList.toArray(new Clipart[clipartList.size()]);
            clipartGroup = new ClipartGroup(name, cliparts);
        }
        catch (IOException e) {
            try {
                throw new Exception("Error loading clipart file '" + file.getAbsolutePath() + "'", e);
            }
            catch (Throwable throwable) {
                IoUtilities.close(br);
                throw throwable;
            }
        }
        IoUtilities.close(br);
        return clipartGroup;
    }
}

