/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.clipart;

import de.jave.gui.GTextArea;
import de.jave.gui.dialog.GDialog;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.clipart.Clipart;
import de.jave.jave.clipart.ClipartGroup;
import de.jave.jave.clipart.ClipartManager;
import de.jave.jave.clipart.ClipartTreeCellRenderer;
import de.jave.javeplayer.AsciiPacker;
import de.jave.lib.CharacterPlate;
import de.jave.lib.Toolbox;
import de.jave.lib.gui.GuiUtilities;
import de.jave.text.TextTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.tree.ITreeNodeActionListener;
import net.disy.commons.swing.tree.SmartTree;

public final class ClipartDialog {
    private GTextArea taPreview;
    private JTextField tfAuthor;
    private JTextField tfSize;
    private final JDialog dialog;
    private final SmartTree tree;
    private final Jave jave;

    public ClipartDialog(Jave parent, ClipartManager clipartManager) {
        this.jave = parent;
        this.dialog = GDialog.createJDialog(parent.getFrame(), "Clipart Library", true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                ClipartDialog.this.performCancel();
            }
        });
        String[] s = clipartManager.getGroupNames();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Clipart Library");
        for (int i = 0; i < s.length; ++i) {
            ClipartGroup group = clipartManager.getGroup(s[i]);
            DefaultMutableTreeNode folderNode = new DefaultMutableTreeNode(group);
            rootNode.add(folderNode);
            for (int j = 0; j < group.getClipartCount(); ++j) {
                folderNode.add(new DefaultMutableTreeNode(group.getClipart(j)));
            }
        }
        JPanel p0 = new JPanel(new FlowLayout());
        p0.add(new JLabel("Author:"));
        this.tfAuthor = new JTextField("", 15);
        this.tfAuthor.setEditable(false);
        p0.add(this.tfAuthor);
        p0.add(new JLabel("Size:"));
        this.tfSize = new JTextField("", 9);
        this.tfSize.setEditable(false);
        p0.add(this.tfSize);
        this.taPreview = new GTextArea("", 16, 45);
        this.taPreview.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taPreview.setEditable(false);
        JPanel pb = new JPanel(new GridLayout(0, 1));
        pb.add(this.taPreview.getContent());
        pb.setBorder(new TitledBorder("Preview:"));
        JPanel pe = new JPanel(new BorderLayout());
        pe.add((Component)p0, "North");
        pe.add((Component)pb, "Center");
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(new SmartAction("&OK"){

            protected final void execute(Component parentComponent) {
                ClipartDialog.this.performOk();
            }
        });
        buttonPanelBuilder.add(new SmartAction("&Cancel"){

            protected final void execute(Component parentComponent) {
                ClipartDialog.this.performCancel();
            }
        });
        this.dialog.getContentPane().setLayout(new BorderLayout(5, 5));
        this.tree = new SmartTree(rootNode);
        this.tree.setCellRenderer(new ClipartTreeCellRenderer());
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public final void valueChanged(TreeSelectionEvent e) {
                ClipartDialog.this.updateSelectedClipart(ClipartDialog.this.getSelectedClipart());
            }
        });
        this.tree.addNodeActionListener(new ITreeNodeActionListener(){

            public final void nodeActionPerformed(Component parentComponent, TreeNode node) {
                Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
                if (userObject instanceof Clipart) {
                    ClipartDialog.this.performInsert((Clipart)userObject);
                }
            }
        });
        JScrollPane treePane = new JScrollPane(this.tree);
        treePane.setPreferredSize(new Dimension(150, 320));
        this.dialog.getContentPane().add((Component)treePane, "Center");
        this.dialog.getContentPane().add((Component)pe, "East");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.pack();
        this.taPreview.setText(TextTools.toString(AsciiPacker.decode("A7 3  \\-/%0J|a|v|E%0 /-\\")));
        GuiUtilities.centerOnScreen(this.dialog);
    }

    public final JDialog getDialog() {
        return this.dialog;
    }

    private void performInsert(ClipartGroup clipartGroup) {
        int h = 0;
        int w = 20;
        for (int i = 0; i < clipartGroup.getClipartCount(); ++i) {
            Clipart c = clipartGroup.getClipart(i);
            h += c.getHeight() + 4;
            w = Toolbox.max(w, c.getWidth(), c.getAuthor().length() + 8, c.getName().length() + 8);
        }
        --h;
        CharacterPlate cp = new CharacterPlate(w, h += 3);
        cp.paste("Clipart group: " + clipartGroup.getName(), 0, 0);
        cp.paste("contains " + clipartGroup.getClipartCount() + " cliparts", 0, 1);
        cp.paste("--------------------------", 0, 2);
        int y = 3;
        for (int i = 0; i < clipartGroup.getClipartCount(); ++i) {
            Clipart c = clipartGroup.getClipart(i);
            cp.paste("Name  :", 0, y);
            cp.paste(c.getName(), 8, y);
            cp.paste("Author:", 0, y + 1);
            cp.paste(c.getAuthor(), 8, y + 1);
            cp.paste("Size  : " + c.getWidth() + "x" + c.getHeight(), 0, y + 2);
            cp.paste(c.getContent(), 0, y + 3);
            y += c.getHeight() + 4;
        }
        this.jave.pasteAsNewDocument(cp, clipartGroup.getName());
        this.jave.toFront();
    }

    private void updateSelectedClipart(Clipart clipart) {
        if (clipart == null) {
            this.taPreview.setText("");
            this.tfAuthor.setText("");
            this.tfSize.setText("");
            return;
        }
        this.taPreview.setText(TextTools.toString(clipart.getContent()));
        this.tfAuthor.setText(clipart.getAuthor());
        this.tfSize.setText(clipart.getWidth() + " x " + clipart.getHeight());
    }

    private Clipart getSelectedClipart() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        if (node.getUserObject() instanceof Clipart) {
            return (Clipart)node.getUserObject();
        }
        return null;
    }

    private ClipartGroup getSelectedClipartGroup() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        return ClipartDialog.getClipartGroup((DefaultMutableTreeNode)selectionPath.getLastPathComponent());
    }

    private static ClipartGroup getClipartGroup(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.getUserObject() instanceof ClipartGroup) {
            return (ClipartGroup)node.getUserObject();
        }
        return ClipartDialog.getClipartGroup((DefaultMutableTreeNode)node.getParent());
    }

    private void performCancel() {
        this.dialog.setVisible(false);
    }

    private void performOk() {
        Clipart clipart = this.getSelectedClipart();
        if (clipart != null) {
            this.performInsert(clipart);
            return;
        }
        ClipartGroup clipartGroup = this.getSelectedClipartGroup();
        if (clipartGroup != null) {
            this.performInsert(clipartGroup);
        }
    }

    private void performInsert(Clipart clipart) {
        this.jave.pasteAsNewSelection(clipart.getContent());
        this.dialog.setVisible(false);
    }
}

