/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.steganogram;

import de.jave.gui.layout.Gap;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithmGradientOptionsPanel;
import de.jave.jave.AsciiGradients;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.algorithm.steganogram.GradientSteganogramDecoder;
import de.jave.lib.CharacterPlate;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.swing.dialog.userdialog.AbstractDialogPage;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.text.DocumentChangeListener;

public final class GradientSteganogramPage
extends AbstractDialogPage {
    private final CharacterPlate plate;
    private final JTextField tfGradient;
    private final JTextField tfDecoded;

    public GradientSteganogramPage(CharacterPlate plate) {
        super(new BasicMessage("Please enter a key to decode the current document with. Note that the current document must contain an ascii art image with steganogram."));
        this.plate = plate;
        this.tfGradient = new JTextField(AsciiGradients.getDefaultGradient(), 27);
        this.tfDecoded = new JTextField("", 27);
    }

    public final IBasicMessage createCurrentMessage() {
        return this.getDefaultMessage();
    }

    public final String getTitle() {
        return "Steganogram Decoder";
    }

    public final JComponent createContent() {
        JPanel panel = new JPanel(new GridDialogLayout(3, false));
        this.tfGradient.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.tfDecoded.setEditable(false);
        panel.add((Component)new JLabel("Key (gradient):"), GridDialogLayoutData.RIGHT);
        panel.add(this.tfGradient);
        panel.add(Image2AsciiAlgorithmGradientOptionsPanel.createSteganographyHelpButton());
        GridDialogLayoutData lineData = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        lineData.setHorizontalSpan(3);
        panel.add((Component)new Gap(0, LayoutUtilities.getComponentGroupsSpacing()), lineData);
        panel.add((Component)new JLabel("Decoded message:"), GridDialogLayoutData.RIGHT);
        panel.add(this.tfDecoded);
        this.tfGradient.getDocument().addDocumentListener(new DocumentChangeListener(){

            protected final void documentChanged() {
                GradientSteganogramPage.this.doDecode();
            }
        });
        this.doDecode();
        return panel;
    }

    private void doDecode() {
        this.tfDecoded.setText(GradientSteganogramDecoder.decode(this.plate, this.tfGradient.getText()));
    }
}

