/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.repair;

import de.jave.jave.algorithm.repair.AsciiRepairRule;
import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import de.jave.lib.io.IoUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public final class AsciiRepairAlgorithmConfiguration
implements IJaveInitializable {
    private AsciiRepairRule[] rules = new AsciiRepairRule[0];
    private int identical = 0;
    private int identicalLeft = 0;
    private int identicalRight = 0;
    private static final AsciiRepairAlgorithmConfiguration instance = new AsciiRepairAlgorithmConfiguration();

    private AsciiRepairAlgorithmConfiguration() {
    }

    public final int getIdentical() {
        return this.identical;
    }

    public final void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile = context.getConfigurationFile("./config/repair.txt");
        Vector<AsciiRepairRule> v = new Vector<AsciiRepairRule>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(configurationFile));
            boolean blockCount = false;
            boolean lineCount = false;
            String line1 = br.readLine();
            while (line1 != null && (line1.length() < 1 || line1.charAt(0) == '#')) {
                line1 = br.readLine();
            }
            this.identical = Integer.parseInt(line1);
            line1 = br.readLine();
            while (line1 != null && (line1.length() < 1 || line1.charAt(0) == '#')) {
                line1 = br.readLine();
            }
            this.identicalLeft = Integer.parseInt(line1);
            line1 = br.readLine();
            while (line1 != null && (line1.length() < 1 || line1.charAt(0) == '#')) {
                line1 = br.readLine();
            }
            this.identicalRight = Integer.parseInt(line1);
            while (line1 != null) {
                line1 = br.readLine();
                while (line1 != null && (line1.length() < 1 || line1.charAt(0) == '#')) {
                    line1 = br.readLine();
                }
                if (line1 == null) break;
                String line2 = br.readLine();
                while (line2 != null && (line2.length() < 1 || line2.charAt(0) == '#')) {
                    line2 = br.readLine();
                }
                if (line2 == null) break;
                String line3 = br.readLine();
                while (line3 != null && (line3.length() < 1 || line3.charAt(0) == '#')) {
                    line3 = br.readLine();
                }
                if (line3 == null) break;
                AsciiRepairRule r = AsciiRepairRule.getFrom(line1, line2, line3);
                if (r == null) continue;
                v.addElement(r);
            }
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException(e);
            }
            catch (Throwable throwable) {
                IoUtilities.close(br);
                throw throwable;
            }
        }
        IoUtilities.close(br);
        this.rules = new AsciiRepairRule[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            this.rules[i] = (AsciiRepairRule)v.elementAt(i);
        }
    }

    public final int getIdenticalLeft() {
        return this.identicalLeft;
    }

    public final int getIdenticalRight() {
        return this.identicalRight;
    }

    public final AsciiRepairRule[] getRules() {
        return this.rules;
    }

    public static final AsciiRepairAlgorithmConfiguration getInstance() {
        return instance;
    }
}

