/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.camel;

import de.jave.gui.CharField;
import de.jave.gui.CharacterModel;
import de.jave.gui.GSliderArrangement;
import de.jave.gui.dialog.GDialog;
import de.jave.gui.io.AbstractSourceFilePanelConfiguration;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SourceFilePanel;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.gui.ImagePanel;
import de.jave.jave.Jave;
import de.jave.jave.algorithm.camel.Camel;
import de.jave.jave.algorithm.camel.CamelMode;
import de.jave.jave.watermark.ImageIOUtilities;
import de.jave.lib.CharacterPlate;
import de.jave.lib.gui.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogPanel;
import net.disy.commons.swing.layout.grid.IDialogComponent;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutUtilities;

public final class CamelDialog {
    private Jave jave;
    private GSliderArrangement slaBrightness;
    private boolean applied = false;
    private JCheckBox cbNegative;
    private JComboBox chMode;
    private final CharacterModel cfFillChar = new CharacterModel(':');
    private ImagePanel icPreview;
    private ImagePanel sourceImagePanel;
    private CharacterPlate sourcePlate;
    private Camel camel;
    private final JDialog dialog;

    public CamelDialog(Jave parent, FileModel currentDirectoryModel) {
        this.dialog = GDialog.createJDialog(parent.getFrame(), "Camelizer - Form current text to shape from image file", true);
        this.jave = parent;
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                CamelDialog.this.dialog.setVisible(false);
            }
        });
        this.dialog.getContentPane().setLayout(new BorderLayout());
        final IFileChooserConfiguration fileChooserConfiguration = ImageIOUtilities.createImageOpenFileChooserConfiguration(currentDirectoryModel);
        AbstractSourceFilePanelConfiguration configuration = new AbstractSourceFilePanelConfiguration(this){

            public final String getOpenButtonToolTipText() {
                return "Open Image File";
            }

            public final IFileChooserConfiguration getFileChooserConfiguration() {
                return fileChooserConfiguration;
            }

            public final String getLabel() {
                return "Image:";
            }
        };
        SourceFilePanel sourceFilePanel = new SourceFilePanel(new FileModel(), configuration){

            protected final boolean performOpenFile(Component parentComponent, File file) {
                return CamelDialog.this.performOpen(parentComponent, file);
            }
        };
        this.sourceImagePanel = new ImagePanel();
        this.chMode = new JComboBox<CamelMode>(CamelMode.getAll());
        this.chMode.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                CamelDialog.this.convert();
            }
        });
        CharField cfFillCharField = new CharField(this.cfFillChar);
        this.cfFillChar.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                CamelDialog.this.convert();
            }
        });
        this.slaBrightness = new GSliderArrangement("Brightness:", -10, 10, 0, 1, 10);
        this.slaBrightness.getModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                CamelDialog.this.convert();
            }
        });
        this.cbNegative = new JCheckBox("Negative Image", false);
        this.cbNegative.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                CamelDialog.this.convert();
            }
        });
        GridDialogPanel sourceOptionsPanel = new GridDialogPanel();
        sourceOptionsPanel.add(this.slaBrightness);
        sourceOptionsPanel.add(new IDialogComponent(){

            public final int getColumnCount() {
                return 1;
            }

            public final void fillInto(JPanel panel, int columnCount) {
                GridDialogLayoutData data = new GridDialogLayoutData();
                data.setHorizontalSpan(columnCount);
                panel.add((Component)CamelDialog.this.cbNegative, data);
            }
        });
        JPanel leftPanel = new JPanel(new BorderLayout(LayoutUtilities.getComponentSpacing(), LayoutUtilities.getComponentSpacing()));
        leftPanel.setBorder(new TitledBorder("Shape image:"));
        leftPanel.add((Component)sourceFilePanel.createPanel(), "North");
        leftPanel.add((Component)this.sourceImagePanel.getContent(), "Center");
        this.icPreview = new ImagePanel();
        JPanel conversionOptionsPanel = new JPanel(new GridDialogLayout(2, false));
        conversionOptionsPanel.add((Component)new JLabel("Text mode:"), GridDialogLayoutData.RIGHT);
        conversionOptionsPanel.add(this.chMode);
        conversionOptionsPanel.add((Component)new JLabel("Fill character:"), GridDialogLayoutData.RIGHT);
        conversionOptionsPanel.add(cfFillCharField);
        conversionOptionsPanel.setBorder(new TitledBorder("Conversion Options:"));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new GridDialogLayout(1, false));
        rightPanel.add(this.icPreview.getContent());
        rightPanel.add(sourceOptionsPanel.getContent());
        rightPanel.setBorder(new TitledBorder("Shape mask:"));
        JPanel p0 = new JPanel(new GridLayout(0, 2));
        p0.add(leftPanel);
        p0.add(rightPanel);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)p0, "Center");
        mainPanel.add((Component)conversionOptionsPanel, "South");
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(new SmartAction("&OK"){

            protected final void execute(Component parentComponent) {
                if (CamelDialog.this.applied) {
                    CamelDialog.this.jave.saveCurrentState("camelize");
                    CamelDialog.this.applied = false;
                }
                CamelDialog.this.dialog.setVisible(false);
            }
        });
        buttonPanelBuilder.add(new SmartAction("&Cancel"){

            protected final void execute(Component parentComponent) {
                if (CamelDialog.this.applied) {
                    CamelDialog.this.jave.setContentOfInterest(CamelDialog.this.sourcePlate);
                    CamelDialog.this.applied = false;
                }
                CamelDialog.this.dialog.setVisible(false);
            }
        });
        this.dialog.getContentPane().add((Component)mainPanel, "Center");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.pack();
        GuiUtilities.centerToParent(this.dialog);
    }

    private boolean performOpen(Component parentComponent, File file) {
        BufferedImage loadedImage = null;
        try {
            loadedImage = ImageIO.read(file);
        }
        catch (RuntimeException e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("Camelizer", "Unknown error loading image. Wrong file format?\nSupported formats: GIF, JPG, BMP (experimental).", MessageType.ERROR, e));
            return false;
        }
        catch (IOException e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("Camelizer", "Error loading image.", MessageType.ERROR, e));
            return false;
        }
        GGreyscaleImage image = Camel.loadImage(loadedImage, this.dialog);
        this.camel.setRawImage(image);
        this.sourceImagePanel.setImage(image);
        this.convert();
        return true;
    }

    public final void setSourceText(CharacterPlate cp) {
        this.sourcePlate = cp;
        if (this.camel != null) {
            this.camel.setSourceText(cp.toString());
        } else {
            this.camel = new Camel(cp.toString());
        }
        this.convert();
    }

    protected final void convert() {
        if (this.camel == null || !this.camel.checkReady()) {
            return;
        }
        CharacterPlate result = this.camel.camelize((CamelMode)this.chMode.getSelectedItem(), this.cbNegative.isSelected(), this.slaBrightness.getDValue(), this.cfFillChar.getCharacter());
        this.icPreview.setImage(this.camel.getPreviewImage());
        this.jave.setContentOfInterest(result);
        this.applied = true;
    }

    public final void show() {
        this.dialog.setVisible(true);
    }
}

