/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.image.Rotation;
import de.jave.image2ascii.RotationUi;
import de.jave.jave.JaveSelection;
import de.jave.jave.actions.AbstractJaveUndoableAction;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.actions.enablestrategy.TextAndAnimationEditorEnabledStrategy;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.lib.BooleanPlate;
import de.jave.lib.CharacterPlate;
import java.awt.Component;

public final class Rotate180StaticAction
extends AbstractJaveUndoableAction {
    public Rotate180StaticAction(JaveMainPanel mainPanel) {
        super(mainPanel, "180 degrees", new RotationUi().getIcon(Rotation.UPSIDE_DOWN));
    }

    protected final String getActionName() {
        return "rotate 180 degrees";
    }

    protected final JaveSelection apply(Component parentComponent, JaveSelection selection) {
        return Rotate180StaticAction.applyTo(selection);
    }

    public static final JaveSelection applyTo(JaveSelection selection) {
        BooleanPlate mask;
        char t;
        CharacterPlate plate = selection.getContent();
        char[][] ch = plate.getContent();
        int h = plate.getHeight();
        int w = plate.getWidth();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w / 2; ++x) {
                t = ch[y][x];
                ch[y][x] = ch[h - y - 1][w - x - 1];
                ch[h - y - 1][w - x - 1] = t;
            }
        }
        if (w % 2 != 0) {
            int x = w / 2;
            for (int y = 0; y < h / 2; ++y) {
                t = ch[y][x];
                ch[y][x] = ch[h - y - 1][x];
                ch[h - y - 1][x] = t;
            }
        }
        if ((mask = selection.getMask()) != null) {
            boolean t2;
            boolean[][] m = mask.getContent();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w / 2; ++x) {
                    t2 = m[y][x];
                    m[y][x] = m[h - y - 1][w - x - 1];
                    m[h - y - 1][w - x - 1] = t2;
                }
            }
            if (w % 2 != 0) {
                int x = w / 2;
                for (int y = 0; y < h / 2; ++y) {
                    t2 = m[y][x];
                    m[y][x] = m[h - y - 1][x];
                    m[h - y - 1][x] = t2;
                }
            }
        }
        return selection;
    }

    protected final IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return TextAndAnimationEditorEnabledStrategy.getInstance();
    }
}

