/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.JaveSelection;
import de.jave.jave.algorithm.GeneralAlgorithm;
import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.lib.BooleanPlate;

public final class MirrorDynamicAction
extends JaveAlgorithm {
    private static MirrorDynamicAction instance;

    private MirrorDynamicAction() {
    }

    public static final synchronized MirrorDynamicAction getInstance() {
        if (instance == null) {
            instance = new MirrorDynamicAction();
        }
        return instance;
    }

    public final String getActionName() {
        return "mirror";
    }

    public final String getMenuItemLabel() {
        return "Mirror dynamic";
    }

    public final JaveSelection apply(JaveSelection plate) {
        int h = plate.getHeight();
        int w = plate.getWidth();
        char[][] ch = plate.getContent().getContent();
        for (int y = 0; y < h; ++y) {
            int x;
            for (x = 0; x < w / 2; ++x) {
                char t = ch[y][x];
                ch[y][x] = ch[y][w - x - 1];
                ch[y][w - x - 1] = t;
            }
            for (x = 0; x < w; ++x) {
                if (ch[y][x] < ' ' || ch[y][x] > '~') continue;
                ch[y][x] = GeneralAlgorithm.getMirror().charAt(ch[y][x] - 32);
            }
        }
        BooleanPlate mask = plate.getMask();
        if (mask != null) {
            boolean[][] m = mask.getContent();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w / 2; ++x) {
                    boolean t = m[y][x];
                    m[y][x] = m[y][w - x - 1];
                    m[y][w - x - 1] = t;
                }
            }
        }
        return plate;
    }
}

