/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions.fileimport;

import de.jave.jave.PlateDocument;
import de.jave.jave.actions.fileimport.AbstractImportWizardPage;
import de.jave.jave.actions.fileimport.AsciimationImportHeuristic;
import de.jave.jave.actions.fileimport.AsciimationImportOptionsPanel;
import de.jave.jave.actions.fileimport.ImportWizard;
import de.jave.jave.actions.fileimport.ImportWizardModel;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.javeplayer.JaveAnimationFrame;
import de.jave.javeplayer.JavePlayer;
import de.jave.lib.CharacterPlate;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class AsciimationImportPage
extends AbstractImportWizardPage {
    private static final IBasicMessage DEFAULT_MESSAGE = new BasicMessage("Select the options for ascii animation import. You can adjust how the file is separated into frames and preview the result in the player panel.");
    private AsciimationImportOptionsPanel optionsPanel;

    public AsciimationImportPage(ImportWizard wizard, ImportWizardModel model) {
        super("Ascii animation import options", DEFAULT_MESSAGE, wizard, model);
    }

    protected final JComponent createContent() {
        this.getModel().getAsciimationOptionsModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AsciimationImportPage.this.performImport();
            }
        });
        this.getModel().getImportedAnimationModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AsciimationImportPage.this.checkInputValid();
            }
        });
        this.optionsPanel = new AsciimationImportOptionsPanel(this.getModel().getAsciimationOptionsModel());
        final JavePlayer javePlayer = new JavePlayer();
        this.getModel().getImportedAnimationModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                javePlayer.setAnimationFile(AsciimationImportPage.this.getModel().getImportedAnimationModel().getAnimationFile());
            }
        });
        JPanel panel = new JPanel(new GridDialogLayout(1, false));
        panel.add(new JLabel("Options:"));
        GridDialogLayoutData insettedData = new GridDialogLayoutData();
        insettedData.setHorizontalIndent(22);
        panel.add((Component)this.optionsPanel.getContent(), insettedData);
        panel.add(new JLabel("Preview:"));
        GridDialogLayoutData playerData = new GridDialogLayoutData(GridDialogLayoutData.FILL_BOTH);
        playerData.setHorizontalIndent(22);
        panel.add((Component)javePlayer, playerData);
        return panel;
    }

    protected final IBasicMessage createCurrentMessage() {
        return this.getDefaultMessage();
    }

    public final void requestFocus() {
        this.optionsPanel.requestFocus();
    }

    public final boolean canFinish() {
        return this.getModel().getImportedAnimationModel().getAnimationFile() != null;
    }

    public final void pageActivated() {
        if (this.getModel().getImportedAnimationModel().getAnimationFile() == null || !this.getModel().getImportedAnimationModel().getSourceFile().equals(this.getModel().getSourceFileModel().getFile())) {
            this.performImport();
        }
    }

    private void performImport() {
        try {
            if (this.getModel().getSourceFileContent() == null) {
                String[] lines = PlateDocument.readAsciiFileLines(this.getModel().getSourceFileModel().getFile());
                this.getModel().setSourceFileContent(lines);
                AsciimationImportHeuristic.initialize(lines, this.getModel().getAsciimationOptionsModel());
                return;
            }
            String[] lines = this.getModel().getSourceFileContent();
            JaveAnimationFile animationFile = new JaveAnimationFile();
            animationFile.getProperties().setFrameDuration(this.getModel().getAsciimationOptionsModel().getFrameDuration());
            int lineIndex = 0;
            for (lineIndex = 0 + this.getModel().getAsciimationOptionsModel().getSkipTop(); lineIndex < lines.length; lineIndex += this.getModel().getAsciimationOptionsModel().getFrameGap()) {
                int frameHeight = this.getModel().getAsciimationOptionsModel().getFrameHeight();
                if (frameHeight + lineIndex > lines.length) {
                    frameHeight = lines.length - lineIndex;
                }
                String[] currentLines = new String[frameHeight];
                System.arraycopy(lines, lineIndex, currentLines, 0, frameHeight);
                JaveAnimationFrame frame = new JaveAnimationFrame();
                frame.setContent(new CharacterPlate(currentLines));
                animationFile.add(frame);
                lineIndex += frameHeight;
            }
            AsciimationImportPage.adjustFrameSizes(animationFile);
            this.getModel().getImportedAnimationModel().setAnimation(this.getModel().getSourceFileModel().getFile(), animationFile);
            return;
        }
        catch (IOException e) {
            this.getModel().getImportedAnimationModel().setAnimation(this.getModel().getSourceFileModel().getFile(), null);
            e.printStackTrace();
            return;
        }
    }

    private static void adjustFrameSizes(JaveAnimationFile animationFile) {
        int i;
        int maxWidth = 0;
        int maxHeight = 0;
        for (i = 0; i < animationFile.getFrameCount(); ++i) {
            Dimension size = new CharacterPlate(animationFile.getFrame(i).getContent()).getSize();
            if (size.width > maxWidth) {
                maxWidth = size.width;
            }
            if (size.height <= maxHeight) continue;
            maxHeight = size.height;
        }
        for (i = 0; i < animationFile.getFrameCount(); ++i) {
            CharacterPlate plate = new CharacterPlate(animationFile.getFrame(i).getContent());
            plate.setSize(maxWidth, maxHeight);
            animationFile.getFrame(i).setContent(plate);
        }
    }
}

