/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.jave.actions.AbstractJaveAction;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.actions.enablestrategy.TextAndAnimationEditorEnabledStrategy;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.clipart.Clipart;
import de.jave.jave.clipart.ClipartGroup;
import de.jave.jave.clipart.ClipartManager;
import de.jave.jave.clipart.ClipartNewEntryModel;
import de.jave.jave.clipart.ClipartNewEntryPage;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.javeplayer.AsciiPacker;
import de.jave.lib.CharacterPlate;
import java.awt.Component;
import net.disy.commons.swing.dialog.userdialog.UserDialog;

public final class SelectionToClipartAction
extends AbstractJaveAction {
    public SelectionToClipartAction(JaveMainPanel mainPanel) {
        super(mainPanel, "Export to Clipart", JaveImageProvider.getInstance().getImageIcon("clipart_export.gif"));
    }

    protected final IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return TextAndAnimationEditorEnabledStrategy.getInstance();
    }

    protected final void ececute(Component parentComponent, IDocumentEditor editor) {
        ClipartManager manager = ClipartManager.performLoad(parentComponent);
        if (manager == null) {
            return;
        }
        if (!editor.getPlate().hasSelection()) {
            return;
        }
        CharacterPlate ch = editor.getPlate().getSelectionContent();
        ClipartNewEntryModel model = new ClipartNewEntryModel(ch);
        UserDialog dialog = new UserDialog(parentComponent, new ClipartNewEntryPage(model, manager));
        dialog.show();
        if (dialog.isCanceled()) {
            return;
        }
        Clipart newClipart = new Clipart(model.getName(), AsciiPacker.encode(model.getCode().getContent()), model.getAuthor());
        String groupName = model.getGroupName();
        ClipartGroup group = manager.getGroup(groupName);
        if (group == null) {
            group = new ClipartGroup(groupName);
        }
        group.add(newClipart);
        manager.performSave(parentComponent, group);
    }
}

