/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.ascii.font.ChooseDisplayFontAction;
import de.jave.asciimation.action.AddNewFrameAction;
import de.jave.asciimation.action.AnimationEditorPropertiesAction;
import de.jave.asciimation.action.DeleteFrameAction;
import de.jave.asciimation.action.DuplicateFrameAction;
import de.jave.asciimation.action.ExportAnimationEditorAction;
import de.jave.asciimation.action.OpenAnimationAction;
import de.jave.gui.GTextArea;
import de.jave.gui.dialog.GDialog;
import de.jave.gui.layout.VFlowLayout;
import de.jave.gui.splash.StartupException;
import de.jave.jave.CharSetsConfiguration;
import de.jave.jave.CharacterSets;
import de.jave.jave.ColorScreenSaver;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.OptionsDialog;
import de.jave.jave.actions.AsctrisAction;
import de.jave.jave.actions.ConvertMakingOfToAnimationAction;
import de.jave.jave.actions.CropAction;
import de.jave.jave.actions.DecodeSteganogramAction;
import de.jave.jave.actions.FigletExportWizardAction;
import de.jave.jave.actions.JaveActions;
import de.jave.jave.actions.LabyrinthAction;
import de.jave.jave.actions.SelectionToClipartAction;
import de.jave.jave.actions.VersionCheckAction;
import de.jave.jave.actions.fileimport.JaveImportAction;
import de.jave.jave.algorithm.AlignLeft;
import de.jave.jave.algorithm.AlignRight;
import de.jave.jave.algorithm.AsciiAntialiasing;
import de.jave.jave.algorithm.Asciify;
import de.jave.jave.algorithm.Brightness;
import de.jave.jave.algorithm.Center;
import de.jave.jave.algorithm.CenterByTheLine;
import de.jave.jave.algorithm.Clear;
import de.jave.jave.algorithm.CompressExpand;
import de.jave.jave.algorithm.FlipDynamicAction;
import de.jave.jave.algorithm.FlipStatic;
import de.jave.jave.algorithm.Invert;
import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.jave.algorithm.JaveAlgorithmMenuItem;
import de.jave.jave.algorithm.LowerCase;
import de.jave.jave.algorithm.MirrorDynamicAction;
import de.jave.jave.algorithm.MirrorStatic;
import de.jave.jave.algorithm.RepairWrapped;
import de.jave.jave.algorithm.Rot13;
import de.jave.jave.algorithm.Rotate180Action;
import de.jave.jave.algorithm.Rotate180StaticAction;
import de.jave.jave.algorithm.Rotate90LeftAction;
import de.jave.jave.algorithm.Rotate90LeftStaticAction;
import de.jave.jave.algorithm.Rotate90RightAction;
import de.jave.jave.algorithm.Rotate90RightStaticAction;
import de.jave.jave.algorithm.ShakeLines;
import de.jave.jave.algorithm.Unasciify;
import de.jave.jave.algorithm.UpperCase;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.application.startup.JaveStartupRunnable;
import de.jave.jave.plate.DocumentEditorTitleFactory;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.lib.gui.GuiUtilities;
import de.jave.preferences.JavePreferences;
import de.jave.util.RecentFileList;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.message.Message;
import net.disy.commons.swing.action.ActionWidgetFactory;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.menu.HelpImplementedMenuBar;

public final class JaveMenuBar
extends HelpImplementedMenuBar
implements ActionListener {
    private Jave jave;
    private JMenu menuWindows;
    private JMenu menuColor;
    private JMenu menuView;
    private JMenu menuModify;
    private JMenu menuSelection;
    private JMenu menuCharacterSets;
    private JMenuItem miRevert;
    private JMenuItem miClose;
    private JMenuItem miCloseAll;
    private JMenuItem miUndo;
    private JMenuItem miRedo;
    private JMenuItem miCut;
    private JMenuItem miCopy;
    private JMenuItem miPaste;
    private JMenuItem miPasteNew;
    private JMenuItem miSelectAll;
    private JMenuItem miClear;
    private JMenuItem miReplace;
    private JMenuItem miDocs;
    private JMenuItem miDocsOnline;
    private JMenuItem miAscii2Gif;
    private JMenuItem miCrash;
    private JMenuItem miRender3D;
    private JMenuItem miFunctionPlotter;
    private JMenuItem miLife;
    private JMenuItem miDoc2Watermark;
    private JMenuItem miRepairShaked;
    private JMenuItem miRepairIllegalReplace;
    private JMenuItem miRepairIllegalRemove;
    private JMenuItem miZoomPlus;
    private JMenuItem miZoomMinus;
    private JMenuItem miNextWindow;
    private JMenuItem miPreviousWindow;
    private JCheckBoxMenuItem[] miColorSchemes;
    private JCheckBoxMenuItem[] miCharacters;
    private JCheckBoxMenuItem[] windowMenuItems;
    private JMenuItem miSelectionToBrush;
    private JMenuItem miSelectionShrink;
    private JMenuItem miSelectionExpand;
    private JMenuItem miSelectionBrace;
    private JMenuItem miSelectionDelete;
    private JMenuItem miOptionsDialog;
    private final List docOpenEnabledMenuItems = new ArrayList();
    private final JaveApplicationPreferences preferences;
    private static final int[] windowShortcuts = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};

    public JaveMenuBar(final Jave jave, JavePreferences javePreferences, JaveMainPanel mainPanel, JaveActions actions, RecentFileList recentFileList, JaveApplicationPreferences preferences) {
        int i;
        ButtonGroup bg;
        JaveGlobalRessources.getColorSchemeModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                JaveMenuBar.this.updateColorMenu();
            }
        });
        this.jave = jave;
        this.preferences = preferences;
        this.miRevert = this.createMenuItem("Revert");
        this.miClose = this.createMenuItem("Close");
        this.miClose.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        this.miCloseAll = this.createMenuItem("Close All");
        this.miAscii2Gif = this.createMenuItem("Ascii2Gif");
        SmartAction exitAction = new SmartAction(this, "Exit"){

            protected final void execute(Component parentComponent) {
                jave.performExit(parentComponent);
            }
        };
        JMenu menuRecent = new JMenu("Recent Files");
        menuRecent.setIcon(JaveImageProvider.getInstance().getImageIcon("open_recent.gif"));
        recentFileList.setMenu(menuRecent);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.add(actions.getNewDocumentAction());
        fileMenu.addSeparator();
        fileMenu.add(actions.getOpenAction());
        fileMenu.add(this.miRevert);
        fileMenu.add(menuRecent);
        fileMenu.add(actions.getBrowseAction());
        fileMenu.addSeparator();
        fileMenu.add(this.miClose);
        fileMenu.add(this.miCloseAll);
        fileMenu.addSeparator();
        fileMenu.add(actions.getSaveAction());
        fileMenu.add(actions.getSaveAsAction());
        fileMenu.add(actions.getSaveAllAction());
        fileMenu.addSeparator();
        fileMenu.add(new ConvertMakingOfToAnimationAction(preferences, jave, mainPanel));
        fileMenu.add(this.miAscii2Gif);
        fileMenu.addSeparator();
        fileMenu.add(exitAction);
        JMenu animationMenu = new JMenu("Animation");
        animationMenu.setMnemonic('A');
        animationMenu.add(actions.getNewAnimationAction());
        animationMenu.addSeparator();
        animationMenu.add(new OpenAnimationAction(mainPanel, jave, jave.getDocumentManager().getCurrentDirectoryModel()));
        animationMenu.addSeparator();
        animationMenu.add(new JaveImportAction(jave, jave.getDocumentManager().getCurrentDirectoryModel()));
        animationMenu.add(new ExportAnimationEditorAction(mainPanel, jave.getDocumentManager().getCurrentDirectoryModel(), preferences.getDisplayFontModel(), new AnimationExportPreferences(javePreferences)));
        animationMenu.addSeparator();
        animationMenu.add(new AddNewFrameAction(mainPanel));
        animationMenu.add(new DuplicateFrameAction(mainPanel));
        animationMenu.add(new DeleteFrameAction(mainPanel));
        animationMenu.addSeparator();
        animationMenu.add(new AnimationEditorPropertiesAction(mainPanel));
        this.miUndo = this.createMenuItem("Undo");
        this.miUndo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.miRedo = this.createMenuItem("Redo");
        this.miRedo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.miCut = this.createMenuItem("Cut");
        this.miCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        this.miCopy = this.createMenuItem("Copy");
        this.miCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.miPaste = this.createMenuItem("Paste As New Selection");
        this.miPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        this.miPasteNew = this.createMenuItem("Paste As New Document");
        this.miSelectAll = this.createMenuItem("Select All");
        this.miSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.miClear = this.createMenuItem(new Clear());
        this.miReplace = this.createMenuItem("Replace...");
        this.miReplace.setAccelerator(KeyStroke.getKeyStroke(72, 128));
        JMenu menuEdit = new JMenu("Edit");
        menuEdit.setMnemonic('E');
        menuEdit.add(this.miUndo);
        menuEdit.add(this.miRedo);
        menuEdit.addSeparator();
        menuEdit.add(this.miCut);
        menuEdit.add(this.miCopy);
        menuEdit.add(this.miPaste);
        menuEdit.add(this.miPasteNew);
        menuEdit.addSeparator();
        menuEdit.add(this.miSelectAll);
        menuEdit.addSeparator();
        menuEdit.add(this.miClear);
        menuEdit.add(new CropAction(jave, mainPanel));
        menuEdit.add(actions.getResizeAction());
        menuEdit.addSeparator();
        menuEdit.add(this.miReplace);
        JMenuItem miAntiAlias = this.createMenuItem(new AsciiAntialiasing());
        JMenuItem miRot13 = this.createMenuItem(new Rot13());
        JMenuItem miToUpperCase = this.createMenuItem(new UpperCase());
        JMenuItem miToLowerCase = this.createMenuItem(new LowerCase());
        JMenuItem miAsciify = this.createMenuItem(new Asciify());
        JMenuItem miUnasciify = this.createMenuItem(new Unasciify());
        JMenuItem miCenter = this.createMenuItem(new Center());
        JMenuItem miCenterByTheLine = this.createMenuItem(CenterByTheLine.getInstance());
        JMenuItem miAlignRight = this.createMenuItem(AlignRight.getInstance());
        JMenuItem miAlignLeft = this.createMenuItem(AlignLeft.getInstance());
        JMenuItem miFlip = this.createMenuItem(FlipDynamicAction.getInstance());
        miFlip.setIcon(JaveImageProvider.getInstance().getImageIcon("menu/flip_dynamic.gif"));
        JMenuItem miMirrorDynamic = this.createMenuItem(MirrorDynamicAction.getInstance());
        miMirrorDynamic.setIcon(JaveImageProvider.getInstance().getImageIcon("menu/mirror_dynamic.gif"));
        JMenu miRotate = new JMenu("Rotate dynamic");
        miRotate.setIcon(JaveImageProvider.getInstance().getImageIcon("menu/rotate_dynamic.gif"));
        miRotate.add(new Rotate180Action(mainPanel));
        miRotate.add(new Rotate90RightAction(mainPanel));
        miRotate.add(new Rotate90LeftAction(mainPanel));
        JMenuItem miFlipStatic = this.createMenuItem(FlipStatic.getInstance());
        miFlipStatic.setIcon(JaveImageProvider.getInstance().getImageIcon("menu/flip_static.gif"));
        JMenuItem miMirrorStatic = this.createMenuItem(MirrorStatic.getInstance());
        miMirrorStatic.setIcon(JaveImageProvider.getInstance().getImageIcon("menu/mirror_static.gif"));
        JMenu miRotateStatic = new JMenu("Rotate static");
        miRotateStatic.setIcon(JaveImageProvider.getInstance().getImageIcon("menu/rotate_static.gif"));
        miRotateStatic.add(new Rotate180StaticAction(mainPanel));
        miRotateStatic.add(new Rotate90RightStaticAction(mainPanel));
        miRotateStatic.add(new Rotate90LeftStaticAction(mainPanel));
        JMenuItem miShake = this.createMenuItem(new ShakeLines());
        this.miRepairIllegalReplace = this.createMenuItem("Replace illegal characters");
        this.miRepairIllegalRemove = this.createMenuItem("Remove illegal characters");
        this.miRepairShaked = this.createMenuItem("Shaked lines");
        JMenuItem miRepairWrapped = this.createMenuItem(new RepairWrapped());
        JMenuItem miInvert = this.createMenuItem(new Invert());
        JMenuItem miBrightness = this.createMenuItem(Brightness.getInstance());
        JMenuItem miCompress = this.createMenuItem(CompressExpand.getInstance());
        JMenu menuRepair = new JMenu("Try to Repair");
        menuRepair.add(this.miRepairIllegalReplace);
        menuRepair.add(this.miRepairIllegalRemove);
        menuRepair.addSeparator();
        menuRepair.add(miRepairWrapped);
        menuRepair.add(this.miRepairShaked);
        JMenu menuTransform = new JMenu("Transform");
        menuTransform.add(miFlip);
        menuTransform.add(miMirrorDynamic);
        menuTransform.add(miRotate);
        menuTransform.addSeparator();
        menuTransform.add(miFlipStatic);
        menuTransform.add(miMirrorStatic);
        menuTransform.add(miRotateStatic);
        this.menuModify = new JMenu("Modify");
        this.menuModify.setMnemonic('M');
        this.menuModify.add(miRot13);
        this.menuModify.add(miToLowerCase);
        this.menuModify.add(miToUpperCase);
        this.menuModify.add(miAsciify);
        this.menuModify.add(miUnasciify);
        this.menuModify.addSeparator();
        this.menuModify.add(miCenter);
        this.menuModify.add(miCenterByTheLine);
        this.menuModify.add(miAlignRight);
        this.menuModify.add(miAlignLeft);
        this.menuModify.addSeparator();
        this.menuModify.add(menuTransform);
        this.menuModify.add(miInvert);
        this.menuModify.add(miBrightness);
        this.menuModify.addSeparator();
        this.menuModify.add(miShake);
        this.menuModify.add(menuRepair);
        this.menuModify.add(miAntiAlias);
        this.menuModify.addSeparator();
        this.menuModify.add(miCompress);
        String[] s = CharacterSets.getCharsetNames();
        if (s != null && s.length > 1) {
            int defaultCharsetIndex = CharacterSets.getDefaultCharsetIndex();
            this.menuCharacterSets = new JMenu("Character Set");
            this.miCharacters = new JCheckBoxMenuItem[s.length];
            bg = new ButtonGroup();
            for (i = 0; i < s.length; ++i) {
                final int index = i;
                this.miCharacters[i] = new JCheckBoxMenuItem(s[i], i == defaultCharsetIndex);
                this.miCharacters[i].addActionListener(new ActionListener(){

                    public final void actionPerformed(ActionEvent e) {
                        JaveMenuBar.this.setCurrentCharsetIndex(index, jave);
                        CharacterSets.setCurrentCharsetIndex(index);
                        jave.getMainPanel().getPlate().repaint();
                    }
                });
                bg.add(this.miCharacters[i]);
                this.menuCharacterSets.add(this.miCharacters[i]);
                if (i != 0 && i != s.length - 2) continue;
                this.menuCharacterSets.addSeparator();
            }
        }
        this.menuView = new JMenu("View");
        this.menuView.setMnemonic(86);
        this.miZoomPlus = this.createMenuItem("Zoom in");
        this.miZoomMinus = this.createMenuItem("Zoom out");
        this.miOptionsDialog = this.createMenuItem("Options");
        this.menuColor = new JMenu("Color");
        ColorScheme[] colorSchemes = ColorScheme.getAll();
        this.miColorSchemes = new JCheckBoxMenuItem[colorSchemes.length];
        bg = new ButtonGroup();
        for (i = 0; i < colorSchemes.length; ++i) {
            final ColorScheme scheme = colorSchemes[i];
            this.miColorSchemes[i] = new JCheckBoxMenuItem(colorSchemes[i].getName(), colorSchemes[i].getIcon());
            this.miColorSchemes[i].addActionListener(new ActionListener(this){

                public final void actionPerformed(ActionEvent e) {
                    jave.performSetColorScheme(scheme);
                }
            });
            bg.add(this.miColorSchemes[i]);
            this.menuColor.add(this.miColorSchemes[i]);
        }
        this.menuView.add(this.miZoomPlus);
        this.menuView.add(this.miZoomMinus);
        this.menuView.addSeparator();
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getToolOptionsDialogToggleAction()));
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getRulerToggleAction()));
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getGridToggleAction()));
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getMarkIllegalToggleAction()));
        this.menuView.add(ActionWidgetFactory.createToggleMenuItem(actions.getConnectedLinesViewToggleAction()));
        if (this.menuCharacterSets != null) {
            this.menuView.add(this.menuCharacterSets);
        }
        this.menuView.addSeparator();
        this.menuView.add(this.menuColor);
        this.menuView.add(new ChooseDisplayFontAction(preferences.getDisplayFontModel()));
        this.menuView.add(this.miOptionsDialog);
        this.menuWindows = new JMenu("Window");
        this.menuWindows.setMnemonic(87);
        this.menuSelection = new JMenu("Selection");
        this.menuSelection.setMnemonic(83);
        this.menuSelection.setEnabled(false);
        this.miSelectionToBrush = this.createMenuItem("Use as Brush");
        this.miSelectionExpand = this.createMenuItem("Expand");
        this.miSelectionShrink = this.createMenuItem("Shrink to fit");
        this.miSelectionBrace = this.createMenuItem("Add brace");
        this.miSelectionDelete = this.createMenuItem("Delete");
        this.menuSelection.add(this.miSelectionToBrush);
        this.menuSelection.add(new SelectionToClipartAction(mainPanel));
        this.menuSelection.addSeparator();
        this.menuSelection.add(this.miSelectionExpand);
        this.menuSelection.add(this.miSelectionShrink);
        this.menuSelection.addSeparator();
        this.menuSelection.add(this.miSelectionBrace);
        this.menuSelection.addSeparator();
        this.menuSelection.add(this.miSelectionDelete);
        JMenu menuTools = new JMenu("Tools");
        menuTools.setMnemonic(84);
        menuTools.add(actions.getCamelizerAction());
        menuTools.addSeparator();
        menuTools.add(actions.getImage2AsciiAction());
        menuTools.add(actions.getFigletAction());
        menuTools.add(actions.getClipartLibraryAction());
        menuTools.add(actions.getTextBoxAction());
        menuTools.add(actions.getMathematicalExpressionsAction());
        menuTools.addSeparator();
        menuTools.add(new FigletExportWizardAction(mainPanel));
        this.miRender3D = this.createMenuItem("Render 3D");
        this.miFunctionPlotter = this.createMenuItem("Function Plotter");
        this.miLife = this.createMenuItem("Game of Life Screensaver");
        this.miDoc2Watermark = this.createMenuItem("Set Content as Watermark");
        JMenu menuSpecial = new JMenu("Special");
        menuSpecial.setMnemonic(80);
        menuSpecial.add(actions.getFractalAction());
        menuSpecial.add(this.miRender3D);
        menuSpecial.add(this.miFunctionPlotter);
        menuSpecial.addSeparator();
        menuSpecial.add(new AsctrisAction(jave));
        menuSpecial.add(new LabyrinthAction(jave));
        menuSpecial.addSeparator();
        menuSpecial.add(this.miLife);
        menuSpecial.addSeparator();
        menuSpecial.add(this.miDoc2Watermark);
        menuSpecial.addSeparator();
        menuSpecial.add(new DecodeSteganogramAction(mainPanel));
        this.miCrash = this.createMenuItem("Crash now");
        JMenu menuDebug = new JMenu("Debug");
        menuDebug.add(new SmartAction(this, "Init configuration"){

            protected final void execute(Component parentComponent) {
                try {
                    JaveStartupRunnable.initConfigFiles(parentComponent);
                    return;
                }
                catch (StartupException e) {
                    MessageDialogFactory.showMessageDialog(parentComponent, new Message("Error loading configuration files.", e));
                    return;
                }
            }
        });
        menuDebug.addSeparator();
        menuDebug.add(this.miCrash);
        menuDebug.addSeparator();
        JMenu menuHelp = new JMenu("Help");
        menuHelp.setMnemonic(72);
        this.miDocs = this.createMenuItem("Documentation");
        this.miDocsOnline = this.createMenuItem("Online Documentation");
        menuHelp.add(this.miDocs);
        menuHelp.add(this.miDocsOnline);
        menuHelp.addSeparator();
        menuHelp.add(menuDebug);
        menuHelp.addSeparator();
        menuHelp.add(new VersionCheckAction());
        menuHelp.add(actions.getAboutAction());
        this.add(fileMenu);
        this.add(animationMenu);
        this.add(menuEdit);
        this.add(this.menuModify);
        this.add(this.menuView);
        this.add(this.menuSelection);
        this.add(menuTools);
        this.add(menuSpecial);
        this.add(this.menuWindows);
        this.setHelpMenu(menuHelp);
        this.docOpenEnabledMenuItems.add(this.miAscii2Gif);
        this.docOpenEnabledMenuItems.add(this.miCopy);
        this.docOpenEnabledMenuItems.add(this.miCut);
        this.docOpenEnabledMenuItems.add(this.miClear);
        this.docOpenEnabledMenuItems.add(this.miSelectAll);
        this.docOpenEnabledMenuItems.add(this.miClose);
        this.docOpenEnabledMenuItems.add(this.miCloseAll);
        this.docOpenEnabledMenuItems.add(this.miReplace);
        this.docOpenEnabledMenuItems.add(this.miDoc2Watermark);
        this.docOpenEnabledMenuItems.add(miInvert);
        this.docOpenEnabledMenuItems.add(miCompress);
        this.docOpenEnabledMenuItems.add(miBrightness);
        this.updateColorMenu();
        mainPanel.getActiveEditorModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                JaveMenuBar.this.updateWindowsMenu();
            }
        });
        this.updateWindowsMenu();
    }

    private final JMenuItem createMenuItem(String label) {
        JMenuItem mi = new JMenuItem(label);
        mi.addActionListener(this);
        return mi;
    }

    private final JMenuItem createMenuItem(JaveAlgorithm algorithm) {
        JaveAlgorithmMenuItem mi = new JaveAlgorithmMenuItem(algorithm);
        mi.addActionListener(this);
        return mi;
    }

    private void updateColorMenu() {
        ColorScheme colorScheme = JaveGlobalRessources.getColorSchemeModel().getColorScheme();
        ColorScheme[] schemes = ColorScheme.getAll();
        for (int i = 0; i < this.miColorSchemes.length; ++i) {
            if (schemes[i] != colorScheme) continue;
            this.miColorSchemes[i].setSelected(true);
        }
    }

    public final void setRevertEnabled(boolean what) {
        this.miRevert.setEnabled(what);
    }

    public final void updateUndoRedoMenu(boolean canUndo, String undoAction, boolean canRedo, String redoAction) {
        this.miUndo.setEnabled(canUndo);
        this.miRedo.setEnabled(canRedo);
        if (canUndo) {
            this.miUndo.setText("Undo " + undoAction);
        } else {
            this.miUndo.setText("Undo");
        }
        if (canRedo) {
            this.miRedo.setText("Redo " + redoAction);
            return;
        }
        this.miRedo.setText("Redo");
    }

    public final void updateSelectionMenu(boolean hasSelection) {
        if (this.menuSelection.isEnabled() != hasSelection) {
            this.menuSelection.setEnabled(hasSelection);
        }
    }

    private void updateWindowsMenu() {
        this.menuWindows.removeAll();
        this.miPreviousWindow = new JMenuItem("Previous");
        this.miPreviousWindow.addActionListener(this);
        this.menuWindows.add(this.miPreviousWindow);
        this.miNextWindow = new JMenuItem("Next");
        this.miNextWindow.addActionListener(this);
        this.menuWindows.add(this.miNextWindow);
        this.menuWindows.addSeparator();
        int editorCount = this.jave.getMainPanel().getEditorCount();
        boolean docOpen = editorCount > 0;
        this.menuView.setEnabled(docOpen);
        this.menuColor.setEnabled(docOpen);
        this.menuModify.setEnabled(docOpen);
        if (this.docOpenEnabledMenuItems != null) {
            for (int i = 0; i < this.docOpenEnabledMenuItems.size(); ++i) {
                ((JMenuItem)this.docOpenEnabledMenuItems.get(i)).setEnabled(docOpen);
            }
        }
        this.miPreviousWindow.setEnabled(editorCount > 1);
        this.miNextWindow.setEnabled(editorCount > 1);
        if (!docOpen) {
            this.miRevert.setEnabled(false);
            return;
        }
        this.miRevert.setEnabled(this.jave.getMainPanel().getEditor().getFile() != null);
        String[] menuTitles = this.getMenuTitles();
        this.windowMenuItems = new JCheckBoxMenuItem[menuTitles.length];
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < menuTitles.length; ++i) {
            final int index = i;
            this.windowMenuItems[i] = new JCheckBoxMenuItem(menuTitles[i]);
            this.windowMenuItems[i].setSelected(this.jave.getMainPanel().getActiveEditorModel().getActiveEditor() == this.jave.getMainPanel().getEditor(i));
            this.windowMenuItems[i].addActionListener(new ActionListener(){

                public final void actionPerformed(ActionEvent e) {
                    JaveMenuBar.this.jave.setCurrentDocument(index);
                }
            });
            bg.add(this.windowMenuItems[i]);
            if (i <= 9) {
                this.windowMenuItems[i].setMnemonic(windowShortcuts[i]);
            }
            this.menuWindows.add(this.windowMenuItems[i]);
        }
    }

    private String[] getMenuTitles() {
        JaveMainPanel mainPanel = this.jave.getMainPanel();
        String[] result = new String[mainPanel.getEditorCount()];
        for (int i = 0; i < mainPanel.getEditorCount(); ++i) {
            result[i] = i + 1 + " " + DocumentEditorTitleFactory.createShortEditorTitle(mainPanel.getEditor(i));
        }
        return result;
    }

    public final void actionPerformed(ActionEvent evt) {
        Window parentComponent = GuiUtilities.getWindowForComponent(evt);
        this.jave.getMainPanel().requestFocus();
        Object source = evt.getSource();
        if (source == this.miDocs) {
            JaveGlobalRessources.openDocumentation("index.html");
            return;
        }
        if (source == this.miDocsOnline) {
            JaveGlobalRessources.openOnlineDocumentation("index.html");
            return;
        }
        if (source == this.miOptionsDialog) {
            new OptionsDialog(this.jave, this.preferences);
            Object d = null;
            return;
        }
        if (source == this.miCrash) {
            this.jave.doDebugCrash();
            return;
        }
        if (source == this.miSelectionToBrush) {
            this.jave.doSelectionToBrush();
            return;
        }
        if (source == this.miSelectionShrink) {
            this.jave.doSelectionShrink();
            return;
        }
        if (source == this.miSelectionExpand) {
            this.jave.doSelectionExpand();
            return;
        }
        if (source == this.miSelectionDelete) {
            this.jave.doSelectionDelete();
            return;
        }
        if (source == this.miSelectionBrace) {
            this.jave.doSelectionBraces();
            return;
        }
        if (source == this.miReplace) {
            this.jave.doReplaceCharacter();
            return;
        }
        if (source == this.miRepairIllegalRemove) {
            this.jave.doRepairIllegalRemove();
            return;
        }
        if (source == this.miRepairIllegalReplace) {
            this.jave.doRepairIllegalReplace();
            return;
        }
        if (source instanceof JaveAlgorithmMenuItem) {
            this.jave.applyAlgorithm(((JaveAlgorithmMenuItem)source).getAlgorithm());
            return;
        }
        if (source == this.miLife) {
            new ColorScreenSaver(this.jave.getFrame());
            Object s = null;
            return;
        }
        if (source == this.miDoc2Watermark) {
            this.jave.doDoc2Watermark();
            return;
        }
        if (source == this.miRender3D) {
            this.jave.doRender3D();
            return;
        }
        if (source == this.miFunctionPlotter) {
            this.jave.doFunctionPlotter();
            return;
        }
        if (source == this.miUndo) {
            this.jave.doUndo();
            return;
        }
        if (source == this.miRedo) {
            this.jave.doRedo();
            return;
        }
        if (source == this.miRevert) {
            this.jave.doRevert(parentComponent);
            return;
        }
        if (source == this.miAscii2Gif) {
            this.jave.doAscii2Gif();
            return;
        }
        if (source == this.miZoomPlus) {
            this.jave.doZoomPlus();
            return;
        }
        if (source == this.miZoomMinus) {
            this.jave.doZoomMinus();
            return;
        }
        if (source == this.miCut) {
            this.jave.doCut();
            return;
        }
        if (source == this.miCopy) {
            this.jave.doCopy();
            return;
        }
        if (source == this.miPaste) {
            this.jave.doPaste();
            return;
        }
        if (source == this.miPasteNew) {
            this.jave.doPasteAsNewDocument();
            return;
        }
        if (source == this.miRepairShaked) {
            this.jave.doRepairShaked();
            return;
        }
        if (source == this.miSelectAll) {
            this.jave.selectAll();
            return;
        }
        if (source == this.miNextWindow) {
            this.jave.doNextDocument();
            return;
        }
        if (source == this.miPreviousWindow) {
            this.jave.doPreviousDocument();
            return;
        }
        if (source == this.miClose) {
            this.jave.doClose(parentComponent);
            return;
        }
        if (source == this.miCloseAll) {
            this.jave.doCloseAll(parentComponent);
            return;
        }
        System.err.println("JaveMenuBar: source unknown in actionPerformed!" + source);
    }

    private void setCurrentCharsetIndex(int index, Jave jave) {
        CharSetsConfiguration configuration = CharSetsConfiguration.getInstance();
        if (index == configuration.getUserDefinedIndex()) {
            GTextArea taSet = new GTextArea(configuration.getCharSetChatacters(index), 5, 60);
            taSet.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
            JPanel p = new JPanel(new VFlowLayout());
            p.add(taSet.getContent());
            p.add(new JLabel("(The Character [space] is always included)"));
            GDialog gd = new GDialog((Component)jave.getFrame(), "User Defined Character Set", "Legal characters:", p);
            gd.show();
            configuration.setCharsetCharacters(index, " " + taSet.getText());
        }
    }
}

