/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.asciimation.export.FileTypeIcons;
import de.jave.image2ascii.IImage2AsciiResultTaker;
import de.jave.jave.Jave;
import de.jave.jave.actions.CamelizerAction;
import de.jave.jave.actions.ClipartLibraryAction;
import de.jave.jave.actions.Image2AsciiAction;
import de.jave.jave.actions.MathematicalExpressionsAction;
import de.jave.jave.actions.ResizeDocumentAction;
import de.jave.jave.actions.SaveAction;
import de.jave.jave.actions.SaveAllAction;
import de.jave.jave.actions.SaveAsAction;
import de.jave.jave.actions.ShowFigletEditorAction;
import de.jave.jave.actions.TextBoxAction;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.jave.watermark.WatermarkImageFile;
import de.jave.lib.CharacterPlate;
import de.jave.preferences.JavePreferences;
import java.awt.Component;
import javax.swing.KeyStroke;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.action.SmartToggleAction;
import net.disy.commons.swing.fontchooser.model.FontModel;

public final class JaveActions {
    private final SmartAction newDocumentAction;
    private final SmartAction browseAction;
    private final SmartAction openAction;
    private final SmartAction aboutAction;
    private final SmartAction camelizerAction;
    private final SmartAction fractalAction;
    private final SmartAction newAnimationAction;
    private final Image2AsciiAction image2AsciiAction;
    private final SmartToggleAction toolOptionsDialogToggleAction;
    private final SmartToggleAction gridToggleAction;
    private final SmartToggleAction markIllegalToggleAction;
    private final SmartToggleAction connectedLinesViewToggleAction;
    private final SmartToggleAction rulerToggleAction;
    private final ShowFigletEditorAction figletAction;
    private final ResizeDocumentAction resizeAction;
    private final ClipartLibraryAction clipartLibraryAction;
    private final SmartAction mathematicalExpressionsAction;
    private final SmartAction textBoxAction;
    private final SmartAction saveAction;
    private final SmartAction saveAllAction;
    private final SmartAction saveAsAction;

    public JaveActions(final Jave jave, JavePreferences preferences, BooleanModel toolOptionsDialogVisibilityModel, PlatePreferences plateViewOptions, FontModel displayFontModel) {
        Ensure.ensureArgumentNotNull(displayFontModel);
        Ensure.ensureArgumentNotNull(preferences);
        this.saveAction = new SaveAction(jave, jave.getMainPanel());
        this.resizeAction = new ResizeDocumentAction(jave);
        this.newDocumentAction = new SmartAction(this, "New Document", JaveImageProvider.getInstance().getImageIcon("new.gif")){

            protected final void execute(Component parentComponent) {
                jave.doNew();
            }
        };
        this.newDocumentAction.setToolTipText("Create a new Document");
        this.newDocumentAction.setAcceleratorKey(KeyStroke.getKeyStroke(78, 128));
        this.image2AsciiAction = new Image2AsciiAction(new IImage2AsciiResultTaker(this){

            public final void takeImage2AsciiResult(CharacterPlate characterPlate, WatermarkImageFile imageFile) {
                jave.pasteAsNewDocument(characterPlate);
                if (imageFile != null) {
                    jave.setWatermarkImage(imageFile);
                }
            }
        }, jave.getMainPanel(), jave.getDocumentManager().getCurrentDirectoryModel(), displayFontModel, new AnimationExportPreferences(preferences));
        this.figletAction = new ShowFigletEditorAction(jave, jave.getMainPanel());
        this.browseAction = new SmartAction(this, "Browse...", JaveImageProvider.getInstance().getImageIcon("browse.gif")){

            protected final void execute(Component parentComponent) {
                jave.doBrowse();
            }
        };
        this.browseAction.setToolTipText("Browse ASCII Files");
        this.browseAction.setAcceleratorKey(KeyStroke.getKeyStroke(66, 128));
        this.openAction = new SmartAction(this, "Open...", JaveImageProvider.getInstance().getImageIcon("open.gif")){

            protected final void execute(Component parentComponent) {
                jave.doOpen(parentComponent);
            }
        };
        this.openAction.setToolTipText("Open an ASCII File");
        this.openAction.setAcceleratorKey(KeyStroke.getKeyStroke(79, 128));
        this.aboutAction = new SmartAction(this, "About JavE", JaveImageProvider.getInstance().getImageIcon("icon.gif")){

            protected final void execute(Component parentComponent) {
                jave.showAboutDialog();
            }
        };
        this.aboutAction.setToolTipText("About JavE");
        this.camelizerAction = new CamelizerAction(jave);
        this.fractalAction = new SmartAction(this, "Fractals", JaveImageProvider.getInstance().getImageIcon("fractal.gif")){

            protected final void execute(Component parentComponent) {
                jave.doFractal();
            }
        };
        this.newAnimationAction = new SmartAction(this, "New Animation", FileTypeIcons.ANIMATION_ICON){

            protected final void execute(Component parentComponent) {
                jave.doCreateNewAnimation(parentComponent);
            }
        };
        this.newAnimationAction.setToolTipText("Create a new Animation");
        this.toolOptionsDialogToggleAction = new SmartToggleAction(toolOptionsDialogVisibilityModel, "Tool Options Dialog", JaveImageProvider.getInstance().getImageIcon("tooldialogvisible.gif"));
        this.toolOptionsDialogToggleAction.setToolTipText("Toggle Tool Options Dialog");
        this.gridToggleAction = new SmartToggleAction(plateViewOptions.getGridVisibilityModel(), "Grid", JaveImageProvider.getInstance().getImageIcon("grid.gif"));
        this.gridToggleAction.setAcceleratorKey(KeyStroke.getKeyStroke(71, 128));
        this.markIllegalToggleAction = new SmartToggleAction(plateViewOptions.getMarkIllegalModel(), "Mark illegal characters", JaveImageProvider.getInstance().getImageIcon("pure_toggle.gif"));
        this.connectedLinesViewToggleAction = new SmartToggleAction(plateViewOptions.getConnectedLinesViewModel(), "Connected Lines View", JaveImageProvider.getInstance().getImageIcon("pixel_toggle.gif"));
        this.rulerToggleAction = new SmartToggleAction(plateViewOptions.getRulerModel(), "Rulers", JaveImageProvider.getInstance().getImageIcon("ruler.gif"));
        this.clipartLibraryAction = new ClipartLibraryAction(jave, jave.getMainPanel());
        this.mathematicalExpressionsAction = new MathematicalExpressionsAction(jave, jave.getMainPanel());
        this.textBoxAction = new TextBoxAction(jave, jave.getMainPanel());
        this.saveAllAction = new SaveAllAction(jave, jave.getMainPanel());
        this.saveAsAction = new SaveAsAction(jave, jave.getMainPanel());
    }

    public final SmartAction getNewDocumentAction() {
        return this.newDocumentAction;
    }

    public final SmartAction getBrowseAction() {
        return this.browseAction;
    }

    public final SmartAction getOpenAction() {
        return this.openAction;
    }

    public final SmartAction getAboutAction() {
        return this.aboutAction;
    }

    public final SmartAction getCamelizerAction() {
        return this.camelizerAction;
    }

    public final SmartAction getNewAnimationAction() {
        return this.newAnimationAction;
    }

    public final SmartAction getFractalAction() {
        return this.fractalAction;
    }

    public final SmartToggleAction getToolOptionsDialogToggleAction() {
        return this.toolOptionsDialogToggleAction;
    }

    public final SmartToggleAction getGridToggleAction() {
        return this.gridToggleAction;
    }

    public final SmartToggleAction getMarkIllegalToggleAction() {
        return this.markIllegalToggleAction;
    }

    public final SmartToggleAction getConnectedLinesViewToggleAction() {
        return this.connectedLinesViewToggleAction;
    }

    public final SmartToggleAction getRulerToggleAction() {
        return this.rulerToggleAction;
    }

    public final Image2AsciiAction getImage2AsciiAction() {
        return this.image2AsciiAction;
    }

    public final SmartAction getFigletAction() {
        return this.figletAction;
    }

    public final ResizeDocumentAction getResizeAction() {
        return this.resizeAction;
    }

    public final ClipartLibraryAction getClipartLibraryAction() {
        return this.clipartLibraryAction;
    }

    public final SmartAction getMathematicalExpressionsAction() {
        return this.mathematicalExpressionsAction;
    }

    public final SmartAction getTextBoxAction() {
        return this.textBoxAction;
    }

    public final SmartAction getSaveAction() {
        return this.saveAction;
    }

    public final SmartAction getSaveAllAction() {
        return this.saveAllAction;
    }

    public final SmartAction getSaveAsAction() {
        return this.saveAsAction;
    }
}

