/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.GenericTool;
import de.jave.jave.Jave;
import de.jave.jave.Point2d;
import de.jave.jave.algorithm.fill.FillAlgorithm;
import de.jave.jave.algorithm.fill.FillMatchMode;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.rendering.PixelPlateRenderer;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public final class RectangleToolGeneric
extends GenericTool {
    private Point point1;
    private Point point2;
    private JCheckBox cbFill;

    public RectangleToolGeneric(JaveMainPanel mainPanel, Jave asciiPainter) {
        super(mainPanel, asciiPainter);
    }

    public final String getName() {
        return "Rectangle Generic";
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("tool/rectangle_generic.gif");
    }

    public final JComponent getAdditionalOptionsComponent() {
        if (this.cbFill == null) {
            this.cbFill = new JCheckBox("Fill", false);
        }
        return this.cbFill;
    }

    public final void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        this.point1 = point;
        this.point2 = point;
        this.markPlate = new PixelPlate(location.x - 10, location.y - 10, 20, 20);
        pixelPlateOptionsPanel.configure(this.markPlate);
        this.markPlate.setCharacter(this.getMouseChar());
        this.repaintCursor();
    }

    public final void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (this.point1 == null || this.point2 == null || this.markPlate == null) {
            return;
        }
        this.point2 = point;
        this.repaintCursor();
    }

    public final void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.point1 == null || this.point2 == null) {
            return;
        }
        this.point1 = null;
        this.point2 = null;
        if (this.markPlate != null) {
            this.setMixMode(this.isMix());
            this.markPlate.pasteResultInto(this.getPlate().getContent());
            this.saveCurrentState("rectangle");
            this.repaintAll();
            this.markPlate = null;
        }
    }

    public final void keyPressed(int code, KeyEvent evt) {
        if (this.markPlate == null) {
            return;
        }
        if (code == 27 && this.point1 != null) {
            this.point1 = null;
            this.point2 = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }

    public final void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.point1 == null) {
            return;
        }
        g.setColor(colorScheme.getColorToolHelping());
        g.drawRect(this.point1.x - 2, this.point1.y - 2, 5, 5);
        if (this.point2 == null) {
            return;
        }
        g.drawRect(this.point2.x - 2, this.point2.y - 2, 5, 5);
        Point point3 = RectangleToolGeneric.getQuadraticPointFor(this.point1, this.point2, shiftDown);
        Point2d p1 = this.getPlate().getRealLocationForScreenPoint(this.point1);
        Point2d p2 = this.getPlate().getRealLocationForScreenPoint(point3);
        this.markPlate.clear();
        boolean fill = this.cbFill.isSelected();
        if (fill && !this.isLineMode()) {
            this.markPlate.fillRectangle(p1, p2);
        } else {
            this.markPlate.drawRectangle(p1, p2);
        }
        this.markPlate.convert();
        if (fill && this.isLineMode() && Math.abs(p2.x - p1.x) >= 1.0 && Math.abs(p2.y - p1.y) >= 1.0) {
            FillAlgorithm.fillSolid(this.markPlate.getCharacterPlate(), (int)((p1.x + p2.x) / 2.0) - this.markPlate.getOriginX(), (int)((p1.y + p2.y) / 2.0) - this.markPlate.getOriginY(), '\u00a0', FillMatchMode.EQUAL_CHARACTER);
        }
        PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
    }

    public final void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
        this.point1 = null;
        this.point2 = null;
    }

    public final void putAside(boolean nextToolIsSelectionTool) {
        this.point1 = null;
        this.point2 = null;
    }
}

