/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import java.awt.Point;

public final class Point2d
implements Cloneable {
    public double x;
    public double y;

    public Point2d() {
        this(0.0, 0.0);
    }

    public Point2d(int x, int y) {
        this((double)x, (double)y);
    }

    public Point2d(Point p) {
        this(p.x, p.y);
    }

    public Point2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final void translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public final void moveTo(Point2d d) {
        this.x = d.x;
        this.y = d.y;
    }

    public final Object clone() {
        try {
            Point2d newone = (Point2d)super.clone();
            return newone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final boolean equals(Object other) {
        if (!(other instanceof Point2d)) {
            return false;
        }
        return this.x - 0.001 <= ((Point2d)other).x && this.x + 0.001 >= ((Point2d)other).x && this.y - 0.001 <= ((Point2d)other).y && this.y + 0.001 >= ((Point2d)other).y;
    }

    public final int hashCode() {
        return ((int)(this.x * 1000.0) << 8) + ((int)(this.y * 1000.0) << 16);
    }

    public final double getDistance(Point2d other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2.0) + Math.pow(this.y - other.y, 2.0));
    }

    public final double getDistanceTo(Point2d p1, Point2d p2) {
        if (p1.x == p2.x && p1.y == p2.y) {
            return this.getDistance(p1);
        }
        double bx = this.x - p1.x;
        double by = this.y - p1.y;
        double ax = p2.x - p1.x;
        double ay = p2.y - p1.y;
        double f = (ax * bx + ay * by) / (ax * ax + ay * ay);
        double qx = p1.x + f * ax;
        double qy = p1.y + f * ay;
        return Math.sqrt(Math.pow(this.x - qx, 2.0) + Math.pow(this.y - qy, 2.0));
    }

    public final String toString() {
        return "Point2d(" + this.x + "," + this.y + ")";
    }
}

