/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public final class JaveTextCursor {
    private int style;
    private int charHeight;
    private int charWidth;
    private Point location;
    private long id;
    private static long counter = 0L;

    public JaveTextCursor(Point location, int style, int charWidth, int charHeight) {
        this.style = style;
        this.charHeight = charHeight;
        this.charWidth = charWidth;
        this.location = location;
        this.id = ++counter;
    }

    public final void paintXOR(Graphics g) {
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        switch (this.style) {
            case 3: {
                g.fillRect(this.location.x, this.location.y, this.charWidth + 1, this.charHeight + 1);
                break;
            }
            case 1: {
                int y = this.location.y + this.charHeight - 2;
                g.drawLine(this.location.x + 1, y, this.location.x + 1 + this.charWidth - 2, y);
                break;
            }
            case 2: {
                g.drawLine(this.location.x + 2, this.location.y + this.charHeight - 2, this.location.x + 2, this.location.y + 2);
            }
        }
        g.setPaintMode();
    }

    public final String toString() {
        return "TextCursor{" + this.id + "}";
    }
}

