/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.lib.BooleanPlate;
import de.jave.lib.CharacterPlate;
import java.awt.Dimension;

public final class JaveSelection {
    private CharacterPlate content;
    private BooleanPlate mask;

    public JaveSelection(CharacterPlate content) {
        this(content, null);
    }

    public JaveSelection(CharacterPlate content, BooleanPlate mask) {
        this.content = content;
        this.mask = mask;
    }

    public final JaveSelection getClone() {
        return new JaveSelection(this.content.getClone(), this.mask == null ? null : this.mask.getClone());
    }

    public final CharacterPlate getContent() {
        return this.content;
    }

    public final BooleanPlate getMask() {
        return this.mask;
    }

    public final void setMask(BooleanPlate mask) {
        if (this.mask == null) {
            this.mask = mask;
            return;
        }
        if (this.mask != mask) {
            this.mask.setSize(mask.getWidth(), mask.getHeight());
            mask.pasteInto(this.mask, 0, 0);
        }
    }

    public final int getWidth() {
        return this.content.getWidth();
    }

    public final int getHeight() {
        return this.content.getHeight();
    }

    public final boolean isActive(int x, int y) {
        if (x < 0 || y < 0 || x >= this.content.getWidth() || y >= this.content.getHeight()) {
            return false;
        }
        if (this.mask == null) {
            return true;
        }
        return this.mask.isSet(x, y);
    }

    public final void setContent(CharacterPlate content) {
        if (this.content != content) {
            this.content.setSize(content.getWidth(), content.getHeight());
            content.pasteIntoForce(this.content, 0, 0);
        }
    }

    public final Dimension getSize() {
        return this.content.getSize();
    }
}

