/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import java.awt.Component;
import java.io.File;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public final class JaveConfigurationFileLoader {
    private final Component parentComponent;

    public JaveConfigurationFileLoader(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public final void initConfigFile(IJaveInitializable confy) {
        IJavaInitializationContext context = new IJavaInitializationContext(){

            public final File getConfigurationFile(String fileName) {
                File file = new File(JaveGlobalRessources.codeBase, fileName);
                if (!file.exists()) {
                    file = new File(JaveGlobalRessources.codeBase, file.getName());
                }
                if (!file.exists()) {
                    file = new File(fileName);
                }
                if (file.exists()) {
                    return file;
                }
                if (JaveConfigurationFileLoader.this.parentComponent != null) {
                    MessageDialogFactory.showMessageDialog(JaveConfigurationFileLoader.this.parentComponent, new Message("JavE", "Error loading configuration from file:\n\t'" + file.getAbsolutePath() + "'\n" + "The file does not exist.\n\n" + " Using default configuration instead.", MessageType.ERROR));
                }
                return null;
            }
        };
        try {
            confy.initialize(context);
            return;
        }
        catch (Exception e) {
            if (this.parentComponent != null) {
                MessageDialogFactory.showMessageDialog(this.parentComponent, new Message("JavE", "Error loading configuration.\n" + e.getMessage() + "\n\n" + " Using default configuration instead.", MessageType.ERROR, e));
            }
            return;
        }
    }

    public final boolean isConfigurationFolderExistant() {
        File file = new File(JaveGlobalRessources.codeBase, "config");
        if (file.exists() && file.isDirectory()) {
            return true;
        }
        file = new File("config");
        return file.exists() && file.isDirectory();
    }
}

