/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.asciimation.action.OpenAnimationAction;
import de.jave.awt.clipboard.DefaultClipboardOwner;
import de.jave.awt.clipboard.JaveClipboardSelection;
import de.jave.figlet.swing.preferences.JFigletPreferences;
import de.jave.gui.GStatusLabel;
import de.jave.gui.StatusBar;
import de.jave.gui.dialog.GDialog;
import de.jave.gui.io.AcceptAllFileFilter;
import de.jave.gui.io.ExtensionFileFilter;
import de.jave.gui.io.FileChooserUtilities;
import de.jave.gui.io.FileSelection;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SmartFileFilter;
import de.jave.gui.splash.IStartupMonitor;
import de.jave.jave.Ascii2GIFDialog;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.BrushTool;
import de.jave.jave.CharacterSets;
import de.jave.jave.CommandLineJave;
import de.jave.jave.CompressedDocumentState;
import de.jave.jave.DocumentDefaultTitleFactory;
import de.jave.jave.DocumentManager;
import de.jave.jave.FractalTool;
import de.jave.jave.FunctionPlotTool;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveImages;
import de.jave.jave.JaveLogFile;
import de.jave.jave.JaveOptionsAlgorithmDialog;
import de.jave.jave.JaveSelection;
import de.jave.jave.JaveStatusFile;
import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.Render3DTool;
import de.jave.jave.ReplaceCharacterDialog;
import de.jave.jave.ResultDialog;
import de.jave.jave.SelectionTool;
import de.jave.jave.TextboxDialog;
import de.jave.jave.Tool;
import de.jave.jave.WatermarkTool;
import de.jave.jave.actions.Image2AsciiAction;
import de.jave.jave.actions.JaveActions;
import de.jave.jave.actions.JaveMenuBar;
import de.jave.jave.actions.JaveTopToolbar;
import de.jave.jave.actions.ResizeDocumentAction;
import de.jave.jave.actions.ToolBar;
import de.jave.jave.actions.performers.IDocumentSaveListener;
import de.jave.jave.actions.performers.SavePerformer;
import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.jave.algorithm.JaveOptionsAlgorithm;
import de.jave.jave.algorithm.camel.CamelDialog;
import de.jave.jave.algorithm.rectangle.RectangleStyle;
import de.jave.jave.algorithm.repair.AsciiRepairAlgorithm;
import de.jave.jave.algorithm.replaceillegal.AsciiReplaceIllegal;
import de.jave.jave.application.about.JaveAboutDialog;
import de.jave.jave.application.startup.JaveMainApplicationStarter;
import de.jave.jave.brace.BraceLocationDialog;
import de.jave.jave.browser.AsciiThumbnailBrowser;
import de.jave.jave.browser.JaveFileType;
import de.jave.jave.clipart.ClipartDialog;
import de.jave.jave.clipart.ClipartManager;
import de.jave.jave.figlet.FigletEditorDialog;
import de.jave.jave.plate.AnimationDocumentEditor;
import de.jave.jave.plate.DocumentEditorTitleFactory;
import de.jave.jave.plate.GameDocumentEditor;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.plate.MouseCharacterModel;
import de.jave.jave.plate.TextDocumentEditor;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.jave.tool.dialog.ToolOptionsDialog;
import de.jave.jave.tool.text.TextTool;
import de.jave.jave.version.JaveTitleProvider;
import de.jave.jave.watermark.WatermarkImageFile;
import de.jave.javeplayer.AsciiPacker;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.javeplayer.JaveAnimationFrame;
import de.jave.lib.CharacterPlate;
import de.jave.lib.gui.GuiUtilities;
import de.jave.preferences.JavePreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public class Jave
implements ActionListener {
    private JaveMainPanel mainPanel;
    private DocumentManager documentManager;
    private ToolBar toolBar;
    private GStatusLabel lSize;
    private GStatusLabel lInsert;
    private ToolOptionsDialog optionsDialog;
    private TextboxDialog textboxDialog;
    private CamelDialog camelDialog;
    private ReplaceCharacterDialog replaceCharacterDialog;
    private AsciiThumbnailBrowser thumbnailBrowser;
    private final JaveActions actions;
    private JaveMenuBar menuBar;
    private StatusBar status;
    private final JFrame frame = new JFrame();
    private final JavePreferences javePreferences;
    private final JaveApplicationPreferences applicationPreferences;
    private final JFigletPreferences figletPreferences;
    private JaveTopToolbar topToolbar;
    private final BooleanModel toolOptionsDialogVisibilityModel;
    private PlatePreferences platePreferences;
    private FigletEditorDialog figletDialog;

    public Jave() {
        this.frame.setTitle(JaveTitleProvider.TITLE);
        this.status = new StatusBar();
        this.frame.setIconImage(JaveImages.getJaveIconImage());
        this.javePreferences = new JavePreferences();
        this.applicationPreferences = new JaveApplicationPreferences(this.javePreferences);
        this.figletPreferences = new JFigletPreferences(this.javePreferences);
        FileModel currectDirectoryModel = this.applicationPreferences.getCurrectDirectoryModel();
        this.toolOptionsDialogVisibilityModel = new BooleanModel();
        this.toolOptionsDialogVisibilityModel.setValue(true);
        this.documentManager = new DocumentManager(currectDirectoryModel);
        this.platePreferences = new PlatePreferences(this.javePreferences);
        MouseCharacterModel mouseCharacterModel = new MouseCharacterModel();
        this.mainPanel = new JaveMainPanel(this, this.status, mouseCharacterModel);
        this.mainPanel.getActiveEditorModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                Jave.this.updateFrameTitle();
            }
        });
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.actions = new JaveActions(this, this.javePreferences, this.toolOptionsDialogVisibilityModel, this.platePreferences, this.applicationPreferences.getDisplayFontModel());
        this.topToolbar = new JaveTopToolbar(this, this.actions);
        this.frame.getContentPane().add((Component)this.topToolbar.getContent(), "North");
        this.toolBar = new ToolBar(this, this.applicationPreferences, this.platePreferences);
        this.frame.getContentPane().add((Component)this.toolBar.getContent(), "West");
        this.frame.getContentPane().add(this.mainPanel.getContent(), "Center");
        JPanel bottomPanel = this.createBottomPanel();
        this.frame.getContentPane().add((Component)bottomPanel, "South");
        this.frame.pack();
    }

    public void performSetColorScheme(ColorScheme colorScheme) {
        ColorScheme old;
        JaveGlobalRessources.setColorScheme(colorScheme);
        PlateDocument doc = this.mainPanel.getDocument();
        if (doc != null && (old = doc.getColorScheme()) != colorScheme) {
            doc.setColorScheme(colorScheme);
            this.mainPanel.saveCurrentState("change color");
        }
        this.mainPanel.repaint();
    }

    public void startupRecovery(IStartupMonitor startupMonitor) {
        this.doRecovery(startupMonitor);
        if (this.documentManager.getSize() == 0) {
            this.doNew();
        }
    }

    public void startupMenuBar() {
        this.menuBar = new JaveMenuBar(this, this.javePreferences, this.mainPanel, this.actions, this.applicationPreferences.getRecentFileList(), this.applicationPreferences);
        this.frame.setJMenuBar(this.menuBar);
        this.updateUndoRedo();
        this.updateSelectionMenu();
    }

    public void startupFinish2() {
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                Jave.this.performExit(Jave.this.frame);
            }
        });
        this.frame.setBounds(this.applicationPreferences.getApplicationFrameBounds());
        this.frame.setExtendedState(this.applicationPreferences.getApplicationFrameState());
        this.frame.setVisible(true);
    }

    public void startupFinish3() {
        this.applicationPreferences.getRecentFileList().setRecentFileOpenListener(this);
    }

    public void startupOptionsDialog() {
        this.optionsDialog = new ToolOptionsDialog(this, false, this.toolOptionsDialogVisibilityModel);
        this.optionsDialog.setTool(this.mainPanel.getCurrentTool());
        this.optionsDialog.pack();
        this.optionsDialog.setLocation(this.applicationPreferences.getToolDialogLocation());
        this.optionsDialog.show();
        this.optionsDialog.toFront();
    }

    protected void updateSelectionMenu() {
        if (this.menuBar != null) {
            this.menuBar.updateSelectionMenu(this.mainPanel.hasSelection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doRecovery(IStartupMonitor startupMonitor) {
        if (!JaveStatusFile.exists()) {
            return;
        }
        String[] statusData = JaveStatusFile.load();
        if (statusData == null || statusData[1].equals("0")) {
            return;
        }
        String fileCountString = Integer.parseInt(statusData[1]) > 1 ? statusData[1] + " files" : "1 file";
        String question = "It seems JavE has crashed somewhen after\n" + statusData[0] + " with " + fileCountString + " open.\n\n" + "Do you want JavE to continue where the interruption occured?";
        GDialog id = new GDialog(null, "JavE - Crash Recovery", "Crash Recovery", question, GDialog.YES_NO_CANCEL, 1);
        startupMonitor.getSplashWindow().setVisible(false);
        try {
            id.show();
        }
        finally {
            startupMonitor.getSplashWindow().setVisible(true);
        }
        int result = id.getAnswer();
        if (result == 2 || result == -1) {
            System.exit(0);
        }
        if (result == 1) {
            return;
        }
        this.switchToSelectonTool();
        PlateDocument doc = null;
        for (int i = 2; i < statusData.length; i += 2) {
            doc = this.documentManager.createNew(this.applicationPreferences.getDefaultDocumentSize());
            doc.setModified(true);
            if (statusData[i] != null && statusData[i].length() > 0) {
                doc.setFile(new File(statusData[i]));
            }
            CompressedDocumentState[] docStates = JaveLogFile.load(new File(statusData[i + 1]));
            TextDocumentEditor editor = new TextDocumentEditor(DocumentDefaultTitleFactory.createDefaultDocumentTitle(), doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel());
            this.mainPanel.addPlate(editor);
            if (docStates == null || docStates.length <= 0) continue;
            for (int j = 0; j < docStates.length; ++j) {
                doc.getUndoManager().saveCurrentState(docStates[j]);
            }
            doc.setDocumentState(docStates[docStates.length - 1]);
        }
        JaveGlobalRessources.setColorScheme(doc.getColorScheme());
        this.updateStatusFile();
    }

    public void updateFrameTitle() {
        this.mainPanel.updateAllDocumentTitles();
        IDocumentEditor activeEditor = this.mainPanel.getActiveEditorModel().getActiveEditor();
        if (activeEditor == null) {
            this.frame.setTitle(JaveTitleProvider.TITLE);
            return;
        }
        String title = DocumentEditorTitleFactory.createEditorFrameTitle(activeEditor);
        this.frame.setTitle(JaveTitleProvider.TITLE + " - " + title);
    }

    private final JPanel createBottomPanel() {
        Dimension size = this.mainPanel.getDocumentSize();
        String text = size == null ? "   x   " : size.width + " x " + size.height;
        this.lSize = new GStatusLabel(text);
        this.lSize.setToolTipText("Document Size");
        this.lSize.addActionListener(this);
        this.lInsert = new GStatusLabel("OVR");
        this.lInsert.setToolTipText("Insert / Overwrite");
        this.lInsert.addActionListener(this);
        JPanel p = new JPanel(new FlowLayout(0, 5, 0));
        p.add(this.lSize);
        p.add(this.lInsert);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)this.status, "Center");
        bottomPanel.add((Component)p, "East");
        return bottomPanel;
    }

    public void packOptionsDialog() {
        this.optionsDialog.pack();
    }

    public void hideToolOptionsDialog() {
        this.optionsDialog.setVisible(false);
    }

    public void showToolOptionsDialog() {
        this.optionsDialog.setVisible(true);
    }

    public void doSelectionDelete() {
        if (!this.mainPanel.hasSelection()) {
            this.mainPanel.selectAll();
        }
        this.mainPanel.getCurrentTool().setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
        this.mainPanel.unselect();
        this.mainPanel.saveCurrentState("delete");
    }

    public void doSelectionShrink() {
        if (!this.mainPanel.hasSelection()) {
            this.mainPanel.selectAll();
        }
        this.mainPanel.shrinkSelection();
        this.mainPanel.saveCurrentState("shrink selection");
    }

    public void doSelectionExpand() {
        if (!this.mainPanel.hasSelection()) {
            return;
        }
        this.mainPanel.expandSelection();
        this.mainPanel.saveCurrentState("expand selection");
    }

    public void doSelectionToBrush() {
        if (!this.mainPanel.hasSelection()) {
            return;
        }
        CharacterPlate cp = this.getContentOfInterest().getContent();
        if (cp.getWidth() > 10 || cp.getHeight() > 8 || cp.getHeight() * cp.getWidth() > 35) {
            MessageDialogFactory.showMessageDialog(this.frame, new Message("JavE", "The selection is too big.\nIt can not be used as a brush.", MessageType.INFORMATION));
            return;
        }
        this.setTool(14);
        ((BrushTool)this.mainPanel.getCurrentTool()).setBrush(cp);
    }

    public void doReplaceCharacter() {
        if (this.replaceCharacterDialog == null) {
            this.replaceCharacterDialog = new ReplaceCharacterDialog(this);
            GuiUtilities.centerOnScreen(this.replaceCharacterDialog.getDialog());
        }
        this.replaceCharacterDialog.show();
    }

    public void showStatus(String text) {
        this.status.showStatus(text);
    }

    public void doRepairIllegalReplace() {
        JaveSelection sel = this.getContentOfInterest();
        if (sel == null) {
            return;
        }
        int[] result = AsciiReplaceIllegal.replaceIllegal(sel);
        int count = result[0];
        int replaced = result[1];
        this.mainPanel.repaint();
        this.mainPanel.saveCurrentState("replace illegal characters");
        if (count == 0) {
            MessageDialogFactory.showMessageDialog(this.frame, new Message("Replace illegal characters", "There are no illegal characters.", MessageType.INFORMATION));
            return;
        }
        if (replaced == 0) {
            MessageDialogFactory.showMessageDialog(this.frame, new Message("Replace illegal characters", "Unable to find substitutes for " + count + " illegal characters.", MessageType.INFORMATION));
            return;
        }
        if (replaced < count) {
            if (count == 1) {
                MessageDialogFactory.showMessageDialog(this.frame, new Message("Replace illegal characters", "Replaced 1 illegal character.\nUnable to find substitutes for the remaining " + (count - replaced) + ".", MessageType.INFORMATION));
                return;
            }
            MessageDialogFactory.showMessageDialog(this.frame, new Message("Replace illegal characters", "Replaced " + replaced + " illegal characters.\nUnable to find substitutes for the remaining " + (count - replaced) + ".", MessageType.INFORMATION));
            return;
        }
        if (count == 1) {
            this.status.showStatus("Replaced 1 of " + count + " occurence.");
            return;
        }
        this.status.showStatus("Replaced " + replaced + " of " + count + " occurrences.");
    }

    public void doRepairIllegalRemove() {
        CharacterPlate cp = this.getContentOfInterest().getContent();
        if (cp == null) {
            return;
        }
        int count = 0;
        int h = cp.getHeight();
        int w = cp.getWidth();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (CharacterSets.isLegal(cp.get(x, y))) continue;
                cp.setForce(x, y, ' ');
                ++count;
            }
        }
        if (count == 0) {
            MessageDialogFactory.showMessageDialog(this.frame, new Message("Remove illegal characters", "There are no illegal characters.", MessageType.INFORMATION));
        } else if (count == 1) {
            this.status.showStatus("Removed 1 occurence.");
        } else {
            this.status.showStatus("Removed " + count + " occurrences.");
        }
        this.mainPanel.repaint();
        this.mainPanel.saveCurrentState("remove illegal characters");
    }

    public void applyAlgorithm(JaveAlgorithm algo) {
        if (algo instanceof JaveOptionsAlgorithm) {
            this.applyAlgorithm((JaveOptionsAlgorithm)algo);
            return;
        }
        JaveSelection sel = this.getContentOfInterest();
        int oldWidth = sel.getWidth();
        int oldHeight = sel.getHeight();
        sel = algo.apply(sel);
        this.mainPanel.setContentOfInterest(sel);
        if (oldWidth != sel.getWidth() || oldHeight != sel.getHeight()) {
            this.plateSizeChanged();
            this.mainPanel.revalidate();
        }
        this.mainPanel.getCurrentTool().checkSize();
        this.mainPanel.repaint();
        this.mainPanel.saveCurrentState(algo.getActionName());
    }

    public void applyAlgorithm(JaveOptionsAlgorithm algo) {
        JaveOptionsAlgorithmDialog d = new JaveOptionsAlgorithmDialog(this, algo, this.javePreferences.getDisplayFontModel());
        d.show();
    }

    public void performExit(Component parentComponent) {
        boolean success = this.doCloseAll(parentComponent);
        if (!success) {
            return;
        }
        if (!JaveStatusFile.delete()) {
            System.err.println("Unable to delete Status-File!");
        }
        JaveStatusFile.deleteAllLogFiles();
        this.applicationPreferences.setApplicationFrameState(this.frame.getExtendedState(), this.frame.getBounds());
        this.applicationPreferences.setToolDialogLocation(this.optionsDialog.getLocation());
        this.javePreferences.flush();
        this.applicationPreferences.flush();
        this.platePreferences.flush();
        this.applicationPreferences.getRecentFileList().flush();
        this.dispose();
        System.exit(0);
    }

    public void doNew() {
        PlateDocument doc = this.documentManager.createNew(this.applicationPreferences.getDefaultDocumentSize());
        TextDocumentEditor editor = new TextDocumentEditor(DocumentDefaultTitleFactory.createDefaultDocumentTitle(), doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel());
        this.mainPanel.addPlate(editor);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
    }

    public void updateStatusFile() {
        JaveStatusFile.saveLog(this.documentManager);
    }

    public boolean doClose(Component parentComponent) {
        IDocumentEditor editor = this.mainPanel.getEditor();
        if (!editor.isModified()) {
            this.documentManager.closeCurrentDocument();
            this.mainPanel.closeCurrentEditor();
            this.updateStatusFile();
            return true;
        }
        boolean success = SavePerformer.performSaveBeforeClose(parentComponent, editor, this.applicationPreferences.getRecentFileList(), this.documentManager.getCurrentDirectoryModel(), this.status, this.getDocumentSaveListener());
        if (success) {
            return this.doClose(parentComponent);
        }
        return false;
    }

    public boolean doCloseAll(Component parentComponent) {
        boolean success = true;
        while (this.mainPanel.getEditor() != null && success) {
            success = this.doClose(parentComponent);
            if (success) continue;
            return false;
        }
        return success;
    }

    public void close(PlateDocument doc) {
        int index = this.documentManager.getIndexOf(doc);
        if (index < 0) {
            return;
        }
        this.documentManager.closeDocument(index);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
    }

    public void doSelectionBraces() {
        if (!this.mainPanel.hasSelection()) {
            return;
        }
        BraceLocationDialog g = new BraceLocationDialog(this.frame);
        int loc = g.getBraceLocation();
        if (loc == -1) {
            return;
        }
        Rectangle region = this.mainPanel.getSelectionRegion();
        this.mainPanel.dropSelection();
        switch (loc) {
            case 0: {
                this.bracesTop(region);
                return;
            }
            case 2: {
                this.bracesLeft(region);
                return;
            }
            case 3: {
                this.bracesRight(region);
                return;
            }
            case 1: {
                this.bracesBottom(region);
            }
        }
    }

    protected void bracesRight(Rectangle region) {
        int x = region.x + region.width;
        int y = region.y;
        boolean w = false;
        int h = region.height;
        CharacterPlate cp = new CharacterPlate(2, h);
        if (h == 1) {
            cp.setForce(0, 0, '}');
        } else {
            cp.setForce(0, 0, '\\');
            cp.setForce(0, h - 1, '/');
            if (h >= 5) {
                for (int i = 1; i < h - 1; ++i) {
                    cp.setForce(0, i, '|');
                }
            }
            if (h == 2) {
                cp.setForce(1, 0, '_');
            } else if (h == 3) {
                cp.setForce(1, 1, '>');
            } else if (h == 4) {
                cp.setForce(1, 1, '_');
                cp.setForce(0, 1, '|');
                cp.setForce(0, 2, '|');
            } else {
                cp.setForce(1, (h - 1) / 2, '>');
                cp.setForce(0, (h - 1) / 2, ' ');
            }
        }
        Rectangle braceRegion = new Rectangle(x, y, 2, h);
        this.mainPanel.setSelection(braceRegion, cp);
        this.mainPanel.saveCurrentState("brace right");
    }

    protected void bracesLeft(Rectangle region) {
        int x = region.x - 2;
        int y = region.y;
        boolean w = false;
        int h = region.height;
        CharacterPlate cp = new CharacterPlate(2, h);
        if (h == 1) {
            cp.setForce(1, 0, '{');
        } else {
            cp.setForce(1, 0, '/');
            cp.setForce(1, h - 1, '\\');
            if (h >= 5) {
                for (int i = 1; i < h - 1; ++i) {
                    cp.setForce(1, i, '|');
                }
            }
            if (h == 2) {
                cp.setForce(0, 0, '_');
            } else if (h == 3) {
                cp.setForce(0, 1, '<');
            } else if (h == 4) {
                cp.setForce(0, 1, '_');
                cp.setForce(1, 1, '|');
                cp.setForce(1, 2, '|');
            } else {
                cp.setForce(0, (h - 1) / 2, '<');
                cp.setForce(1, (h - 1) / 2, ' ');
            }
        }
        Rectangle braceRegion = new Rectangle(x, y, 2, h);
        this.mainPanel.setSelection(braceRegion, cp);
        this.mainPanel.saveCurrentState("brace left");
    }

    protected void bracesTop(Rectangle region) {
        int x = region.x;
        int y = region.y - 2;
        int w = region.width;
        boolean h = false;
        CharacterPlate cp = new CharacterPlate(w, 2);
        if (w == 1) {
            cp.setForce(0, 1, '^');
        } else {
            cp.setForce(0, 1, '/');
            cp.setForce(w - 1, 1, '\\');
            if (w > 5) {
                for (int i = 1; i < w - 1; ++i) {
                    cp.setForce(i, 0, '_');
                }
                cp.setForce(w / 2 - 1, 0, '/');
                cp.setForce(w / 2, 0, '\\');
            } else if (w == 3) {
                cp.setForce(1, 0, '|');
            } else if (w == 4) {
                cp.setForce(1, 0, '|');
                cp.setForce(2, 0, '_');
            } else if (w == 5) {
                cp.setForce(1, 0, '_');
                cp.setForce(2, 0, '|');
                cp.setForce(3, 0, '_');
            }
        }
        Rectangle braceRegion = new Rectangle(x, y, w, 2);
        this.mainPanel.setSelection(braceRegion, cp);
        this.mainPanel.saveCurrentState("brace top");
    }

    protected void bracesBottom(Rectangle region) {
        int x = region.x;
        int y = region.y + region.height;
        int w = region.width;
        boolean h = false;
        CharacterPlate cp = new CharacterPlate(w, 2);
        if (w == 1) {
            cp.setForce(0, 0, 'V');
        } else {
            cp.setForce(0, 0, '\\');
            cp.setForce(w - 1, 0, '/');
            if (w > 5) {
                for (int i = 1; i < w - 1; ++i) {
                    cp.setForce(i, 0, '_');
                }
                cp.setForce(w / 2 - 1, 1, '\\');
                cp.setForce(w / 2, 1, '/');
                cp.setForce(w / 2 - 1, 0, ' ');
                cp.setForce(w / 2, 0, ' ');
            } else if (w == 3) {
                cp.setForce(1, 0, '_');
                cp.setForce(1, 1, '|');
            } else if (w == 4) {
                cp.setForce(2, 0, '_');
                cp.setForce(1, 0, '_');
                cp.setForce(1, 1, '|');
            } else if (w == 5) {
                cp.setForce(1, 0, '_');
                cp.setForce(2, 0, '_');
                cp.setForce(3, 0, '_');
                cp.setForce(2, 1, '|');
            }
        }
        Rectangle braceRegion = new Rectangle(x, y, w, 2);
        this.mainPanel.setSelection(braceRegion, cp);
        this.mainPanel.saveCurrentState("brace bottom");
    }

    public void openRecentFile(Component parentComponent, File file) {
        this.open(parentComponent, file);
    }

    public void actionPerformed(ActionEvent evt) {
        GuiUtilities.getWindowForComponent(evt);
        this.mainPanel.requestFocus();
        Object source = evt.getSource();
        if (source == this.lSize) {
            ResizeDocumentAction resizeAction = this.actions.getResizeAction();
            if (resizeAction.isEnabled()) {
                resizeAction.actionPerformed(evt);
            }
            return;
        }
        if (source == this.lInsert) {
            this.toggleInsert();
            return;
        }
        System.err.println("JavE: source unknown in actionPerformed!" + source);
    }

    public void editTextBox(String content, Point location, RectangleStyle textboxStyle) {
        if (this.textboxDialog == null) {
            this.textboxDialog = new TextboxDialog(this, content, location);
            GuiUtilities.centerOnScreen(this.textboxDialog.getDialog());
        } else {
            this.textboxDialog.setContent(content);
            this.textboxDialog.setLocation(location);
        }
        this.textboxDialog.setTextboxStyle(textboxStyle);
        this.textboxDialog.show();
    }

    public void showAboutDialog() {
        JaveAboutDialog.showAboutDialog(this.frame);
    }

    protected final JaveClipboardSelection getClipboardContent() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable o = clipboard.getContents(this);
            if (o == null) {
                return null;
            }
            if (o instanceof JaveClipboardSelection) {
                return (JaveClipboardSelection)o;
            }
            String sel = (String)o.getTransferData(DataFlavor.stringFlavor);
            if (sel.indexOf(9) != -1) {
                return new JaveClipboardSelection(CharacterPlate.tabelize(sel));
            }
            return new JaveClipboardSelection(sel);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected final void setClipboardContent(JaveClipboardSelection sel) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(sel, DefaultClipboardOwner.getInstance());
    }

    public void doPaste() {
        JaveClipboardSelection s = this.getClipboardContent();
        if (s != null) {
            this.pasteAsNewSelection(s);
        }
    }

    public void doPasteAsNewDocument() {
        JaveClipboardSelection s = this.getClipboardContent();
        if (s != null) {
            this.pasteAsNewDocument(s.getContent());
        }
    }

    public void pasteClipart(String code) {
        this.pasteAsNewSelection(AsciiPacker.decode(code));
    }

    public void doCopy() {
        JaveClipboardSelection sel = this.mainPanel.hasSelection() ? new JaveClipboardSelection(this.mainPanel.getSelection().getContent(), this.mainPanel.getSelection().getMask()) : new JaveClipboardSelection(this.mainPanel.getDocument().getContent());
        this.setClipboardContent(sel);
    }

    public void doCut() {
        JaveClipboardSelection s = null;
        if (!this.mainPanel.hasSelection()) {
            s = new JaveClipboardSelection(this.mainPanel.getDocument().getContent());
            this.mainPanel.clear();
        } else {
            s = new JaveClipboardSelection(this.mainPanel.getSelection().getContent(), this.mainPanel.getSelection().getMask());
            this.mainPanel.unselect();
            this.mainPanel.getCurrentTool().setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
        }
        this.setClipboardContent(s);
        this.mainPanel.saveCurrentState("cut");
    }

    public void updateUndoRedo() {
        boolean canUndo = this.mainPanel.canUndo();
        boolean canRedo = this.mainPanel.canRedo();
        String undoName = null;
        String redoName = null;
        if (canUndo) {
            undoName = this.mainPanel.getUndoActionName();
        }
        if (canRedo) {
            redoName = this.mainPanel.getRedoActionName();
        }
        if (this.menuBar != null) {
            this.menuBar.updateUndoRedoMenu(canUndo, undoName, canRedo, redoName);
        }
        if (this.topToolbar != null) {
            this.topToolbar.updateUndoRedo(canUndo, canRedo);
        }
    }

    public void doRedo() {
        this.mainPanel.redo();
        this.updateUndoRedo();
        this.updateSelectionMenu();
        this.mainPanel.requestFocus();
    }

    public void doUndo() {
        this.mainPanel.undo();
        this.updateUndoRedo();
        this.updateSelectionMenu();
        this.mainPanel.requestFocus();
    }

    public void doDebugCrash() {
        GDialog gd = new GDialog((Component)this.frame, "JavE", "Crashing is not fun!!", "Do you really want the program\nto crash now?", GDialog.YES_NO_CANCEL, 3);
        gd.show();
        if (gd.getAnswer() != 0) {
            return;
        }
        System.err.println("===============================================");
        System.err.println("By your personal demand:");
        System.err.println("JavE is now crashing w/o doing all the cleanup!");
        System.err.println(" - Good bye.");
        System.err.println("===============================================");
        System.exit(1);
    }

    public void doDoc2Watermark() {
        if (this.mainPanel.hasSelection()) {
            this.mainPanel.dropSelection();
        }
        CharacterPlate cp = this.getContentOfInterest().getContent();
        Font font = this.mainPanel.getPlate().getFont();
        ColorScheme colorScheme = JaveGlobalRessources.getColorSchemeModel().getColorScheme();
        BufferedImage image = AsciiToThumbnailConverter.convert(cp, font.getSize(), font, colorScheme.getColorPlateBackground(), colorScheme.getColorText(), this.isConnectedLinesView());
        cp.clear();
        this.setContentOfInterest(cp);
        this.mainPanel.saveCurrentState("clear content");
        this.setWatermarkImage(new WatermarkImageFile(image));
    }

    public void setWatermarkImage(WatermarkImageFile imageFile) {
        this.setTool(19);
        WatermarkTool tool = (WatermarkTool)this.mainPanel.getToolManager().getTool(19);
        tool.setImage(imageFile);
        tool.fit();
        this.toolBar.setWatermarkVisible(true);
    }

    public boolean isConnectedLinesView() {
        return this.platePreferences.getConnectedLinesViewModel().getValue();
    }

    public void plateSizeChanged() {
        if (this.lSize == null) {
            return;
        }
        PlateDocument currentDoc = this.mainPanel.getDocument();
        if (currentDoc == null) {
            this.lSize.setText("");
            return;
        }
        this.lSize.setText(currentDoc.getSize().width + "x" + currentDoc.getSize().height);
    }

    public void doExport() {
        String result = null;
        result = this.mainPanel.hasSelection() ? this.mainPanel.getSelectionContent().toString() : this.mainPanel.getDocument().getContent().toString();
        new ResultDialog(this, result, JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
    }

    public IDocumentSaveListener getDocumentSaveListener() {
        return new IDocumentSaveListener(){

            public final void savePerformed() {
                Jave.this.menuBar.setRevertEnabled(Jave.this.mainPanel.getDocument().hasFile());
                Jave.this.updateFrameTitle();
            }
        };
    }

    public void doCreateNewAnimation(Component parentComponent) {
        JaveAnimationFile animationFile = new JaveAnimationFile();
        JaveAnimationFrame animationFrame = new JaveAnimationFrame();
        animationFrame.setContent(new CharacterPlate(this.applicationPreferences.getDefaultDocumentSize()));
        animationFile.add(animationFrame);
        this.openJaveAnimation(parentComponent, animationFile);
    }

    public void doBrowse() {
        if (this.thumbnailBrowser != null) {
            this.thumbnailBrowser.setVisible(true);
            return;
        }
        this.thumbnailBrowser = new AsciiThumbnailBrowser(this.frame, this, this.getDocumentManager().getCurrentDirectoryModel());
        this.thumbnailBrowser.show();
    }

    public void doZoomPlus() {
        this.mainPanel.zoomIn();
    }

    public void doZoomMinus() {
        this.mainPanel.zoomOut();
    }

    public void doRevert(Component parentComponent) {
        PlateDocument doc = this.documentManager.getCurrentDocument();
        GDialog id = new GDialog(parentComponent, "JavE", "Lose all changes since your last save?", GDialog.OK_CANCEL, 0);
        id.show();
        if (id.getAnswer() == 0) {
            doc.setModified(false);
            File file = doc.getFile();
            this.doClose(parentComponent);
            this.open(parentComponent, file);
        }
    }

    public void doOpen(Component parentComponent) {
        FileSelection fileSelection = FileChooserUtilities.performOpenFileChooser(parentComponent, new IFileChooserConfiguration(){

            public final FileModel getCurrentDirectoryModel() {
                return Jave.this.documentManager.getCurrentDirectoryModel();
            }

            public final String getSaveDialogTitle() {
                return null;
            }

            public final String getOpenDialogTitle() {
                return "Open ASCII File / GIF / JPG / BMP / JMOV-animation";
            }

            public final SmartFileFilter[] getFileFilters() {
                return new SmartFileFilter[]{new AcceptAllFileFilter(), new ExtensionFileFilter("All supported Files", new String[]{"txt", "jmov", "gif", "jpg", "bmp"}), new ExtensionFileFilter("Text Files", "txt"), new ExtensionFileFilter("Image Files", new String[]{"gif", "jpg", "bmp"}), new ExtensionFileFilter("JavE Animation Files", "jmov")};
            }

            public final String getFileNameSuggestion() {
                return null;
            }

            public final boolean isMultipleOpenFileSelectionAllowed() {
                return false;
            }
        });
        if (fileSelection.isEmpty()) {
            return;
        }
        this.open(parentComponent, fileSelection.getFile());
    }

    public void open(Component parentComponent, File file) {
        JaveFileType fileType = JaveFileType.guessType(file);
        if (fileType == JaveFileType.ANIMATION) {
            JaveAnimationFile animationFile = OpenAnimationAction.open(file, parentComponent);
            if (animationFile == null) {
                return;
            }
            this.applicationPreferences.getRecentFileList().add(file);
            this.openJaveAnimation(parentComponent, animationFile);
            return;
        }
        if (fileType == JaveFileType.RASTER_IMAGE) {
            Image2AsciiAction action = this.actions.getImage2AsciiAction();
            action.execute(parentComponent, file);
            return;
        }
        if (this.documentManager.isAlreadyOpen(file)) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "The selected file is already loaded.", MessageType.INFORMATION));
            return;
        }
        try {
            PlateDocument doc = this.documentManager.load(file, this.applicationPreferences.getRecentFileList());
            TextDocumentEditor editor = new TextDocumentEditor(DocumentDefaultTitleFactory.createDefaultDocumentTitle(file.getName()), doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel());
            this.mainPanel.addPlate(editor);
            this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
            doc.getUndoManager().getLogFile().append(this.mainPanel.getDocumentState(null));
            this.updateStatusFile();
            this.status.showStatus("File loaded.");
            return;
        }
        catch (IOException e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "Error loading file:\n" + e.toString(), MessageType.ERROR, e));
            this.status.showStatus("Error loading File: " + e);
            return;
        }
        catch (OutOfMemoryError e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE", "Error loading file: The file is too big.", MessageType.ERROR));
            this.status.showStatus("Error loading File: " + e);
            return;
        }
    }

    public void openJaveAnimation(Component parentComponent, JaveAnimationFile animationFile) {
        PlateDocument document = this.documentManager.createNew(this.applicationPreferences.getDefaultDocumentSize());
        String stopGapName = DocumentDefaultTitleFactory.createDefaultDocumentTitle(animationFile.getFile());
        AnimationDocumentEditor editor = new AnimationDocumentEditor(stopGapName, animationFile, this, document, this.platePreferences, this.applicationPreferences, this.mainPanel.getToolManager(), new AnimationExportPreferences(this.javePreferences), this.applicationPreferences.getCurrectDirectoryModel());
        this.mainPanel.addPlate(editor);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
    }

    protected JaveSelection getContentOfInterest() {
        return this.mainPanel.getContentOfInterest();
    }

    public void setContentOfInterest(CharacterPlate cp) {
        this.mainPanel.setContentOfInterest(cp);
    }

    protected void setContentOfInterest(JaveSelection sel) {
        this.mainPanel.setContentOfInterest(sel);
    }

    public void doRepairShaked() {
        CharacterPlate cp = this.getContentOfInterest().getContent();
        JDialog d = GDialog.createJDialog(this.frame, "JavE", false);
        d.getContentPane().setLayout(new FlowLayout());
        d.getContentPane().add(new JLabel("Please Wait..."));
        d.pack();
        GuiUtilities.centerOnScreen(d);
        d.show();
        CharacterPlate cr = AsciiRepairAlgorithm.repairShaked(cp);
        d.dispose();
        if (cr == null) {
            return;
        }
        this.setContentOfInterest(cr);
        this.mainPanel.repaint();
        this.mainPanel.saveCurrentState("repair");
    }

    public void doFractal() {
        FractalTool dt = new FractalTool(this, this.applicationPreferences);
        dt.show();
    }

    public void doRender3D() {
        Render3DTool dt = new Render3DTool(this, this.applicationPreferences);
        dt.show();
    }

    public void doFunctionPlotter() {
        FunctionPlotTool dt = new FunctionPlotTool(this, this.applicationPreferences);
        dt.show();
    }

    public void doAscii2Gif() {
        IDocumentEditor editor = this.mainPanel.getEditor();
        if (editor == null) {
            return;
        }
        Ascii2GIFDialog ad = new Ascii2GIFDialog(this.frame, editor, JaveGlobalRessources.getColorSchemeModel().getColorScheme(), this.documentManager.getCurrentDirectoryModel(), this.applicationPreferences.getDisplayFontModel().getFont());
        ad.show();
    }

    public void doCamel() {
        CharacterPlate cp = this.getContentOfInterest().getContent();
        if (cp.getNonEmptyCharCount() < 12) {
            MessageDialogFactory.showMessageDialog(this.frame, new Message("JavE", "The current document does not contain enough text.\nThe Camelizer can not be applied.", MessageType.INFORMATION));
            return;
        }
        if (this.camelDialog == null) {
            this.camelDialog = new CamelDialog(this, this.documentManager.getCurrentDirectoryModel());
        }
        this.camelDialog.setSourceText(cp);
        this.camelDialog.show();
    }

    public final void beep() {
        this.frame.getToolkit().beep();
    }

    public void doPreviousDocument() {
        int index = this.documentManager.getCurrentDocumentIndex() - 1;
        if (index < 0) {
            index = this.documentManager.getSize() - 1;
        }
        this.setCurrentDocument(index);
    }

    public void doNextDocument() {
        int index = this.documentManager.getCurrentDocumentIndex() + 1;
        if (index >= this.documentManager.getSize()) {
            index = 0;
        }
        this.setCurrentDocument(index);
    }

    public void setCurrentDocument(int index) {
        PlateDocument d = this.mainPanel.getDocument();
        if (d != null) {
            d.documentHiding();
        }
        if (index < 0 || index >= this.documentManager.getSize()) {
            this.updateUndoRedo();
            return;
        }
        this.documentManager.setCurrentDocument(index);
        PlateDocument currentDoc = this.documentManager.getCurrentDocument();
        this.mainPanel.setCurrentEditor(index);
        JaveGlobalRessources.setColorScheme(currentDoc.getColorScheme());
        this.updateUndoRedo();
        this.mainPanel.repaint();
        currentDoc.documentShowing();
    }

    public void selectAll() {
        this.mainPanel.selectAll();
        this.switchToSelectonTool();
        this.mainPanel.saveCurrentState("select all");
    }

    public void switchToSelectonTool() {
        this.setTool(12);
        ((SelectionTool)this.mainPanel.getCurrentTool()).synchronizeToSelection();
    }

    public void switchToTextTool(int x, int y) {
        this.setTool(10);
        ((TextTool)this.mainPanel.getCurrentTool()).setCursorLocation(x, y);
    }

    public void switchToTextTool(char ch, int x, int y) {
        this.setTool(10);
        TextTool textTool = (TextTool)this.mainPanel.getCurrentTool();
        textTool.setCursorLocation(x, y);
        textTool.checkSize();
        textTool.charEntered(ch);
    }

    public void switchToTextTool() {
        this.setTool(10);
    }

    public SelectionTool getSelectionTool() {
        return (SelectionTool)this.mainPanel.getToolManager().getTool(12);
    }

    public void setTool(int toolIndex) {
        if (this.mainPanel.getToolManager().getCurrentToolIndex() == toolIndex) {
            return;
        }
        Tool newTool = this.mainPanel.getToolManager().getTool(toolIndex);
        if (this.optionsDialog != null) {
            this.optionsDialog.setTool(newTool);
        }
        this.toolBar.selectToolButton(toolIndex);
        this.mainPanel.setCurrentTool(newTool);
        this.updateSelectionMenu();
    }

    public Plate pasteAsNewDocument(CharacterPlate content) {
        return this.pasteAsNewDocument(content, null);
    }

    public Plate pasteAsNewDocument(CharacterPlate content, String documentName) {
        PlateDocument doc = this.documentManager.createNew(this.applicationPreferences.getDefaultDocumentSize());
        String stopGapName = DocumentDefaultTitleFactory.createDefaultDocumentTitle(documentName);
        doc.setContent(content);
        TextDocumentEditor editor = new TextDocumentEditor(stopGapName, doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel());
        this.mainPanel.addPlate(editor);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
        return editor.getPlate();
    }

    public Plate pasteAsNewGameDocument(CharacterPlate content, String documentName) {
        PlateDocument doc = this.documentManager.createNew(this.applicationPreferences.getDefaultDocumentSize());
        doc.setContent(content);
        GameDocumentEditor editor = new GameDocumentEditor(DocumentDefaultTitleFactory.createDefaultDocumentTitle(documentName), doc, this, this.platePreferences, this.mainPanel.getToolManager(), this.applicationPreferences.getDisplayFontModel());
        this.mainPanel.addPlate(editor);
        this.setCurrentDocument(this.documentManager.getCurrentDocumentIndex());
        this.updateStatusFile();
        return editor.getPlate();
    }

    public void pasteAsNewSelection(CharacterPlate content, int x, int y) {
        this.pasteAsNewSelection(content, new Point(x, y));
    }

    public void pasteAsNewSelection(CharacterPlate content, Point location) {
        if (this.mainPanel.getDocument() == null) {
            this.pasteAsNewDocument(content);
            return;
        }
        this.mainPanel.pasteAsNewSelection(content, location);
        this.switchToSelectonTool();
        this.updateSelectionMenu();
        this.mainPanel.saveCurrentState("paste");
    }

    public void pasteAsNewSelection(JaveClipboardSelection sel, Point location) {
        if (this.mainPanel.getDocument() == null) {
            this.pasteAsNewDocument(sel.getContent());
            return;
        }
        this.mainPanel.pasteAsNewSelection(sel, location);
        this.switchToSelectonTool();
        this.updateSelectionMenu();
        this.mainPanel.saveCurrentState("paste");
    }

    public void setAsSelection(String text) {
        if (!this.mainPanel.hasSelection()) {
            this.pasteAsNewSelection(text);
            return;
        }
        this.mainPanel.setSelectionContent(new CharacterPlate(text));
        this.switchToSelectonTool();
    }

    public void pasteAsNewSelection(JaveClipboardSelection sel) {
        this.pasteAsNewSelection(sel, this.mainPanel.getPasteLocation());
    }

    public void pasteAsNewSelection(CharacterPlate content) {
        this.pasteAsNewSelection(content, this.mainPanel.getPasteLocation());
    }

    public void pasteAsNewSelection(char[][] content) {
        this.pasteAsNewSelection(new CharacterPlate(content));
    }

    public void pasteAsNewSelection(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.pasteAsNewSelection(new CharacterPlate(text));
    }

    protected void toggleInsert() {
        boolean insert = !Tool.isInsert();
        this.lInsert.setText(insert ? "INS" : "OVR");
        this.mainPanel.getCurrentTool().setInsert(insert);
        this.mainPanel.repaintCursor();
    }

    public void showTextboxDialog() {
        if (this.textboxDialog == null) {
            this.textboxDialog = new TextboxDialog(this);
            GuiUtilities.centerOnScreen(this.textboxDialog.getDialog());
        }
        this.textboxDialog.show();
    }

    public void showFigletDialog(Component parentComponent) {
        if (this.figletDialog == null) {
            this.figletDialog = new FigletEditorDialog(parentComponent, this.figletPreferences, this.applicationPreferences.getDisplayFontModel());
        }
        this.figletDialog.show();
        if (!this.figletDialog.isCanceled()) {
            String text = this.figletDialog.getResultText();
            this.pasteAsNewSelection(text);
        }
    }

    public void showClipartDialog(Component parentComponent) {
        ClipartManager clipartManager = ClipartManager.performLoad(parentComponent);
        if (clipartManager == null) {
            return;
        }
        ClipartDialog clipartDialog = new ClipartDialog(this, clipartManager);
        GuiUtilities.centerOnScreen(clipartDialog.getDialog());
        clipartDialog.getDialog().setVisible(true);
    }

    public static void main(String[] arguments) {
        if (arguments != null && arguments.length > 0) {
            CommandLineJave clj = new CommandLineJave(arguments);
            if (clj.doIt()) {
                System.exit(0);
                return;
            }
            return;
        }
        JaveMainApplicationStarter.startJaveApplication(arguments);
    }

    public void dispose() {
        this.frame.dispose();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void toFront() {
        this.frame.toFront();
    }

    public void saveCurrentState(String actionName) {
        this.mainPanel.saveCurrentState(actionName);
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public JaveMainPanel getMainPanel() {
        return this.mainPanel;
    }

    public JaveApplicationPreferences getApplicationPreferences() {
        return this.applicationPreferences;
    }

    public StatusBar getStatusDisplay() {
        return this.status;
    }
}

