/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.dialog.GDialog;
import de.jave.image2ascii.IImage2AsciiResultTaker;
import de.jave.image2ascii.Image2Texter;
import de.jave.image2ascii.dialog.ImageOpenPerformer;
import de.jave.image2ascii.model.Image2AsciiSourceImageModel;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.watermark.WatermarkImageFile;
import de.jave.lib.CharacterPlate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JDialog;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.BasicDialogUi;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;

public final class Image2AsciiDialog {
    private final IImage2AsciiResultTaker resultTaker;
    private final Image2Texter editor;
    private final JDialog dialog;

    public Image2AsciiDialog(Component parentComponent, IImage2AsciiResultTaker resultTaker, FileModel currentDirectoryModel, FontModel displayFontModel, AnimationExportPreferences animationExportPreferences) {
        Ensure.ensureArgumentNotNull(resultTaker);
        this.dialog = GDialog.createJDialog(parentComponent, "Image2Ascii", true);
        this.dialog.setModal(true);
        this.resultTaker = resultTaker;
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                Image2AsciiDialog.this.performCancel();
            }
        });
        this.editor = new Image2Texter(currentDirectoryModel, displayFontModel, animationExportPreferences);
        SmartAction insertAction = new SmartAction(BasicDialogUi.OK_TEXT_SMART){

            protected final void execute(Component parent) {
                Image2AsciiDialog.this.performOk(parent);
            }
        };
        SmartAction closeAction = new SmartAction(BasicDialogUi.CANCEL_TEXT_SMART){

            protected final void execute(Component parent) {
                Image2AsciiDialog.this.performCancel();
            }
        };
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(insertAction);
        buttonPanelBuilder.add(closeAction);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add(this.editor.getContent(), "Center");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
    }

    private void performOk(Component parentComponent) {
        CharacterPlate cp = this.editor.getResult();
        if (cp != null) {
            WatermarkImageFile watermarkImageFile;
            GDialog gd = new GDialog(parentComponent, "Image2Ascii", "Do you want to set the\nconverted image as watermark?", GDialog.YES_NO_CANCEL, 0);
            gd.show();
            int answer = gd.getAnswer();
            if (answer != 0 && answer != 1) {
                return;
            }
            if (answer == 0) {
                Image2AsciiSourceImageModel sourceImageModel = this.editor.getSourceImageModel();
                watermarkImageFile = new WatermarkImageFile(sourceImageModel.getSourceImage().getOriginalImage(), sourceImageModel.getFileModel().getFile());
            } else {
                watermarkImageFile = null;
            }
            this.resultTaker.takeImage2AsciiResult(cp, watermarkImageFile);
        }
        this.dialog.setVisible(false);
    }

    public final boolean open(File file) {
        return new ImageOpenPerformer(this.editor.getSourceImageModel()).performOpen(this.getDialog(), file);
    }

    private void performCancel() {
        this.dialog.setVisible(false);
    }

    public final JDialog getDialog() {
        return this.dialog;
    }
}

