/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.calculus.CalculusTool;
import de.jave.calculus.ParseException;
import de.jave.formula2.Formula2;
import de.jave.gui.layout.VFlowLayout;
import de.jave.jave.DialogTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.pixelplate.PixelPlateFeltPenMode;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.lib.CharacterPlate;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class FunctionPlotTool
extends DialogTool
implements ItemListener {
    private static final String[] STR_STYLE = new String[]{"Lines", "Dot", "2by2 (JFL...)", "3by2", "Felt pen 8"};
    private static final PixelPlateMode[] MODE = new PixelPlateMode[]{PixelPlateMode.PIXEL, PixelPlateMode.DOT, PixelPlateMode.TWO_BY_TWO, PixelPlateMode.THREE_BY_TWO, PixelPlateFeltPenMode.FELTPEN_8};
    private JTextField tfFormula;
    private JComboBox chStyle;
    private JCheckBox cbLegend;
    private JTextField dfXMin;
    private JTextField dfXMax;
    private JTextField dfYMin;
    private JTextField dfYMax;
    private JTextField dfAxisX;
    private JTextField dfAxisY;

    public FunctionPlotTool(Jave asciiPainter, JaveApplicationPreferences preferences) {
        super(asciiPainter, preferences);
    }

    protected final ColorScheme getPreferredColorScheme() {
        return ColorScheme.BLACK_ON_WHITE;
    }

    public final Component getOptionsComponent() {
        JPanel panel = new JPanel(new GridDialogLayout(2, false));
        AbstractDocumentChangeListener listener = new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                FunctionPlotTool.this.convert();
            }
        };
        this.dfXMin = new JTextField("-4.7", 10);
        this.dfXMin.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel("X min:"), GridDialogLayoutData.RIGHT);
        panel.add(this.dfXMin);
        this.dfXMax = new JTextField("4.7", 10);
        this.dfXMax.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel("X max:"), GridDialogLayoutData.RIGHT);
        panel.add(this.dfXMax);
        this.dfYMin = new JTextField("-9.0", 10);
        this.dfYMin.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel("Y min:"), GridDialogLayoutData.RIGHT);
        panel.add(this.dfYMin);
        this.dfYMax = new JTextField("9.0", 10);
        this.dfYMax.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel("Y max:"), GridDialogLayoutData.RIGHT);
        panel.add(this.dfYMax);
        this.dfAxisX = new JTextField("0.0", 10);
        this.dfAxisX.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel("Axis X="), GridDialogLayoutData.RIGHT);
        panel.add(this.dfAxisX);
        this.dfAxisY = new JTextField("0.0", 10);
        this.dfAxisY.getDocument().addDocumentListener(listener);
        panel.add((Component)new JLabel("Axis Y="), GridDialogLayoutData.RIGHT);
        panel.add(this.dfAxisY);
        this.tfFormula = new JTextField("sin(x)+x/2");
        this.tfFormula.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.tfFormula.getDocument().addDocumentListener(listener);
        JLabel l1 = new JLabel("f(x)=");
        l1.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        JPanel pFormula = new JPanel();
        pFormula.add(l1);
        pFormula.add(this.tfFormula);
        JPanel pOptions = new JPanel();
        this.chStyle = new JComboBox<String>(STR_STYLE);
        this.chStyle.addItemListener(this);
        this.cbLegend = new JCheckBox("Legend", false);
        this.cbLegend.addItemListener(this);
        pOptions.add(new JLabel("Style:"));
        pOptions.add(this.chStyle);
        pOptions.add(this.cbLegend);
        JPanel p = new JPanel();
        p.setLayout(new VFlowLayout());
        p.add(pFormula);
        p.add(panel);
        p.add(pOptions);
        return p;
    }

    protected final String getToolTitle() {
        return "Function Plotter";
    }

    public final String getToolActionName() {
        return "plot";
    }

    protected final void toolStarted() {
        this.convert();
    }

    public final void itemStateChanged(ItemEvent evt) {
        this.convert();
    }

    private void convert() {
        double axisX;
        double t;
        boolean plateWidth = false;
        boolean plateHeight = false;
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        try {
            minX = Double.valueOf(this.dfXMin.getText());
            this.dfXMin.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfXMin.setForeground(Color.red);
            return;
        }
        try {
            maxX = Double.valueOf(this.dfXMax.getText());
            this.dfXMax.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfXMax.setForeground(Color.red);
            return;
        }
        try {
            minY = Double.valueOf(this.dfYMin.getText());
            this.dfYMin.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfYMin.setForeground(Color.red);
            return;
        }
        try {
            maxY = Double.valueOf(this.dfYMax.getText());
            this.dfYMax.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfYMax.setForeground(Color.red);
            return;
        }
        if (maxX == minX) {
            this.dfXMin.setForeground(Color.magenta);
            this.dfXMax.setForeground(Color.magenta);
            return;
        }
        if (maxY == minY) {
            this.dfYMin.setForeground(Color.magenta);
            this.dfYMax.setForeground(Color.magenta);
            return;
        }
        if (minX > maxX) {
            t = minX;
            minX = maxX;
            maxX = t;
        }
        if (minY > maxY) {
            t = minY;
            minY = maxY;
            maxY = t;
        }
        double axisY = 0.0;
        try {
            axisX = Double.valueOf(this.dfAxisX.getText());
            this.dfAxisX.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfAxisX.setForeground(Color.red);
            return;
        }
        try {
            axisY = Double.valueOf(this.dfAxisY.getText());
            this.dfAxisY.setForeground(Color.black);
        }
        catch (NumberFormatException numberFormatException) {
            this.dfAxisY.setForeground(Color.red);
            return;
        }
        if (axisX < minX) {
            axisX = minX;
            this.dfAxisX.setForeground(Color.magenta);
        } else if (axisX > maxX) {
            axisX = maxX;
            this.dfAxisX.setForeground(Color.magenta);
        }
        if (axisY < minY) {
            axisY = minY;
            this.dfAxisY.setForeground(Color.magenta);
        } else if (axisY > maxY) {
            axisY = maxY;
            this.dfAxisY.setForeground(Color.magenta);
        }
        PixelPlateMode axisMode = PixelPlateMode.PIXEL;
        PixelPlateMode plotMode = MODE[this.chStyle.getSelectedIndex()];
        String formula = this.tfFormula.getText();
        CharacterPlate cp = CalculusTool.createAxis(axisMode, axisX, axisY, 70, 30, minX, maxX, minY, maxY);
        cp.setMix(false);
        try {
            CalculusTool.plotFunction(formula, plotMode, 70, 30, minX, maxX, minY, maxY, cp);
        }
        catch (ParseException parseException) {
            cp.paste("No valid expression!", 1, 1);
        }
        this.characterPlate.clear();
        cp.pasteIntoForce(this.characterPlate, 0, 0);
        if (this.cbLegend.isSelected()) {
            String s = null;
            try {
                s = Formula2.toAscii(formula);
            }
            catch (de.jave.formula2.ParseException parseException) {
                s = "No valid expression!";
            }
            CharacterPlate lp = new CharacterPlate(s);
            lp.pasteInto(this.characterPlate, 1, 1);
        }
        this.repaintPlate();
    }
}

