/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.formula2.Formula2;
import de.jave.formula2.TokenMgrError;
import de.jave.gui.GTextArea;
import de.jave.gui.dialog.GDialog;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveHelpButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;

public final class FormulaEditor {
    private Jave jave;
    private JTextField tfInput;
    private JTextField tfStatus;
    private final GTextArea tfResult;
    private final JDialog dialog;

    public FormulaEditor(Jave jave) {
        this.dialog = GDialog.createJDialog(jave.getFrame(), "Mathematical Expression Editor", true);
        this.jave = jave;
        this.tfInput = new JTextField("sqrt(pi)/5*x_i+2^{y+z}");
        this.tfInput.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                FormulaEditor.this.convert();
            }
        });
        this.tfInput.selectAll();
        this.tfResult = new GTextArea(7, 40);
        this.tfResult.setEditable(false);
        JaveHelpButton bHelp = new JaveHelpButton("./formula2/formula2.html");
        this.tfStatus = new JTextField("Initializing...");
        this.tfStatus.setEditable(false);
        this.tfInput.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.tfInput, "North");
        mainPanel.add((Component)this.tfResult.getContent(), "Center");
        mainPanel.add((Component)this.tfStatus, "South");
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(new SmartAction("&OK"){

            protected final void execute(Component parentComponent) {
                FormulaEditor.this.performOk();
            }
        });
        buttonPanelBuilder.add(new SmartAction("&Cancel"){

            protected final void execute(Component parentComponent) {
                FormulaEditor.this.performCancel();
            }
        });
        buttonPanelBuilder.add(bHelp);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)mainPanel, "Center");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                FormulaEditor.this.performCancel();
            }

            public final void windowActivated(WindowEvent e) {
                FormulaEditor.this.tfInput.requestFocus();
            }
        });
        this.dialog.pack();
        this.convert();
    }

    private void performOk() {
        this.jave.pasteAsNewSelection(this.tfResult.getText());
        this.dialog.setVisible(false);
    }

    private void performCancel() {
        this.dialog.setVisible(false);
    }

    public final void convert() {
        String code = this.tfInput.getText();
        String result = null;
        boolean syntaxOk = true;
        if (code.trim().length() == 0) {
            result = "";
            syntaxOk = true;
        } else {
            while (result == null) {
                try {
                    result = Formula2.toAscii(code);
                }
                catch (TokenMgrError tokenMgrError) {
                    syntaxOk = false;
                    result = null;
                    if (code.length() == 0) {
                        result = "";
                        continue;
                    }
                    code = code.substring(0, code.length() - 1);
                }
                catch (Exception exception) {
                    syntaxOk = false;
                    result = null;
                    if (code.length() == 0) {
                        result = "";
                        continue;
                    }
                    code = code.substring(0, code.length() - 1);
                }
            }
        }
        String statusMessage = syntaxOk ? "Ok." : "Syntax error.";
        this.tfStatus.setText(statusMessage);
        this.tfResult.setText(result);
        this.tfInput.requestFocus();
    }

    public final JDialog getDialog() {
        return this.dialog;
    }
}

