/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.RectangleAlgorithm;
import de.jave.jave.algorithm.rectangle.RectangleStyle;
import de.jave.lib.CharacterPlate;
import java.awt.Insets;
import java.awt.Rectangle;

public final class FilterMatrix {
    private char[][] mask;
    private int maskWidth;
    private int maskHeight;
    private int maskCenterX;
    private int maskCenterY;
    private char[][] result;
    private int resultWidth;
    private int resultHeight;
    private int resultCenterX;
    private int resultCenterY;
    private int must3;
    private int optional3;

    public final String toString() {
        CharacterPlate cp = new CharacterPlate(40, 8);
        cp.setMix(false);
        new CharacterPlate(this.mask).pasteInto(cp, 2, 1);
        RectangleAlgorithm.drawRectangle(cp, new Rectangle(1, 0, this.maskWidth + 2, this.maskHeight + 2), RectangleStyle.NORMAL);
        new CharacterPlate(this.mask).pasteInto(cp, 12, 1);
        new CharacterPlate(this.result).pasteInto(cp, 12 - this.resultCenterX + this.maskCenterX, 1 - this.resultCenterY + this.maskCenterY);
        RectangleAlgorithm.drawRectangle(cp, new Rectangle(11, 0, this.maskWidth + 2, this.maskHeight + 2), RectangleStyle.NORMAL);
        Insets in = cp.getEmptyInsets();
        cp.setSize(cp.getWidth(), cp.getHeight() - in.bottom);
        return cp.toString();
    }

    public FilterMatrix(String sizeString, String maskString, String resultString) {
        int x;
        int y;
        this.maskWidth = sizeString.charAt(0) - 48;
        this.maskHeight = sizeString.charAt(1) - 48;
        this.resultWidth = sizeString.charAt(2) - 48;
        this.resultHeight = sizeString.charAt(3) - 48;
        this.maskCenterX = (this.maskWidth - 1) / 2;
        this.maskCenterY = (this.maskHeight - 1) / 2;
        this.mask = new char[this.maskHeight][this.maskWidth];
        for (int y2 = 0; y2 < this.maskHeight; ++y2) {
            for (int x2 = 0; x2 < this.maskWidth; ++x2) {
                this.mask[y2][x2] = maskString.charAt(y2 * this.maskWidth + x2);
            }
        }
        CharacterPlate cp = new CharacterPlate(this.mask);
        Insets in = cp.getEmptyInsets('?');
        this.maskWidth -= in.left + in.right;
        this.maskHeight -= in.top + in.bottom;
        this.maskCenterX -= in.left;
        this.maskCenterY -= in.top;
        this.mask = cp.getCopy(in.left, in.top, this.maskWidth, this.maskHeight).getContent();
        this.resultCenterX = (this.resultWidth - 1) / 2;
        this.resultCenterY = (this.resultHeight - 1) / 2;
        this.result = new char[this.resultHeight][this.resultWidth];
        for (y = 0; y < this.resultHeight; ++y) {
            for (x = 0; x < this.resultWidth; ++x) {
                this.result[y][x] = resultString.charAt(y * this.resultWidth + x);
            }
        }
        cp = new CharacterPlate(this.result);
        in = cp.getEmptyInsets('?');
        this.resultWidth -= in.left + in.right;
        this.resultHeight -= in.top + in.bottom;
        this.resultCenterX -= in.left;
        this.resultCenterY -= in.top;
        this.result = cp.getCopy(in.left, in.top, this.resultWidth, this.resultHeight).getContent();
        this.optional3 = 0;
        this.must3 = 0;
        for (y = this.maskCenterY - 1; y <= this.maskCenterY + 1; ++y) {
            for (x = this.maskCenterX - 1; x <= this.maskCenterX + 1; ++x) {
                if (y < 0 || y >= this.maskHeight || x < 0 || x >= this.maskWidth || this.mask[y][x] == ' ') continue;
                if (this.mask[y][x] == '?') {
                    ++this.optional3;
                    continue;
                }
                ++this.must3;
            }
        }
    }

    public final boolean fits(CharacterPlate cp, int w, int h, int x, int y, int setCount) {
        if ((setCount < this.must3 || setCount > this.must3 + this.optional3) && setCount > -1) {
            return false;
        }
        int x0 = x - this.maskCenterX;
        if (x0 < 0) {
            return false;
        }
        int x1 = x - this.maskCenterX + this.maskWidth - 1;
        if (x1 >= w) {
            return false;
        }
        int y0 = y - this.maskCenterY;
        if (y0 < 0) {
            return false;
        }
        int y1 = y - this.maskCenterY + this.maskHeight - 1;
        if (y1 >= h) {
            return false;
        }
        for (int i = x0; i <= x1; ++i) {
            for (int j = y0; j <= y1; ++j) {
                int yy = j - y + this.maskCenterY;
                int xx = i - x + this.maskCenterX;
                if (this.mask[yy][xx] == '?' || this.mask[yy][xx] == '!' && cp.get(i, j) != ' ' || cp.get(i, j) == this.mask[yy][xx]) continue;
                return false;
            }
        }
        return true;
    }

    public final void apply(CharacterPlate cp, int w, int h, int x, int y) {
        int y1;
        int y0;
        int x1;
        int x0 = x - this.resultCenterX;
        if (x0 < 0) {
            x0 = 0;
        }
        if ((x1 = x - this.resultCenterX + this.resultWidth - 1) >= w) {
            x1 = w - 1;
        }
        if ((y0 = y - this.resultCenterY) < 0) {
            y0 = 0;
        }
        if ((y1 = y - this.resultCenterY + this.resultHeight - 1) >= h) {
            y1 = h - 1;
        }
        for (int i = x0; i <= x1; ++i) {
            for (int j = y0; j <= y1; ++j) {
                char ch = this.result[j - y + this.resultCenterY][i - x + this.resultCenterX];
                if (ch == '?') continue;
                cp.setForce(i, j, ch);
            }
        }
    }
}

