/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.AbstractPencilTool;
import de.jave.jave.Jave;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.plate.JaveMainPanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public class EraserTool
extends AbstractPencilTool {
    private JComboBox chStyle;
    private static final String[] STYLE_STR = new String[]{"Round", "Square", "Right Slash", "Left Slash"};
    private static int DEFAULT_SIZE = 3;
    private static final char[][][][] BRUSHES = new char[][][][]{new char[][][]{new char[][]{{'X'}}, new char[][]{{'X', 'X'}, {'X', 'X'}}, new char[][]{{'\u0000', 'X', 'X', 'X', '\u0000'}, {'X', 'X', 'X', 'X', 'X'}, {'\u0000', 'X', 'X', 'X', '\u0000'}}, new char[][]{{'\u0000', 'X', 'X', 'X', '\u0000'}, {'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X'}, {'\u0000', 'X', 'X', 'X', '\u0000'}}, new char[][]{{'\u0000', '\u0000', 'X', 'X', 'X', '\u0000', '\u0000'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'\u0000', '\u0000', 'X', 'X', 'X', '\u0000', '\u0000'}}, new char[][]{{'\u0000', '\u0000', '\u0000', 'X', 'X', 'X', '\u0000', '\u0000', '\u0000'}, {'\u0000', 'X', 'X', 'X', 'X', 'X', 'X', 'X', '\u0000'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'\u0000', 'X', 'X', 'X', 'X', 'X', 'X', 'X', '\u0000'}, {'\u0000', '\u0000', '\u0000', 'X', 'X', 'X', '\u0000', '\u0000', '\u0000'}}}, new char[][][]{new char[][]{{'X'}}, new char[][]{{'X', 'X'}, {'X', 'X'}}, new char[][]{{'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X'}}, new char[][]{{'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X'}}, new char[][]{{'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X'}}, new char[][]{{'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X'}, {'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X', 'X'}}}, new char[][][]{new char[][]{{'X'}}, new char[][]{{'\u0000', 'X'}, {'X', '\u0000'}}, new char[][]{{'\u0000', '\u0000', 'X', 'X'}, {'\u0000', 'X', 'X', '\u0000'}, {'X', 'X', '\u0000', '\u0000'}}, new char[][]{{'\u0000', '\u0000', '\u0000', 'X', 'X'}, {'\u0000', '\u0000', 'X', 'X', '\u0000'}, {'\u0000', 'X', 'X', '\u0000', '\u0000'}, {'X', 'X', '\u0000', '\u0000', '\u0000'}}, new char[][]{{'\u0000', '\u0000', '\u0000', '\u0000', 'X', 'X'}, {'\u0000', '\u0000', '\u0000', 'X', 'X', '\u0000'}, {'\u0000', '\u0000', 'X', 'X', '\u0000', '\u0000'}, {'\u0000', 'X', 'X', '\u0000', '\u0000', '\u0000'}, {'X', 'X', '\u0000', '\u0000', '\u0000', '\u0000'}}, new char[][]{{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'X', 'X'}, {'\u0000', '\u0000', '\u0000', '\u0000', 'X', 'X', '\u0000'}, {'\u0000', '\u0000', '\u0000', 'X', 'X', '\u0000', '\u0000'}, {'\u0000', '\u0000', 'X', 'X', '\u0000', '\u0000', '\u0000'}, {'\u0000', 'X', 'X', '\u0000', '\u0000', '\u0000', '\u0000'}, {'X', 'X', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}}}, new char[][][]{new char[][]{{'X'}}, new char[][]{{'X', '\u0000'}, {'\u0000', 'X'}}, new char[][]{{'X', 'X', '\u0000', '\u0000'}, {'\u0000', 'X', 'X', '\u0000'}, {'\u0000', '\u0000', 'X', 'X'}}, new char[][]{{'X', 'X', '\u0000', '\u0000', '\u0000'}, {'\u0000', 'X', 'X', '\u0000', '\u0000'}, {'\u0000', '\u0000', 'X', 'X', '\u0000'}, {'\u0000', '\u0000', '\u0000', 'X', 'X'}}, new char[][]{{'X', 'X', '\u0000', '\u0000', '\u0000', '\u0000'}, {'\u0000', 'X', 'X', '\u0000', '\u0000', '\u0000'}, {'\u0000', '\u0000', 'X', 'X', '\u0000', '\u0000'}, {'\u0000', '\u0000', '\u0000', 'X', 'X', '\u0000'}, {'\u0000', '\u0000', '\u0000', '\u0000', 'X', 'X'}}, new char[][]{{'X', 'X', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, {'\u0000', 'X', 'X', '\u0000', '\u0000', '\u0000', '\u0000'}, {'\u0000', '\u0000', 'X', 'X', '\u0000', '\u0000', '\u0000'}, {'\u0000', '\u0000', '\u0000', 'X', 'X', '\u0000', '\u0000'}, {'\u0000', '\u0000', '\u0000', '\u0000', 'X', 'X', '\u0000'}, {'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'X', 'X'}}}};
    private SpinnerNumberModel sizeModel;

    public EraserTool(JaveMainPanel plate, Jave asciiPainter) {
        super(plate, asciiPainter);
    }

    public String getUndoRedoActionName() {
        return "erase";
    }

    public String getName() {
        return "Eraser";
    }

    public Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("tool/eraser.gif");
    }

    public JComponent createOptionsComponent() {
        this.chStyle = new JComboBox<String>(STYLE_STR);
        this.chStyle.setSelectedIndex(0);
        this.sizeModel = new SpinnerNumberModel(DEFAULT_SIZE, 1, 6, 1);
        this.sizeModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                EraserTool.this.updateBrush();
            }
        });
        this.chStyle.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                EraserTool.this.updateBrush();
            }
        });
        JPanel optionsPanel = new JPanel(new GridDialogLayout(2, false));
        optionsPanel.add((Component)new JLabel("Style:"), GridDialogLayoutData.RIGHT);
        optionsPanel.add(this.chStyle);
        optionsPanel.add((Component)new JLabel("Size:"), GridDialogLayoutData.RIGHT);
        optionsPanel.add(new JSpinner(this.sizeModel));
        return optionsPanel;
    }

    public final void itemStateChanged(ItemEvent evt) {
        this.updateBrush();
    }

    private void updateBrush() {
        this.repaintCursor();
    }

    protected void paint(int x0, int y0) {
        char ch = ' ';
        if (this.isMouseRightButton()) {
            ch = this.getMouseCharacterModel().getCharacter1();
        }
        if (ch == '\u00a0') {
            ch = ' ';
        }
        char[][] brush = this.getBrush();
        int h = brush.length;
        int w = brush[0].length;
        int cx = (w - 1) / 2;
        int cy = (h - 1) / 2;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (brush[y][x] <= '\u0000') continue;
                this.getPlate().setCharForce(x0 - cx + x, y0 - cy + y, ch);
            }
        }
        this.getPlate().repaint(50L);
    }

    protected final char[][] getBrush() {
        int style = this.chStyle.getSelectedIndex();
        int size = this.sizeModel.getNumber().intValue() - 1;
        return BRUSHES[style][size];
    }
}

