/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.dialog.GDialog;
import de.jave.jave.Jave;
import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.lib.CharacterPlate;
import de.jave.lib.gui.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;

public abstract class DialogTool {
    private Jave jave;
    private Plate plate;
    protected PixelPlate markPlate;
    protected CharacterPlate characterPlate;
    protected int plateWidth;
    protected int plateHeight;
    private PlateDocument document;
    private JDialog dialog;
    private final JaveApplicationPreferences preferences;

    public DialogTool(Jave asciiPainter, JaveApplicationPreferences preferences) {
        Ensure.ensureArgumentNotNull(preferences);
        this.preferences = preferences;
        this.dialog = GDialog.createJDialog(asciiPainter.getFrame(), this.getToolTitle(), true);
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                DialogTool.this.performCancel(DialogTool.this.dialog);
            }
        });
        this.jave = asciiPainter;
        this.characterPlate = new CharacterPlate(this.getPreferredPlateSize());
        this.plateWidth = this.characterPlate.getWidth();
        this.plateHeight = this.characterPlate.getHeight();
        this.plate = this.jave.pasteAsNewDocument(this.characterPlate, this.getToolTitle());
        this.document = this.plate.getDocument();
        this.document.setModified(false);
        this.jave.performSetColorScheme(this.getPreferredColorScheme());
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(new SmartAction("&OK"){

            protected final void execute(Component parentComponent) {
                DialogTool.this.performOk();
            }
        });
        buttonPanelBuilder.add(new SmartAction("&Cancel"){

            protected final void execute(Component parentComponent) {
                DialogTool.this.performCancel(parentComponent);
            }
        });
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add(this.getOptionsComponent(), "Center");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.pack();
        GuiUtilities.centerOnScreen(this.dialog);
    }

    protected final FileModel getCurrentDirectoryModel() {
        return this.jave.getDocumentManager().getCurrentDirectoryModel();
    }

    protected final JDialog getDialog() {
        return this.dialog;
    }

    protected void toolStarted() {
    }

    public final void show() {
        this.jave.hideToolOptionsDialog();
        this.toolStarted();
        this.dialog.setVisible(true);
    }

    protected final void performCancel(Component parentComponent) {
        this.document.setModified(false);
        this.jave.doClose(parentComponent);
        this.jave.showToolOptionsDialog();
        this.dialog.dispose();
    }

    protected final void repaintPlate() {
        this.plate.repaint();
    }

    protected final void saveCurrentState(String shortDescription) {
        this.plate.saveCurrentState(shortDescription);
    }

    private Dimension getPreferredPlateSize() {
        return this.preferences.getDefaultDocumentSize();
    }

    protected abstract String getToolTitle();

    protected abstract ColorScheme getPreferredColorScheme();

    protected abstract String getToolActionName();

    protected abstract Component getOptionsComponent();

    private void performOk() {
        this.saveCurrentState(this.getToolActionName());
        this.jave.showToolOptionsDialog();
        this.dialog.dispose();
    }
}

