/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.Point2d;
import de.jave.jave.pixelplate.PixelPlate;
import java.awt.Point;
import java.util.Vector;

public final class BezierAlgorithm {
    public static final Point[] getPolyLineForBezier(Point[] bezierPoints) {
        return BezierAlgorithm.getPolyLineForBezier(bezierPoints, 1.0);
    }

    public static final Point[] getPolyLineForBezier(Point[] bezierPoints, double epsilon) {
        Point2d[] points = new Point2d[bezierPoints.length];
        for (int i = 0; i < bezierPoints.length; ++i) {
            points[i] = new Point2d(bezierPoints[i]);
        }
        Vector<Point2d> v = new Vector<Point2d>(64);
        v.addElement(points[0]);
        BezierAlgorithm.internalBezier(v, points, 7, 2.5 * epsilon);
        Point[] result = new Point[v.size()];
        for (int i = 0; i < result.length; ++i) {
            Point2d p = (Point2d)v.elementAt(i);
            result[i] = new Point((int)Math.round(p.x), (int)Math.round(p.y));
        }
        return result;
    }

    public static final Point2d[] getPolyLineForBezier(Point2d[] points, double epsilon) {
        Vector<Point2d> v = new Vector<Point2d>(64);
        v.addElement(points[0]);
        BezierAlgorithm.internalBezier(v, points, 7, 2.5 * epsilon);
        Point2d[] result = new Point2d[v.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Point2d)v.elementAt(i);
        }
        return result;
    }

    protected static final void internalBezier(Vector v, Point2d[] points, int maxDepth, double epsilon) {
        if (maxDepth == 0) {
            v.addElement(points[points.length - 1]);
            return;
        }
        double maxD2 = 0.0;
        for (int i = 0; i < points.length - 2; ++i) {
            double d2x = points[i + 2].x - 2.0 * points[i + 1].x + points[i].x;
            double d2y = points[i + 2].y - 2.0 * points[i + 1].y + points[i].y;
            d2x = d2x >= 0.0 ? d2x : -d2x;
            double d = d2y = d2y >= 0.0 ? d2y : -d2y;
            if (d2x > maxD2) {
                maxD2 = d2x;
            }
            if (!(d2y > maxD2)) continue;
            maxD2 = d2y;
        }
        if (maxD2 < epsilon) {
            v.addElement(points[points.length - 1]);
            return;
        }
        Point2d[] pA = new Point2d[points.length];
        Point2d[] pB = new Point2d[points.length];
        if (points.length == 3) {
            pA[0] = points[0];
            pA[1] = new Point2d((points[0].x + points[1].x) / 2.0, (points[0].y + points[1].y) / 2.0);
            pB[1] = new Point2d((points[1].x + points[2].x) / 2.0, (points[1].y + points[2].y) / 2.0);
            pA[2] = new Point2d((pB[1].x + pA[1].x) / 2.0, (pB[1].y + pA[1].y) / 2.0);
            pB[0] = pA[2];
            pB[2] = points[2];
            BezierAlgorithm.internalBezier(v, pA, maxDepth - 1, epsilon);
            BezierAlgorithm.internalBezier(v, pB, maxDepth - 1, epsilon);
            return;
        }
        System.err.println("drawBezier fuer diesen Kurvengrad noch nicht implementiert!");
    }

    public static final void drawBezier(PixelPlate pixelPlate, Point2d p0, Point2d p1, Point2d p2) {
        Point2d[] point2dArray = new Point2d[3];
        Point2d[] bezPoints = point2dArray;
        point2dArray[0] = p0;
        bezPoints[1] = p1;
        bezPoints[2] = p2;
        Point2d[] polyLine = BezierAlgorithm.getPolyLineForBezier(bezPoints, 0.15);
        for (int i = 0; i < polyLine.length - 1; ++i) {
            pixelPlate.drawLine(polyLine[i].x, polyLine[i].y, polyLine[i + 1].x, polyLine[i + 1].y);
        }
    }
}

