/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.dialog.GDialog;
import de.jave.gui.io.ExtensionFileFilter;
import de.jave.gui.io.FileChooserUtilities;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SmartFileFilter;
import de.jave.image.gui.ImagePanel;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.DocumentListener;
import de.jave.jave.PlateDocument;
import de.jave.jave.export.Ascii2ImageOptions;
import de.jave.jave.export.GifExportOptionsPanel;
import de.jave.jave.plate.DocumentEditorTitleFactory;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.version.JaveTitleProvider;
import de.jave.lib.CharacterPlate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JDialog;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.util.GuiUtilities;
import net.jmge.gif.Gif89Encoder;

public final class Ascii2GIFDialog {
    private GifExportOptionsPanel gifOptionsPanel;
    private BufferedImage image;
    private PlateDocument document;
    private String documentName;
    private final JDialog dialog;
    private final FileModel currentDirectoryModel;
    private final ImagePanel imageCanvas;

    public Ascii2GIFDialog(Component parent, IDocumentEditor editor, ColorScheme colorScheme, FileModel currentDirectoryModel, Font displayFont) {
        Ensure.ensureArgumentNotNull(editor);
        Ensure.ensureArgumentNotNull(currentDirectoryModel);
        this.document = editor.getPlate().getDocument();
        this.currentDirectoryModel = currentDirectoryModel;
        this.documentName = DocumentEditorTitleFactory.createShortEditorTitle(editor);
        this.dialog = GDialog.createJDialog(parent, "Ascii2GIF - " + this.documentName, false);
        this.document.addDocumentListener(new DocumentListener(){

            public final void documentClosing() {
                Ascii2GIFDialog.this.close();
            }

            public final void documentChanged() {
                Ascii2GIFDialog.this.convert();
            }

            public final void documentHiding() {
            }

            public final void documentShowing() {
            }
        });
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                Ascii2GIFDialog.this.close();
            }
        });
        this.dialog.getContentPane().setLayout(new BorderLayout(2, 2));
        this.imageCanvas = new ImagePanel();
        this.imageCanvas.getContent().setPreferredSize(new Dimension(400, 240));
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(new SmartAction("Save..."){

            protected final void execute(Component parentComponent) {
                Ascii2GIFDialog.this.doSaveAs(parentComponent);
            }
        });
        buttonPanelBuilder.add(new SmartAction("Close"){

            protected final void execute(Component parentComponent) {
                Ascii2GIFDialog.this.close();
            }
        });
        this.gifOptionsPanel = new GifExportOptionsPanel(displayFont, false);
        this.gifOptionsPanel.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Ascii2GIFDialog.this.convert();
            }
        });
        this.dialog.getContentPane().add((Component)this.gifOptionsPanel.getContent(), "North");
        this.dialog.getContentPane().add((Component)this.imageCanvas.getContent(), "Center");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.convert();
        this.dialog.pack();
    }

    private void convert() {
        try {
            Ascii2ImageOptions selectedOptions = this.gifOptionsPanel.getSelectedOptions();
            CharacterPlate cp = this.document.getContent();
            this.image = AsciiToThumbnailConverter.convert(cp, selectedOptions);
            this.imageCanvas.setImage(this.image);
            return;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            return;
        }
    }

    public final void close() {
        this.dialog.dispose();
    }

    private void doSaveAs(Component parentComponent) {
        File outputFile = FileChooserUtilities.performSaveFileChooser(parentComponent, new IFileChooserConfiguration(){

            public final FileModel getCurrentDirectoryModel() {
                return Ascii2GIFDialog.this.currentDirectoryModel;
            }

            public final String getSaveDialogTitle() {
                return "Save GIF File";
            }

            public final String getOpenDialogTitle() {
                return null;
            }

            public final SmartFileFilter[] getFileFilters() {
                return new SmartFileFilter[]{new ExtensionFileFilter("GIF image Files", "gif")};
            }

            public final String getFileNameSuggestion() {
                return Ascii2GIFDialog.this.documentName + ".gif";
            }

            public final boolean isMultipleOpenFileSelectionAllowed() {
                return false;
            }
        });
        if (outputFile == null) {
            return;
        }
        String filename = outputFile.getName();
        if (!filename.toLowerCase().endsWith(".gif")) {
            filename = filename + ".gif";
        }
        File file = new File(outputFile.getParentFile(), filename);
        try {
            Gif89Encoder gifEncoder = new Gif89Encoder(this.image);
            gifEncoder.setComments(JaveTitleProvider.CREATED_BY_JAVE);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
            gifEncoder.encode(output);
            ((OutputStream)output).close();
            return;
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    public final void show() {
        GuiUtilities.show(this.dialog);
    }
}

