/*
 * Decompiled with CFR 0.152.
 */
package de.jave.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public final class IOTools {
    private IOTools() {
    }

    public static final String toURLString(File file) {
        return IOTools.toURL(file).toExternalForm();
    }

    public static final URL toURL(File file) {
        try {
            String path = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/") && file.isDirectory()) {
                path = path + "/";
            }
            return new URL("file", "", path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static final String getDisplayFilename(String original, int maxLength) {
        int length = original.length();
        if (length <= maxLength) {
            return original;
        }
        int i2 = original.lastIndexOf(File.separatorChar);
        if (length - i2 + 3 + 3 <= maxLength) {
            return original.substring(0, maxLength - 4 - (length - i2)) + "..." + original.substring(i2);
        }
        return original.substring(0, 3) + "..." + original.substring(length - 1 - maxLength + 6);
    }
}

