/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.dialog;

import de.jave.gui.io.ExtensionFileFilter;
import de.jave.gui.io.FileChooserUtilities;
import de.jave.gui.io.FileSelection;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SmartFileFilter;
import de.jave.image2ascii.dialog.BatchSourceImageModel;
import de.jave.image2ascii.dialog.BatchSourceImageModelListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutDirection;
import net.disy.commons.swing.list.ListSelectionMode;
import net.disy.commons.swing.ui.IObjectUi;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public final class SourceFileListPanel {
    private final JComponent content;
    private final SmartAction moveDownAction;
    private final SmartAction removeAction;
    private final SmartAction moveUpAction;
    private final BatchSourceImageModel model;
    private final JList list;
    private final FileModel currentDirectoryModel;

    public SourceFileListPanel(BatchSourceImageModel model, FileModel currentDirectoryModel) {
        Ensure.ensureArgumentNotNull(model);
        Ensure.ensureArgumentNotNull(currentDirectoryModel);
        this.model = model;
        this.currentDirectoryModel = currentDirectoryModel;
        this.list = new JList(new BatchSourceImageModelListModel(model));
        this.list.setCellRenderer(new ObjectUiListCellRenderer(new IObjectUi(this){

            public final String getLabel(Object value) {
                File file = (File)value;
                return file.getAbsolutePath();
            }

            public final Icon getIcon(Object value) {
                return null;
            }
        }));
        SmartAction addAction = new SmartAction("Add..."){

            protected final void execute(Component parentComponent) {
                SourceFileListPanel.this.performAdd(parentComponent);
            }
        };
        this.removeAction = new SmartAction("Remove"){

            protected final void execute(Component parentComponent) {
                SourceFileListPanel.this.performRemoveSelected();
            }
        };
        this.moveUpAction = new SmartAction("Move up"){

            protected final void execute(Component parentComponent) {
                SourceFileListPanel.this.performMoveUp();
            }
        };
        this.moveDownAction = new SmartAction("Move down"){

            protected final void execute(Component parentComponent) {
                SourceFileListPanel.this.performMoveDown();
            }
        };
        this.list.getSelectionModel().setSelectionMode(ListSelectionMode.MULTIPLE_INTERVAL_SELECTION.getListSelectionMode());
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent e) {
                SourceFileListPanel.this.updateActionsEnabled();
            }
        });
        this.updateActionsEnabled();
        ButtonPanelBuilder builder = new ButtonPanelBuilder(LayoutDirection.VERTICAL);
        builder.add(addAction);
        builder.add(this.removeAction);
        builder.add(this.moveUpAction);
        builder.add(this.moveDownAction);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.list), "Center");
        panel.add((Component)builder.createPanel(), "East");
        panel.add((Component)new JLabel("Source files:"), "North");
        this.content = panel;
    }

    private void performMoveDown() {
        int index = this.list.getSelectedIndex();
        this.model.moveFileDown(index);
        this.list.setSelectedIndex(index + 1);
    }

    private void performMoveUp() {
        int index = this.list.getSelectedIndex();
        this.model.moveFileUp(index);
        this.list.setSelectedIndex(index - 1);
    }

    private void performRemoveSelected() {
        int[] selectedIndices = this.list.getSelectedIndices();
        for (int i = selectedIndices.length - 1; i >= 0; --i) {
            this.model.removeFileAt(selectedIndices[i]);
        }
        this.list.getSelectionModel().clearSelection();
    }

    private void performAdd(Component parentComponent) {
        FileSelection fileSelection = FileChooserUtilities.performOpenFileChooser(parentComponent, new IFileChooserConfiguration(){

            public final FileModel getCurrentDirectoryModel() {
                return SourceFileListPanel.this.currentDirectoryModel;
            }

            public final String getSaveDialogTitle() {
                return null;
            }

            public final String getOpenDialogTitle() {
                return "Open image file(s)";
            }

            public final SmartFileFilter[] getFileFilters() {
                return new SmartFileFilter[]{new ExtensionFileFilter("Image Files", new String[]{"gif", "jpg", "bmp"})};
            }

            public final String getFileNameSuggestion() {
                return null;
            }

            public final boolean isMultipleOpenFileSelectionAllowed() {
                return true;
            }
        });
        if (fileSelection.isEmpty()) {
            return;
        }
        this.model.add(fileSelection.getFiles());
    }

    private void updateActionsEnabled() {
        this.moveDownAction.setEnabled(this.list.getSelectedIndices().length == 1 && this.list.getSelectedIndex() != this.model.getFileCount() - 1);
        this.moveUpAction.setEnabled(this.list.getSelectedIndices().length == 1 && this.list.getSelectedIndex() > 0);
        this.removeAction.setEnabled(!this.list.getSelectionModel().isSelectionEmpty());
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void requestFocus() {
        this.list.requestFocus();
    }
}

