/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm.dialog;

import de.jave.gui.layout.Gap;
import de.jave.image2ascii.algorithm.Algorithm4OptionsModel;
import de.jave.image2ascii.algorithm.dialog.banned.BannedCharactersPanel;
import de.jave.image2ascii.algorithm.dialog.greyscaletable.GreyScaleTablePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.component.IDisposableComponentContainer;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogPanel;
import net.disy.commons.swing.layout.grid.IDialogComponent;

public final class Image2AsciiAlgorithm4OptionsPanel
implements IDisposableComponentContainer {
    private final Algorithm4OptionsModel optionsModel;
    private final ChangeListener optionsModelChangeListener;
    private final BannedCharactersPanel bannedCharactersPanel;
    private final GreyScaleTablePanel greyScaleTablePanel;
    private final JComponent content;

    public Image2AsciiAlgorithm4OptionsPanel(final Algorithm4OptionsModel optionsModel) {
        Ensure.ensureArgumentNotNull(optionsModel);
        this.optionsModel = optionsModel;
        final JCheckBox cbOptimize = new JCheckBox("Consider line distance", optionsModel.isOptimize());
        cbOptimize.addActionListener(new ActionListener(this){

            public final void actionPerformed(ActionEvent e) {
                optionsModel.setOptimize(cbOptimize.isSelected());
            }
        });
        this.optionsModelChangeListener = new ChangeListener(this){

            public final void stateChanged(ChangeEvent e) {
                cbOptimize.setSelected(optionsModel.isOptimize());
            }
        };
        optionsModel.addChangeListener(this.optionsModelChangeListener);
        GridDialogPanel gridPanel = new GridDialogPanel();
        this.greyScaleTablePanel = new GreyScaleTablePanel(optionsModel.getGreyScaleTableSelectionModel(), optionsModel.getDisplayFontModel());
        gridPanel.add(this.greyScaleTablePanel);
        this.bannedCharactersPanel = new BannedCharactersPanel(optionsModel.getBannedCharactersModel(), optionsModel.getDisplayFontModel());
        gridPanel.add(this.bannedCharactersPanel);
        gridPanel.add(new IDialogComponent(this){

            public final void fillInto(JPanel panel, int columnCount) {
                panel.add(new Gap());
                GridDialogLayoutData layoutData = new GridDialogLayoutData();
                layoutData.setHorizontalSpan(columnCount - 1);
                panel.add(cbOptimize);
            }

            public final int getColumnCount() {
                return 2;
            }
        });
        this.content = gridPanel.getContent();
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void dispose() {
        this.optionsModel.removeChangeListener(this.optionsModelChangeListener);
        this.greyScaleTablePanel.dispose();
        this.bannedCharactersPanel.dispose();
    }
}

