/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.SharedImage2AsciiOptions;
import de.jave.image2ascii.algorithm.AlgorithmJavEOptionsModel;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithm1;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithmJavEOptionsPanel;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.lib.CharacterPlate;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.NullProgressMonitor;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public final class Image2AsciiAlgorithmJavE
extends Image2AsciiAlgorithm {
    private final AlgorithmJavEOptionsModel optionsModel;

    public Image2AsciiAlgorithmJavE(SharedImage2AsciiOptions sharedOptions) {
        this.optionsModel = new AlgorithmJavEOptionsModel(sharedOptions);
    }

    public final IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    public final IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorithmJavEOptionsPanel(this.optionsModel);
    }

    public final String getName() {
        return "JavE Algorithm (4/1)";
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("image2ascii/i2a_jave.gif");
    }

    public final int getVerticalPixelsPerChar() {
        return 8;
    }

    public final int getHorizontalPixelsPerChar() {
        return 2;
    }

    public final boolean isMonochromeImageRequired() {
        return false;
    }

    public final void setSpecialChars(String specialCharacters) {
        this.optionsModel.getBannedCharactersModel().setBannedCharacters(specialCharacters);
    }

    public final void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
        this.optionsModel.getGreyScaleTableSelectionModel().setAutomaticFromFont(false);
        this.optionsModel.getGreyScaleTableSelectionModel().setGreyScaleTable(greyscaleTable);
    }

    private String getBannedCharacters() {
        return this.optionsModel.getBannedCharactersModel().getBannedCharacters();
    }

    public final CharacterPlate convert(IValueRaster pixels, IProgressMonitor progressMonitor) throws InterruptedException {
        int x;
        AsciiGreyscaleTable table = this.optionsModel.getGreyScaleTableSelectionModel().getActualGreyscaleTable(this.optionsModel.getDisplayFontModel());
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        CharacterPlate result = null;
        String notUse = this.getBannedCharacters();
        table.setDoNotUse4(notUse);
        progressMonitor.beginTask("Converting...", height /= 8);
        result = new CharacterPlate(width /= 2, height);
        GGreyscaleImage g1 = new GGreyscaleImage(width, height);
        for (int y = 0; y < height; ++y) {
            Thread.yield();
            ProgressUtilities.checkInterrupted(progressMonitor);
            int y0 = y * 8;
            for (x = 0; x < width; ++x) {
                int x0 = x * 2;
                int NW = (0 * pixels.getValueAt(x0, y0) + 1 * pixels.getValueAt(x0, y0 + 1) + 1 * pixels.getValueAt(x0, y0 + 2) + 1 * pixels.getValueAt(x0, y0 + 3)) / 3;
                int SW = (1 * pixels.getValueAt(x0, y0 + 4) + 1 * pixels.getValueAt(x0, y0 + 5) + 1 * pixels.getValueAt(x0, y0 + 6) + 0 * pixels.getValueAt(x0, y0 + 7)) / 3;
                int NE = (0 * pixels.getValueAt(x0 + 1, y0) + 1 * pixels.getValueAt(x0 + 1, y0 + 1) + 1 * pixels.getValueAt(x0 + 1, y0 + 2) + 1 * pixels.getValueAt(x0 + 1, y0 + 3)) / 3;
                int SE = (1 * pixels.getValueAt(x0 + 1, y0 + 4) + 1 * pixels.getValueAt(x0 + 1, y0 + 5) + 1 * pixels.getValueAt(x0 + 1, y0 + 6) + 0 * pixels.getValueAt(x0 + 1, y0 + 7)) / 3;
                int avg = (NW + NE + SW + SE) / 4;
                g1.set(x, y, avg);
                boolean d = false;
                if (NW <= 5 + avg && NW >= avg - 5 && NE <= 5 + avg && NE >= avg - 5 && SW <= 5 + avg && SW >= avg - 5 && SE <= 5 + avg && SE >= avg - 5) {
                    result.setForce(x, y, '\u0000');
                    continue;
                }
                result.setForce(x, y, table.getCharForBrightness(NW, NE, SW, SE));
            }
            progressMonitor.worked(1);
        }
        CharacterPlate p1 = Image2AsciiAlgorithm1.convert(g1, table, true, notUse, NullProgressMonitor.getInstance());
        if (p1 == null) {
            return null;
        }
        for (int y = 0; y < height; ++y) {
            Thread.yield();
            ProgressUtilities.checkInterrupted(progressMonitor);
            for (x = 0; x < width; ++x) {
                if (result.get(x, y) != '\u0000') continue;
                result.setForce(x, y, p1.get(x, y));
            }
        }
        return result;
    }
}

