/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.braille.BrailleDisplay;
import de.jave.braille.table.BrailleTables;
import de.jave.braille.table.IBrailleTable;
import de.jave.image.IValueRaster;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.algorithm.AlgorithmBrailleOptionsModel;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorrithmBrailleOptionsPanel;
import de.jave.lib.CharacterPlate;
import java.awt.BorderLayout;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public final class Image2AsciiAlgorithmBraille
extends Image2AsciiAlgorithm {
    private final AlgorithmBrailleOptionsModel optionsModel = new AlgorithmBrailleOptionsModel();
    private BrailleDisplay brailleDisplay;

    public final IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    public final Icon getIcon() {
        return null;
    }

    public final void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
    }

    public final void setSpecialChars(String specialCharacters) {
    }

    public final void setBrailleDisplay(BrailleDisplay brailleDisplay) {
        this.brailleDisplay = brailleDisplay;
    }

    public final IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorrithmBrailleOptionsPanel(this.optionsModel);
    }

    public final String getName() {
        return "Braille";
    }

    public final int getVerticalPixelsPerChar() {
        return 4;
    }

    public final int getHorizontalPixelsPerChar() {
        return 2;
    }

    public final boolean isMonochromeImageRequired() {
        return true;
    }

    public final CharacterPlate convert(IValueRaster pixels, IProgressMonitor progressMonitor) throws InterruptedException {
        IBrailleTable mode = BrailleTables.getByName(this.optionsModel.getBrailleTableName());
        int width = pixels.getWidth() / 2;
        int height = pixels.getHeight() / 4;
        progressMonitor.beginTask("Converting...", height);
        CharacterPlate result = new CharacterPlate(width, height);
        for (int y = 0; y < height; ++y) {
            Thread.yield();
            for (int x = 0; x < width; ++x) {
                Thread.yield();
                ProgressUtilities.checkInterrupted(progressMonitor);
                int d1 = 1 - pixels.getValueAt(x * 2, y * 4);
                int d2 = 1 - pixels.getValueAt(x * 2, y * 4 + 1);
                int d3 = 1 - pixels.getValueAt(x * 2, y * 4 + 2);
                int d4 = 1 - pixels.getValueAt(x * 2 + 1, y * 4);
                int d5 = 1 - pixels.getValueAt(x * 2 + 1, y * 4 + 1);
                int d6 = 1 - pixels.getValueAt(x * 2 + 1, y * 4 + 2);
                int d7 = 1 - pixels.getValueAt(x * 2, y * 4 + 3);
                int d8 = 1 - pixels.getValueAt(x * 2 + 1, y * 4 + 3);
                int key = d1 + 2 * d2 + 4 * d3 + 8 * d4 + 16 * d5 + 32 * d6 + 64 * d7 + 128 * d8;
                char value = mode.getCharacterForBraillePattern(key);
                while (Image2AsciiAlgorithmBraille.isNotDisplayable(value)) {
                    if (d8 == 1) {
                        d8 = 0;
                        key -= 128;
                    } else if (d7 == 1) {
                        d7 = 0;
                        key -= 64;
                    } else if (d6 == 1) {
                        d6 = 0;
                        key -= 32;
                    } else if (d5 == 1) {
                        d5 = 0;
                        key -= 16;
                    } else if (d4 == 1) {
                        d4 = 0;
                        key -= 8;
                    } else if (d3 == 1) {
                        d3 = 0;
                        key -= 4;
                    } else if (d2 == 1) {
                        d2 = 0;
                        key -= 2;
                    } else if (d1 == 1) {
                        d1 = 0;
                        --key;
                    } else {
                        throw new RuntimeException("Fatal Error!");
                    }
                    value = mode.getCharacterForBraillePattern(key);
                }
                result.setForce(x, y, value);
            }
            progressMonitor.worked(1);
        }
        ProgressUtilities.checkInterrupted(progressMonitor);
        String text = result.toString();
        if (this.brailleDisplay == null) {
            this.brailleDisplay = new BrailleDisplay(text);
            JFrame f = new JFrame("Braille Display");
            f.getContentPane().setLayout(new BorderLayout());
            JScrollPane scrolly = new JScrollPane(this.brailleDisplay);
            f.getContentPane().add(scrolly);
            f.pack();
            f.setVisible(true);
        } else {
            this.brailleDisplay.setText(text);
        }
        this.brailleDisplay.setMode(mode);
        return result;
    }

    public static final boolean isNotDisplayable(char ch) {
        return ch < ' ' || ch == '\u007f' || ch == '\u0080' || ch >= '\u0082' && ch <= '\u008c' || ch == '\u008e' || ch >= '\u0091' && ch <= '\u009c' || ch == '\u009e' || ch == '\u0095';
    }
}

