/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.SharedImage2AsciiOptions;
import de.jave.image2ascii.algorithm.Algorithm4OptionsModel;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithm4OptionsPanel;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.lib.CharacterPlate;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public final class Image2AsciiAlgorithm4
extends Image2AsciiAlgorithm {
    private final Algorithm4OptionsModel optionsModel;

    public Image2AsciiAlgorithm4(SharedImage2AsciiOptions sharedOptions) {
        this.optionsModel = new Algorithm4OptionsModel(sharedOptions);
    }

    public final IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    public final IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorithm4OptionsPanel(this.optionsModel);
    }

    public final String getName() {
        return "4 Pixels per Character";
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("image2ascii/i2a_4.gif");
    }

    public final void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
        this.optionsModel.getGreyScaleTableSelectionModel().setAutomaticFromFont(false);
        this.optionsModel.getGreyScaleTableSelectionModel().setGreyScaleTable(greyscaleTable);
    }

    public final void setSpecialChars(String specialCharacters) {
        this.optionsModel.getBannedCharactersModel().setBannedCharacters(specialCharacters);
    }

    public final int getVerticalPixelsPerChar() {
        if (this.isOptimized()) {
            return 8;
        }
        return 2;
    }

    public final int getHorizontalPixelsPerChar() {
        return 2;
    }

    public final boolean isMonochromeImageRequired() {
        return false;
    }

    protected final boolean isOptimized() {
        return this.optionsModel.isOptimize();
    }

    private String getBannedCharacters() {
        return this.optionsModel.getBannedCharactersModel().getBannedCharacters();
    }

    public final CharacterPlate convert(IValueRaster pixels, IProgressMonitor progressMonitor) throws InterruptedException {
        AsciiGreyscaleTable table = this.optionsModel.getGreyScaleTableSelectionModel().getActualGreyscaleTable(this.optionsModel.getDisplayFontModel());
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        CharacterPlate result = null;
        String bannedCharacters = this.getBannedCharacters();
        table.setDoNotUse4(bannedCharacters);
        if (this.isOptimized()) {
            progressMonitor.beginTask("Converting...", height /= 8);
            result = new CharacterPlate(width /= 2, height);
            for (int y = 0; y < height; ++y) {
                Thread.yield();
                ProgressUtilities.checkInterrupted(progressMonitor);
                int y0 = y * 8;
                for (int x = 0; x < width; ++x) {
                    int x0 = x * 2;
                    int NW = (0 * pixels.getValueAt(x0, y0) + 1 * pixels.getValueAt(x0, y0 + 1) + 1 * pixels.getValueAt(x0, y0 + 2) + 1 * pixels.getValueAt(x0, y0 + 3)) / 3;
                    int SW = (1 * pixels.getValueAt(x0, y0 + 4) + 1 * pixels.getValueAt(x0, y0 + 5) + 1 * pixels.getValueAt(x0, y0 + 6) + 0 * pixels.getValueAt(x0, y0 + 7)) / 3;
                    int NE = (0 * pixels.getValueAt(x0 + 1, y0) + 1 * pixels.getValueAt(x0 + 1, y0 + 1) + 1 * pixels.getValueAt(x0 + 1, y0 + 2) + 1 * pixels.getValueAt(x0 + 1, y0 + 3)) / 3;
                    int SE = (1 * pixels.getValueAt(x0 + 1, y0 + 4) + 1 * pixels.getValueAt(x0 + 1, y0 + 5) + 1 * pixels.getValueAt(x0 + 1, y0 + 6) + 0 * pixels.getValueAt(x0 + 1, y0 + 7)) / 3;
                    result.setForce(x, y, table.getCharForBrightness(NW, NE, SW, SE));
                }
                progressMonitor.worked(1);
            }
        } else {
            progressMonitor.beginTask("Converting...", height /= 2);
            result = new CharacterPlate(width /= 2, height);
            for (int y = 0; y < height; ++y) {
                Thread.yield();
                ProgressUtilities.checkInterrupted(progressMonitor);
                for (int x = 0; x < width; ++x) {
                    result.setForce(x, y, table.getCharForBrightness(pixels.getValueAt(x * 2, y * 2), pixels.getValueAt(x * 2 + 1, y * 2), pixels.getValueAt(x * 2, y * 2 + 1), pixels.getValueAt(x * 2 + 1, y * 2 + 1)));
                }
                progressMonitor.worked(1);
            }
        }
        return result;
    }
}

