/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

public final class HistogrammRun {
    private int[] histogramm;
    private int size;
    private int start;
    private int end;

    public HistogrammRun(int[] histogramm, int start, int end) {
        this.histogramm = histogramm;
        this.start = start;
        this.end = end;
        for (int i = start; i <= end; ++i) {
            this.size += histogramm[i];
        }
    }

    public final boolean isSplitable() {
        return this.end > this.start + 1;
    }

    public final HistogrammRun split() {
        int index = this.start;
        for (int sum = 0; sum < this.size / 2 && index < this.end - 1; sum += this.histogramm[index], ++index) {
        }
        HistogrammRun h = new HistogrammRun(this.histogramm, index, this.end);
        this.end = index - 1;
        this.size = 0;
        for (int i = this.start; i <= this.end; ++i) {
            this.size += this.histogramm[i];
        }
        return h;
    }

    public final int getSize() {
        return this.size;
    }

    public final String toString() {
        return "[" + this.start + ".." + this.end + ";" + this.size + "]";
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }
}

