/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.asciimation.export.AnimationExportOptions;
import de.jave.asciimation.export.AnimationExportWizard;
import de.jave.asciimation.export.IAnimationExporter;
import de.jave.braille.BrailleDisplay;
import de.jave.gui.GSliderArrangement;
import de.jave.gui.GTextArea;
import de.jave.image.GImage;
import de.jave.image.Rotation;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.algorithm.dithering.DitheringAlgorithms;
import de.jave.image.greyscale.algorithm.dithering.IGreyscaleDithering;
import de.jave.image.gui.ImagePanel;
import de.jave.image2ascii.BatchConversionThread;
import de.jave.image2ascii.ConversionThread;
import de.jave.image2ascii.DitheringListCellRenderer;
import de.jave.image2ascii.IImage2AsciiAlgorithm;
import de.jave.image2ascii.IImage2AsciiAlgorithmItem;
import de.jave.image2ascii.Image2AsciiAlgorithmFactory;
import de.jave.image2ascii.Image2AsciiAlgorithmItemUi;
import de.jave.image2ascii.ProxyProgressMonitor;
import de.jave.image2ascii.RotationUi;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithmBraille;
import de.jave.image2ascii.dialog.BatchConversionSourceFilePage;
import de.jave.image2ascii.dialog.Image2AsciiOutputOptionsPanel;
import de.jave.image2ascii.dialog.Image2AsciiSourceImagePanel;
import de.jave.image2ascii.model.Image2AsciiOptionsModel;
import de.jave.image2ascii.model.Image2AsciiSourceImageModel;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.lib.CharacterPlate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.cardlayout.CardPanel;
import net.disy.commons.swing.cardlayout.CardPanelKey;
import net.disy.commons.swing.component.IDisposableComponentContainer;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.dialog.progress.ProgressMonitorBar;
import net.disy.commons.swing.dialog.progress.ProgressMonitorDialog;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.layout.grid.GridAlignment;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogPanel;
import net.disy.commons.swing.layout.grid.IDialogComponent;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;
import net.disy.commons.swing.widgets.HorizontalLine;

public final class Image2Texter
implements AdjustmentListener,
TextListener {
    private static final CardPanelKey CARD_PANEL_KEY_BRAILLE = new CardPanelKey("braille");
    private static final CardPanelKey CARD_PANEL_KEY_TEXT = new CardPanelKey("text");
    final ChangeListener algorithmOptionsChangeListener = new ChangeListener(){

        public final void stateChanged(ChangeEvent e) {
            Image2Texter.this.convert2Text();
        }
    };
    private IImage2AsciiAlgorithm currentAlgorithm;
    private IDisposableComponentContainer currentAdjustmentComponent;
    private JPanel algorithmOptionsPanel;
    private JPanel panelOutput;
    private final ProgressMonitorBar progressBar = new ProgressMonitorBar();
    private JComboBox chAlgorithm;
    private JComboBox chRotate;
    private JComboBox chDithering;
    private GTextArea taOutput;
    private final BrailleDisplay brailleDisplay = new BrailleDisplay(" ");
    private ImagePanel cPreviewImage;
    private GSliderArrangement slaSharpen;
    private GSliderArrangement slaShadow;
    private GSliderArrangement slaHighlight;
    private GSliderArrangement slaGamma;
    private JCheckBox cbNegative;
    private JCheckBox cbNormalize;
    private JComponent content;
    private final Image2AsciiSourceImageModel sourceImageModel;
    private final Image2AsciiOptionsModel optionsModel = new Image2AsciiOptionsModel();
    private final AnimationExportPreferences animationExportPreferences;
    private CardPanel outputPanel;
    private final FontModel displayFontModel;
    private final JTabbedPane tabbedPane;
    private CharacterPlate resultPlate;
    private ProxyProgressMonitor currentProgressMonitor;

    public Image2Texter(FileModel currentDirectoryModel, final FontModel displayFontModel, AnimationExportPreferences animationExportPreferences) {
        Ensure.ensureArgumentNotNull(currentDirectoryModel);
        Ensure.ensureArgumentNotNull(displayFontModel);
        Ensure.ensureArgumentNotNull(animationExportPreferences);
        this.animationExportPreferences = animationExportPreferences;
        this.displayFontModel = displayFontModel;
        this.sourceImageModel = new Image2AsciiSourceImageModel(currentDirectoryModel);
        this.sourceImageModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                Image2Texter.this.handleChanged();
                Image2Texter.this.content.validate();
            }
        });
        this.optionsModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                Image2Texter.this.convert2Text();
                Image2Texter.this.content.validate();
            }
        });
        this.taOutput = new GTextArea(15, 80);
        this.taOutput.setEditable(false);
        this.taOutput.setBackground(Color.white);
        this.taOutput.setForeground(Color.black);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("Source image", Image2Texter.addEmptyBorder(this.createSourceImagePanel()));
        this.tabbedPane.add("Image processing", Image2Texter.addEmptyBorder(this.createImageProcessingOptionsPanel()));
        this.tabbedPane.add("Conversion", Image2Texter.addEmptyBorder(this.createPanel3()));
        this.tabbedPane.add("Output", Image2Texter.addEmptyBorder(this.createOutputOptionsPanel()));
        this.sourceImageModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                Image2Texter.this.updateTabbedPaneEnabled();
            }
        });
        this.updateTabbedPaneEnabled();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.tabbedPane, "North");
        mainPanel.add((Component)this.createOutputPanel(), "Center");
        mainPanel.add((Component)this.progressBar, "South");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)mainPanel, "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        this.chDithering.setEnabled(this.getSelectedAlgorithmItem().getAlgorithm().isMonochromeImageRequired());
        this.content = panel;
        this.taOutput.setFont(displayFontModel.getFont());
        displayFontModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                Image2Texter.this.taOutput.setFont(displayFontModel.getFont());
            }
        });
    }

    private IImage2AsciiAlgorithmItem getSelectedAlgorithmItem() {
        return (IImage2AsciiAlgorithmItem)this.chAlgorithm.getSelectedItem();
    }

    private void updateTabbedPaneEnabled() {
        boolean enabled = !this.sourceImageModel.isEmpty();
        for (int i = 1; i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setEnabledAt(i, enabled);
        }
    }

    private void convertPreview() {
        if (this.sourceImageModel.isEmpty()) {
            return;
        }
        boolean invert = this.cbNegative.isSelected();
        boolean normalize = this.cbNormalize.isSelected();
        int highlight = this.slaHighlight.getValue();
        int shadow = this.slaShadow.getValue();
        double gamma = this.slaGamma.getDValue();
        double sharpen = this.slaSharpen.getDValue();
        int ditherMethode = -1;
        if (this.chDithering.isEnabled()) {
            ditherMethode = this.chDithering.getSelectedIndex();
        }
        Rotation rotate = (Rotation)this.chRotate.getSelectedItem();
        GGreyscaleImage gi = this.sourceImageModel.getSourceImage().getRawPreviewImage().convert(normalize, invert, gamma, highlight, shadow);
        if (sharpen > 0.0) {
            gi = gi.sharpen(sharpen);
        }
        GImage g2 = gi;
        if (ditherMethode != -1) {
            g2 = new DitheringAlgorithms().dither(gi, ditherMethode);
        }
        g2 = g2.rotate(rotate);
        this.cPreviewImage.setImage(g2);
    }

    private JComponent createSourceImagePanel() {
        return new Image2AsciiSourceImagePanel(this.sourceImageModel).getContent();
    }

    private JPanel createImageProcessingOptionsPanel() {
        JPanel p = new JPanel(new GridDialogLayout(2, false));
        GridDialogLayoutData top = new GridDialogLayoutData();
        top.setVerticalAlignment(GridAlignment.BEGINNING);
        p.add((Component)this.createPanel2a(), top);
        p.add((Component)this.createPanel2b(), GridDialogLayoutData.FILL_BOTH);
        return p;
    }

    private JComponent createOutputOptionsPanel() {
        return new Image2AsciiOutputOptionsPanel(this.optionsModel.getOutputOptionsModel()).getContent();
    }

    private JPanel createPanel3() {
        IImage2AsciiAlgorithmItem[] algorithms = Image2AsciiAlgorithmFactory.createAlgorithmItems(this.displayFontModel);
        this.chAlgorithm = new JComboBox<IImage2AsciiAlgorithmItem>(algorithms);
        this.chAlgorithm.setRenderer(new ObjectUiListCellRenderer(new Image2AsciiAlgorithmItemUi()));
        this.currentAlgorithm = algorithms[0].getAlgorithm();
        this.currentAlgorithm.getOptionsModel().addChangeListener(this.algorithmOptionsChangeListener);
        this.chAlgorithm.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Image2Texter.this.handleAlgorithmChanged();
            }
        });
        this.algorithmOptionsPanel = new JPanel(new GridDialogLayout(1, false));
        this.algorithmOptionsPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.currentAdjustmentComponent = algorithms[0].createAdjustmentComponent();
        this.algorithmOptionsPanel.add(this.currentAdjustmentComponent.getContent());
        JPanel algorithmPanel = new JPanel(new GridDialogLayout(2, false));
        algorithmPanel.add(new JLabel("Algorithm:"));
        algorithmPanel.add(this.chAlgorithm);
        GridDialogLayoutData gridDialogLayoutData = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        gridDialogLayoutData.setHorizontalSpan(2);
        algorithmPanel.add((Component)new HorizontalLine(), gridDialogLayoutData);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)algorithmPanel, "North");
        panel.add((Component)this.algorithmOptionsPanel, "Center");
        return panel;
    }

    private static JComponent addEmptyBorder(JComponent panelContent) {
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.add(panelContent);
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        return panel;
    }

    private JPanel createButtonPanel() {
        final SmartAction batchConversionAction = new SmartAction("Batch Conversion"){

            protected final void execute(Component parentComponent) {
                Image2Texter.this.performBatchConvert(parentComponent);
            }
        };
        SmartAction defaultsAction = new SmartAction("Default Values"){

            protected final void execute(Component parentComponent) {
                Image2Texter.this.setDefaults();
            }
        };
        this.sourceImageModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                batchConversionAction.setEnabled(!Image2Texter.this.sourceImageModel.isEmpty());
            }
        });
        batchConversionAction.setEnabled(false);
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        buttonPanelBuilder.add(defaultsAction);
        buttonPanelBuilder.add(batchConversionAction);
        return buttonPanelBuilder.createPanel();
    }

    private JPanel createOutputPanel() {
        this.panelOutput = new JPanel(new BorderLayout());
        this.panelOutput.add((Component)new JLabel("Result:"), "North");
        this.outputPanel = new CardPanel();
        this.outputPanel.add(this.taOutput.getContent(), CARD_PANEL_KEY_TEXT);
        this.outputPanel.add(this.brailleDisplay.getContent(), CARD_PANEL_KEY_BRAILLE);
        this.outputPanel.setSelectedSubPanel(CARD_PANEL_KEY_TEXT);
        this.panelOutput.add((Component)this.outputPanel.getContent(), "Center");
        return this.panelOutput;
    }

    private JComponent createPanel2a() {
        ChangeListener changeListener = new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                Image2Texter.this.handleChanged();
            }
        };
        GridDialogPanel panel = new GridDialogPanel();
        this.slaHighlight = new GSliderArrangement("Highlight:", 0, 100, 100, 1, 1);
        this.slaHighlight.getModel().addChangeListener(changeListener);
        panel.add(this.slaHighlight);
        this.slaShadow = new GSliderArrangement("Shadow:", 0, 100, 0, 1, 1);
        this.slaShadow.getModel().addChangeListener(changeListener);
        panel.add(this.slaShadow);
        this.slaGamma = new GSliderArrangement("Gamma:", 1, 500, 100, 1, 100);
        this.slaGamma.getModel().addChangeListener(changeListener);
        panel.add(this.slaGamma);
        this.slaSharpen = new GSliderArrangement("Sharpen:", 0, 100, 0, 1, 100);
        this.slaSharpen.getModel().addChangeListener(changeListener);
        panel.add(this.slaSharpen);
        this.chRotate = new JComboBox<Rotation>(Rotation.getAll());
        this.chRotate.setRenderer(new ObjectUiListCellRenderer(new RotationUi()));
        this.chRotate.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Image2Texter.this.handleChanged();
            }
        });
        panel.add(new IDialogComponent(){

            public final int getColumnCount() {
                return 2;
            }

            public final void fillInto(JPanel container, int columnCount) {
                container.add((Component)new JLabel("Rotate:"), GridDialogLayoutData.RIGHT);
                GridDialogLayoutData data = new GridDialogLayoutData();
                data.setHorizontalSpan(columnCount - 1);
                container.add((Component)Image2Texter.this.chRotate, data);
            }
        });
        return panel.getContent();
    }

    private JPanel createPanel2b() {
        this.cPreviewImage = new ImagePanel();
        IGreyscaleDithering[] ditheringAlgorithms = DitheringAlgorithms.getAllGreyscaleDitheringAlgorithms();
        this.chDithering = new JComboBox<IGreyscaleDithering>(ditheringAlgorithms);
        this.chDithering.setRenderer(new DitheringListCellRenderer());
        this.chDithering.setSelectedItem(ditheringAlgorithms[0]);
        this.chDithering.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Image2Texter.this.handleChanged();
            }
        });
        JPanel p3 = new JPanel(new BorderLayout());
        p3.add((Component)new JLabel("Dithering:"), "West");
        p3.add((Component)this.chDithering, "Center");
        this.cbNegative = new JCheckBox("Negative Image", false);
        this.cbNegative.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Image2Texter.this.handleChanged();
            }
        });
        this.cbNormalize = new JCheckBox("Normalize Histogram", true);
        this.cbNormalize.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Image2Texter.this.handleChanged();
            }
        });
        JPanel panel = new JPanel(new GridDialogLayout(1, false));
        panel.add((Component)this.cPreviewImage.getContent(), GridDialogLayoutData.FILL_BOTH);
        panel.add(p3);
        panel.add(this.cbNegative);
        panel.add(this.cbNormalize);
        return panel;
    }

    public final void textValueChanged(TextEvent evt) {
        this.convert2Text();
    }

    public final CharacterPlate getResult() {
        return this.resultPlate;
    }

    public final void setResult(CharacterPlate cp) {
        this.resultPlate = cp;
        if (cp != null) {
            this.taOutput.setText(cp.toString());
            return;
        }
        this.taOutput.setText("");
    }

    private void convert2Text() {
        if (this.sourceImageModel.isEmpty()) {
            return;
        }
        double shapeFactor = this.optionsModel.getOutputOptionsModel().getShapeFactor();
        boolean normalize = this.cbNormalize.isSelected();
        boolean invert = this.cbNegative.isSelected();
        int highlight = this.slaHighlight.getValue();
        int shadow = this.slaShadow.getValue();
        double gamma = this.slaGamma.getDValue();
        double sharpen = this.slaSharpen.getDValue();
        int newWidth = this.optionsModel.getOutputOptionsModel().getOutputWidth();
        int ditherMethode = -1;
        if (this.chDithering.isEnabled()) {
            ditherMethode = this.chDithering.getSelectedIndex();
        }
        Rotation rotate = (Rotation)this.chRotate.getSelectedItem();
        if (this.currentProgressMonitor != null) {
            this.currentProgressMonitor.setCanceled(true);
        }
        this.currentProgressMonitor = new ProxyProgressMonitor(this.progressBar);
        ConversionThread conversionThread = new ConversionThread(this.currentProgressMonitor, this.sourceImageModel.getSourceImage().getRawConversionImage(), newWidth, shapeFactor, normalize, invert, highlight, shadow, gamma, sharpen, ditherMethode, rotate, this.getSelectedAlgorithmItem().getAlgorithm(), this);
        conversionThread.start();
    }

    private void performBatchConvert(Component parentComponent) {
        BatchConversionSourceFilePage sourceFilePage = new BatchConversionSourceFilePage(this.sourceImageModel.getCurrentDirectoryModel());
        AnimationExportOptions options = AnimationExportWizard.showOptionsDialogs(parentComponent, this.sourceImageModel.getCurrentDirectoryModel(), "Batch Conversion", sourceFilePage, this.displayFontModel.getFont(), this.animationExportPreferences);
        if (options == null) {
            return;
        }
        IAnimationExporter exporter = options.getFormat().createExporter(options);
        File[] sourceFiles = sourceFilePage.getSourceFiles();
        double shapeFactor = this.optionsModel.getOutputOptionsModel().getShapeFactor();
        boolean normalize = this.cbNormalize.isSelected();
        boolean invert = this.cbNegative.isSelected();
        int highlight = this.slaHighlight.getValue();
        int shadow = this.slaShadow.getValue();
        double gamma = this.slaGamma.getDValue();
        double sharpen = this.slaSharpen.getDValue();
        int newWidth = this.optionsModel.getOutputOptionsModel().getOutputWidth();
        int ditherMethode = -1;
        if (this.chDithering.isEnabled()) {
            ditherMethode = this.chDithering.getSelectedIndex();
        }
        Rotation rotate = (Rotation)this.chRotate.getSelectedItem();
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(parentComponent, "Batch Conversion");
        BatchConversionThread batchConversionThread = new BatchConversionThread(sourceFiles, newWidth, shapeFactor, normalize, invert, highlight, shadow, gamma, sharpen, ditherMethode, rotate, this.getSelectedAlgorithmItem().getAlgorithm(), exporter);
        try {
            progressDialog.run(true, batchConversionThread);
            String message = "Successfuly converted " + sourceFiles.length + " images.";
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("Image2Ascii - Batch Conversion", message, MessageType.INFORMATION));
            return;
        }
        catch (InterruptedException interruptedException) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("Batch conversion has been canceled.", MessageType.INFORMATION));
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException e = invocationTargetException;
            invocationTargetException.printStackTrace();
            MessageDialogFactory.showMessageDialog(parentComponent, new Message(e.getCause().getMessage(), e.getCause()));
            return;
        }
    }

    private void setDefaults() {
        this.slaGamma.setDefault();
        this.slaHighlight.setDefault();
        this.slaShadow.setDefault();
        this.optionsModel.reset();
        this.slaSharpen.setDefault();
    }

    private void handleAlgorithmChanged() {
        IImage2AsciiAlgorithmItem selectedAlgorithmItem = this.getSelectedAlgorithmItem();
        if (this.currentAlgorithm != null) {
            this.currentAlgorithm.getOptionsModel().removeChangeListener(this.algorithmOptionsChangeListener);
            this.currentAdjustmentComponent.dispose();
        }
        this.currentAlgorithm = selectedAlgorithmItem.getAlgorithm();
        this.currentAlgorithm.getOptionsModel().addChangeListener(this.algorithmOptionsChangeListener);
        this.algorithmOptionsPanel.removeAll();
        this.currentAdjustmentComponent = selectedAlgorithmItem.createAdjustmentComponent();
        this.algorithmOptionsPanel.add(this.currentAdjustmentComponent.getContent());
        this.algorithmOptionsPanel.revalidate();
        this.algorithmOptionsPanel.repaint();
        if (this.currentAlgorithm instanceof Image2AsciiAlgorithmBraille) {
            ((Image2AsciiAlgorithmBraille)this.currentAlgorithm).setBrailleDisplay(this.brailleDisplay);
            this.outputPanel.setSelectedSubPanel(CARD_PANEL_KEY_BRAILLE);
        } else {
            this.outputPanel.setSelectedSubPanel(CARD_PANEL_KEY_TEXT);
        }
        this.chDithering.setEnabled(this.currentAlgorithm.isMonochromeImageRequired());
        this.handleChanged();
    }

    public final void adjustmentValueChanged(AdjustmentEvent evt) {
        this.handleChanged();
    }

    private void handleChanged() {
        this.convertPreview();
        this.convert2Text();
    }

    public final Component getContent() {
        return this.content;
    }

    public final Image2AsciiSourceImageModel getSourceImageModel() {
        return this.sourceImageModel;
    }
}

