/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image.GImage;
import de.jave.image.ImageLoader;
import de.jave.image.Rotation;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.GreyscaleImageFactory;
import de.jave.image.greyscale.algorithm.dithering.DitheringAlgorithms;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.lib.CharacterPlate;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.progress.NullProgressMonitor;

public final class Converter {
    public static final CharacterPlate convert(File imageFile, Rotation rotate, double shapeFactor, int resultWidth, Image2AsciiAlgorithm algorithm, boolean normalize, boolean invert, double gamma, double highlight, double shadow, double sharpen, int ditherMethode) {
        double dimFactor;
        int newWidth;
        int newHeight;
        BufferedImage image;
        try {
            image = ImageLoader.loadImage(imageFile);
        }
        catch (IOException e) {
            System.err.println("Error loading image '" + imageFile.getAbsolutePath() + "'.");
            e.printStackTrace();
            return null;
        }
        int oldWidth = image.getWidth();
        int oldHeight = image.getHeight();
        int[] pixels2 = new int[oldWidth * oldHeight];
        PixelGrabber pg2 = new PixelGrabber(image, 0, 0, oldWidth, oldHeight, pixels2, 0, oldWidth);
        try {
            pg2.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            InterruptedException e = interruptedException;
            interruptedException.printStackTrace();
            System.err.println("Internal Error: " + e.toString());
            return null;
        }
        if ((pg2.getStatus() & 0x80) != 0) {
            System.err.println("Internal Error: image fetch aborted or errored");
            return null;
        }
        GGreyscaleImage image2 = new GreyscaleImageFactory().createGreyscaleImage(pixels2, oldWidth, oldHeight);
        if (rotate != Rotation.NONE) {
            image2 = (GGreyscaleImage)image2.rotate(rotate);
        }
        if ((newHeight = (int)((double)(newWidth = resultWidth) / (double)(oldWidth = image2.getWidth()) * (double)(oldHeight = image2.getHeight()) * (dimFactor = 0.52 * shapeFactor))) < 1) {
            newHeight = 1;
        }
        if (newWidth < 1) {
            newWidth = 1;
        }
        image2 = image2.getScaledInstance(newWidth *= algorithm.getHorizontalPixelsPerChar(), newHeight *= algorithm.getVerticalPixelsPerChar());
        image2 = image2.convert(normalize, invert, gamma, highlight, shadow);
        if (sharpen > 0.0) {
            image2 = image2.sharpen(sharpen);
        }
        GImage gi = image2;
        if (ditherMethode != -1) {
            gi = new DitheringAlgorithms().dither(image2, ditherMethode);
        }
        try {
            return algorithm.convert(gi, NullProgressMonitor.getInstance());
        }
        catch (InterruptedException e) {
            throw new UnreachableCodeReachedException(e);
        }
    }
}

