/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import net.disy.commons.core.util.Ensure;

public final class AsciiGreyscaleTable {
    private final char[] greyscales;
    private final char[][] greyscales4;
    private final boolean[] defaultIgnores;
    private final boolean[] defaultIgnores4;
    private final boolean[] ignores;
    private final boolean[] ignores4;
    private char[] characters;
    private final char[][] characters4;

    public AsciiGreyscaleTable(boolean[] defaultIgnores, boolean[] defaultIgnores4, char[] greyscales, char[][] greyscales4, char[][] characters4) {
        Ensure.ensureArgumentTrue("Expected 95 greyscales, but was " + greyscales.length, greyscales.length == 95);
        Ensure.ensureArgumentTrue("Expected 95 greyscales4, but was " + greyscales4.length, greyscales4.length == 95);
        Ensure.ensureArgumentTrue("Expected at most 95 characters4, but was " + characters4.length, characters4.length <= 95);
        this.defaultIgnores = defaultIgnores;
        this.defaultIgnores4 = defaultIgnores4;
        this.greyscales = greyscales;
        this.greyscales4 = greyscales4;
        this.characters4 = characters4;
        this.ignores = new boolean[96];
        this.ignores4 = new boolean[96];
        System.arraycopy(defaultIgnores, 0, this.ignores, 0, 95);
        System.arraycopy(defaultIgnores4, 0, this.ignores4, 0, 95);
        this.buildCharactersForBrightness();
    }

    private void buildCharactersForBrightness() {
        this.characters = new char[256];
        for (int i = 0; i < 95; ++i) {
            if (this.ignores[i]) continue;
            this.characters[this.greyscales[i]] = (char)(32 + i);
        }
        if (this.characters[255] == '\u0000' || this.characters[0] == '\u0000') {
            int darkestCharIndex = 0;
            int brightestCharIndex = 0;
            for (int i = 0; i < 95; ++i) {
                if (this.ignores[i]) continue;
                if (this.greyscales[i] < this.greyscales[darkestCharIndex]) {
                    darkestCharIndex = i;
                }
                if (this.greyscales[i] <= this.greyscales[brightestCharIndex]) continue;
                brightestCharIndex = i;
            }
            this.characters[255] = (char)(brightestCharIndex + 32);
            this.characters[0] = (char)(darkestCharIndex + 32);
        }
        int nextCharIndex = 0;
        for (int index = 0; index < 255; ++index) {
            int dUpper;
            int dLower;
            if (this.characters[index] != '\u0000') continue;
            if (nextCharIndex <= index) {
                nextCharIndex = index + 1;
                while (this.characters[nextCharIndex] == '\u0000') {
                    ++nextCharIndex;
                }
            }
            this.characters[index] = (dLower = index - this.greyscales[this.characters[index - 1] - 32]) < (dUpper = this.greyscales[this.characters[nextCharIndex] - 32] - index) ? this.characters[index - 1] : this.characters[nextCharIndex];
        }
    }

    public final char getCharForBrightness(int i) {
        if (i > 255) {
            return this.characters[255];
        }
        if (i < 0) {
            return this.characters[0];
        }
        return this.characters[i];
    }

    public final int getBrightnessForChar(char ch) {
        if (ch < ' ') {
            return this.greyscales[0];
        }
        if (ch > '~') {
            return this.greyscales[94];
        }
        return this.greyscales[ch - 32];
    }

    public final char[] getBrightness4ForChar(char ch) {
        int index = ch - 32;
        if (ch < ' ') {
            index = 0;
        }
        if (ch > '~') {
            index = 94;
        }
        return new char[]{this.greyscales4[index][0], this.greyscales4[index][1], this.greyscales4[index][2], this.greyscales4[index][3]};
    }

    public final char getCharForBrightness(char[] brightness) {
        return this.getCharForBrightness(brightness[0], brightness[1], brightness[2], brightness[3]);
    }

    public final char getCharForBrightness(int nw, int ne, int sw, int se) {
        return AsciiGreyscaleTable.findNearestMaxQuick(nw, ne, sw, se, this.characters4, this.ignores4);
    }

    private static final char findNearestMaxQuick(int nw, int ne, int sw, int se, char[][] table, boolean[] ignores4) {
        int index;
        int d1;
        int length = (table.length + 1) / 2;
        if (nw <= 0 && ne <= 0 && sw <= 0 && se <= 0 && !ignores4[table[0][4] - 32]) {
            return table[0][4];
        }
        if (nw >= 255 && ne >= 255 && sw >= 255 && se >= 255 && !ignores4[table[table.length - 1][4] - 32]) {
            return table[table.length - 1][4];
        }
        int bestIndex = length;
        boolean done = false;
        while (length > 1 && !done && bestIndex >= 0 && bestIndex < table.length) {
            length = (length + 1) / 2;
            if (table[bestIndex][0] < nw) {
                bestIndex += length;
                continue;
            }
            if (table[bestIndex][0] > nw) {
                bestIndex -= length;
                continue;
            }
            done = true;
        }
        if (bestIndex < 0) {
            bestIndex = 0;
        }
        if (bestIndex >= table.length) {
            bestIndex = table.length - 1;
        }
        if (ignores4[table[bestIndex][4] - 32]) {
            int n = 1;
            while (true) {
                int d;
                if (bestIndex + (d = (n + 1) / 2 * (2 * (n % 2) - 1)) < table.length && bestIndex + d >= 0 && !ignores4[table[bestIndex + d][4] - 32]) {
                    bestIndex += d;
                    break;
                }
                ++n;
            }
        }
        d1 = (d1 = table[bestIndex][0] - nw) > 0 ? d1 : -d1;
        int d2 = table[bestIndex][1] - ne;
        d2 = d2 > 0 ? d2 : -d2;
        d1 = d1 > d2 ? d1 : d2;
        d2 = table[bestIndex][2] - sw;
        d2 = d2 > 0 ? d2 : -d2;
        d1 = d1 > d2 ? d1 : d2;
        d2 = table[bestIndex][3] - se;
        d2 = d2 > 0 ? d2 : -d2;
        d1 = d1 > d2 ? d1 : d2;
        int bestDistance = d1;
        int startIndex = bestIndex;
        int maxValue = nw + d1;
        for (index = bestIndex + 1; index < table.length && (d1 = (d1 = table[index][0] - nw) > 0 ? d1 : -d1) <= maxValue; ++index) {
            d2 = table[index][1] - ne;
            d2 = d2 > 0 ? d2 : -d2;
            d1 = d1 > d2 ? d1 : d2;
            d2 = table[index][2] - sw;
            d2 = d2 > 0 ? d2 : -d2;
            d1 = d1 > d2 ? d1 : d2;
            d2 = table[index][3] - se;
            if ((d1 = d1 > (d2 = d2 > 0 ? d2 : -d2) ? d1 : d2) >= bestDistance || ignores4[table[index][4] - 32]) continue;
            bestDistance = d1;
            bestIndex = index;
            maxValue = nw + d1;
        }
        int minValue = nw - bestDistance;
        for (index = startIndex - 1; index >= 0 && (d1 = (d1 = table[index][0] - nw) > 0 ? d1 : -d1) >= minValue; --index) {
            d2 = table[index][1] - ne;
            d2 = d2 > 0 ? d2 : -d2;
            d1 = d1 > d2 ? d1 : d2;
            d2 = table[index][2] - sw;
            d2 = d2 > 0 ? d2 : -d2;
            d1 = d1 > d2 ? d1 : d2;
            d2 = table[index][3] - se;
            if ((d1 = d1 > (d2 = d2 > 0 ? d2 : -d2) ? d1 : d2) >= bestDistance || ignores4[table[index][4] - 32]) continue;
            bestDistance = d1;
            bestIndex = index;
            minValue = nw - d1;
        }
        return table[bestIndex][4];
    }

    public final void setDoNotUse(String doNotUse) {
        System.arraycopy(this.defaultIgnores, 0, this.ignores, 0, 95);
        if (doNotUse == null) {
            return;
        }
        for (int i = doNotUse.length() - 1; i >= 0; --i) {
            int index = doNotUse.charAt(i) - 32;
            if (index < 0 || index > 94) continue;
            this.ignores[index] = true;
        }
        this.buildCharactersForBrightness();
    }

    public final void setDoNotUse4(String doNotUse) {
        System.arraycopy(this.defaultIgnores4, 0, this.ignores4, 0, 95);
        if (doNotUse == null) {
            return;
        }
        for (int i = doNotUse.length() - 1; i >= 0; --i) {
            int index = doNotUse.charAt(i) - 32;
            if (index < 0 || index > 94) continue;
            this.ignores4[index] = true;
        }
    }
}

