/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image.gui;

import de.jave.image.GImage;
import de.jave.image.gui.BufferedImageDisplayableImage;
import de.jave.image.gui.GImageDisplayableImage;
import de.jave.image.gui.IDisplayableImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.disy.commons.swing.color.SwingColors;

public final class ImagePanel {
    private IDisplayableImage image;
    private int widthLimit = -1;
    private int heightLimit = -1;
    private final JComponent imageComponent = new JComponent(){

        public final Dimension getPreferredSize() {
            Dimension size = ImagePanel.this.image != null ? ImagePanel.this.image.getSize() : new Dimension(100, 100);
            int width = size.width;
            int height = size.height;
            if (ImagePanel.this.widthLimit > 0 && width > ImagePanel.this.widthLimit) {
                width = ImagePanel.this.widthLimit;
            }
            if (ImagePanel.this.heightLimit > 0 && height > ImagePanel.this.heightLimit) {
                height = ImagePanel.this.heightLimit;
            }
            return new Dimension(width, height);
        }

        public final Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        protected final void paintComponent(Graphics g) {
            Dimension d = this.getSize();
            g.setColor(this.getBackground());
            if (ImagePanel.this.image != null) {
                int w = ((ImagePanel)ImagePanel.this).image.getSize().width;
                int h = ((ImagePanel)ImagePanel.this).image.getSize().height;
                if (w > d.width) {
                    w = d.width;
                }
                if (h > d.height) {
                    h = d.height;
                }
                int x0 = (d.width - w) / 2;
                int y0 = (d.height - h) / 2;
                ImagePanel.fillBorder(g, d, x0, y0, w, h);
                ImagePanel.this.image.paint(g, x0, y0, w, h);
                return;
            }
            g.fillRect(0, 0, d.width, d.height);
            Graphics2D graphics = (Graphics2D)g;
            graphics.setColor(SwingColors.getControlShadowColor());
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawLine(0, 0, d.width - 1, d.height - 1);
            graphics.drawLine(d.width - 1, 0, 0, d.height - 1);
        }
    };
    private final JComponent content = new JScrollPane(this.imageComponent);

    public ImagePanel() {
        this(null);
    }

    public ImagePanel(IDisplayableImage image) {
        this.setImage(image);
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void setImage(BufferedImage image) {
        this.setImage(new BufferedImageDisplayableImage(image));
    }

    public final void setImage(GImage image) {
        this.setImage(new GImageDisplayableImage(image));
    }

    public final void setImage(IDisplayableImage image) {
        this.image = image;
        this.imageComponent.revalidate();
        this.imageComponent.repaint();
    }

    private static final void fillBorder(Graphics g, Dimension d, int x, int y, int w, int h) {
        g.fillRect(0, 0, d.width, y - 1);
        g.fillRect(0, y + h + 1, d.width, d.height - y - h - 2);
        g.fillRect(0, y - 1, x - 1, h + 2);
        g.fillRect(x + w + 1, y - 1, d.width - x - w - 1, h + 2);
    }

    public final void setHeightLimit(int heightLimit) {
        this.heightLimit = heightLimit;
    }

    public final void setWidthLimit(int widthLimit) {
        this.widthLimit = widthLimit;
    }
}

