/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.io;

import de.jave.core.io.FileSelectionModel;
import de.jave.gui.io.FileListCellRenderer;
import de.jave.lib.collections.IntVector;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;

public final class FileListPanel {
    private final JList list;
    private JComponent content;
    private final FileSelectionModel selectionModel;
    private boolean isUpdatingSelection = false;

    public FileListPanel(FileSystemView fileSystemView, final FileSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
        this.list = new JList();
        this.list.setCellRenderer(new FileListCellRenderer(fileSystemView));
        this.content = new JScrollPane(this.list);
        selectionModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                FileListPanel.this.updateListSelection();
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent e) {
                if (FileListPanel.this.isUpdatingSelection) {
                    return;
                }
                Object[] selectedValues = FileListPanel.this.list.getSelectedValues();
                File[] selectedFiles = new File[selectedValues.length];
                for (int i = 0; i < selectedFiles.length; ++i) {
                    selectedFiles[i] = (File)selectedValues[i];
                }
                selectionModel.setSelected(selectedFiles);
            }
        });
    }

    private void updateListSelection() {
        IntVector selectedIndices = new IntVector();
        for (int i = 0; i < this.list.getModel().getSize(); ++i) {
            File file = (File)this.list.getModel().getElementAt(i);
            if (!this.selectionModel.isSelected(file)) continue;
            selectedIndices.add(i);
        }
        this.isUpdatingSelection = true;
        this.list.setSelectedIndices(selectedIndices.toArray());
        this.isUpdatingSelection = false;
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void setFiles(File[] files) {
        this.list.setListData(files);
    }

    public final int getFileCount() {
        return this.list.getModel().getSize();
    }
}

