/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.dialog;

import de.jave.gui.dialog.HtmlMessage;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.userdialog.AbstractDialogPage;
import net.disy.commons.swing.layout.grid.GridAlignment;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.message.MessageTypeUi;

public final class HtmlMessagePage
extends AbstractDialogPage {
    private final HtmlMessage message;

    public HtmlMessagePage(HtmlMessage message) {
        super(new BasicMessage());
        Ensure.ensureArgumentNotNull(message);
        this.message = message;
    }

    public final IBasicMessage createCurrentMessage() {
        return this.getDefaultMessage();
    }

    public final String getTitle() {
        if (this.message.getTitle() == null) {
            return MessageTypeUi.getLabel(this.message.getType());
        }
        return this.message.getTitle();
    }

    public final JComponent createContent() {
        if (this.message.getType() == MessageType.NORMAL) {
            return this.createHtmlTextComponent();
        }
        GridDialogLayoutData iconData = new GridDialogLayoutData();
        iconData.setVerticalAlignment(GridAlignment.BEGINNING);
        Icon icon = MessageTypeUi.getIcon(this.message.getType());
        JPanel panel = new JPanel(new GridDialogLayout(2, false, 13, 0));
        panel.add((Component)new JLabel(icon), iconData);
        panel.add((Component)this.createHtmlTextComponent(), GridDialogLayoutData.FILL_BOTH);
        return panel;
    }

    private JComponent createHtmlTextComponent() {
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        textPane.setEditable(false);
        textPane.setText(this.message.getHtmlText());
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setPreferredSize(new Dimension(360, 300));
        textPane.setCaretPosition(0);
        return scrollPane;
    }
}

