/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GPaintedButton;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;

public final class GTextButton
extends GPaintedButton {
    private String text;
    private char shortcut;
    private int textWidth = -1;
    private int textHeight = -1;
    private Dimension normalSize;

    public GTextButton(String text) {
        this.text = text;
        this.shortcut = '\u0000';
        this.computeTextSize();
    }

    public final void setFont(Font font) {
        super.setFont(font);
        this.computeTextSize();
        this.repaint();
    }

    private void computeTextSize() {
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(font);
        if (fm == null) {
            return;
        }
        this.textWidth = fm.stringWidth(this.text);
        this.textHeight = fm.getAscent();
        this.normalSize = new Dimension(this.textWidth + 14, 23);
    }

    public final boolean isFocusTraversable() {
        return this.focusTraversable;
    }

    public final Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        if (this.textWidth == -1) {
            this.computeTextSize();
        }
        return this.normalSize;
    }

    protected final void paintEnabled(Graphics g) {
        g.setColor(SystemColor.textText);
        int x = (this.getSize().width - this.textWidth) / 2;
        int y = (this.getSize().height - this.textHeight) / 2 + this.textHeight - 2;
        g.drawString(this.text, x, y);
        this.paintShortcut(g, x, y);
    }

    private void paintShortcut(Graphics g, int x, int y) {
        if (this.shortcut != '\u0000') {
            int pos = 0;
            while (Character.toLowerCase(this.text.charAt(pos)) != this.shortcut) {
                ++pos;
            }
            String s1 = this.text.substring(0, pos);
            String s2 = this.text.substring(0, pos + 1);
            FontMetrics fm = g.getFontMetrics();
            int x1 = fm.stringWidth(s1);
            int x2 = fm.stringWidth(s2) - 1;
            if (x2 - x1 < 3) {
                x2 = x1 + 3;
            }
            g.drawLine(x + x1, y + 1, x + x2, y + 1);
        }
    }

    protected final void paintPressed(Graphics g) {
        g.setColor(SystemColor.textText);
        int x = (this.getSize().width - this.textWidth) / 2;
        int y = (this.getSize().height - this.textHeight) / 2 + this.textHeight - 2;
        g.drawString(this.text, x + 1, y + 1);
        this.paintShortcut(g, x + 1, y + 1);
    }

    protected final void paintDisabled(Graphics g) {
        g.setColor(SystemColor.controlLtHighlight);
        int x = (this.getSize().width - this.textWidth) / 2;
        int y = (this.getSize().height - this.textHeight) / 2 + this.textHeight - 2;
        g.drawString(this.text, x + 1, y + 1);
        this.paintShortcut(g, x + 1, y + 1);
        g.setColor(SystemColor.controlShadow);
        g.drawString(this.text, x, y);
        this.paintShortcut(g, x, y);
    }
}

