/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GButton;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public final class GImageButton
extends GButton {
    private Icon iDisabled;
    private Icon iEnabled;

    public GImageButton(Icon icon) {
        this(icon, icon);
    }

    public GImageButton(Icon imageEnabled, Icon imageDisabled) {
        this.focusTraversable = false;
        this.iEnabled = imageEnabled;
        this.iDisabled = imageDisabled;
    }

    protected final void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        int w = d.width;
        int h = d.height;
        if (!this.isEnabled) {
            if (this.iDisabled != null) {
                int x = 1 + (w - 3 - this.iDisabled.getIconWidth()) / 2;
                int y = 1 + (h - 3 - this.iDisabled.getIconHeight()) / 2;
                this.iDisabled.paintIcon(this, g, x, y);
            }
        } else if (this.pressed || this.lockable && this.locked) {
            if (this.iEnabled != null) {
                int x = 2 + (w - 3 - this.iEnabled.getIconWidth()) / 2;
                int y = 2 + (h - 3 - this.iEnabled.getIconHeight()) / 2;
                this.iEnabled.paintIcon(this, g, x, y);
            }
        } else if (this.iEnabled != null) {
            int x = 1 + (w - 3 - this.iEnabled.getIconWidth()) / 2;
            int y = 1 + (h - 3 - this.iEnabled.getIconHeight()) / 2;
            this.iEnabled.paintIcon(this, g, x, y);
        }
        this.paintBorder(g);
    }
}

