/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GButton;
import java.awt.AWTEventMulticaster;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public final class GButtonGroup
implements ActionListener,
ItemSelectable {
    protected Vector buttons = new Vector(5);
    protected int selectedIndex;
    transient ItemListener itemListener;

    public final synchronized void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public final synchronized void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public final GButton getButton(int i) {
        return (GButton)this.buttons.elementAt(i);
    }

    public final void select(int i) {
        this.selectButton(i);
    }

    public final void selectButton(int i) {
        if (i == this.selectedIndex) {
            return;
        }
        GButton bAlt = this.getButton(this.selectedIndex);
        bAlt.setLocked(false);
        GButton bNeu = this.getButton(i);
        bNeu.setLocked(true);
        this.selectedIndex = i;
    }

    public final void add(GButton b) {
        b.setLockable(true);
        b.setUnlockable(false);
        if (this.buttons.size() == 0) {
            b.setLocked();
            this.selectedIndex = 0;
        }
        this.buttons.addElement(b);
        b.addActionListener(this);
    }

    public final void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        for (int i = 0; i < this.buttons.size(); ++i) {
            Object o = this.buttons.elementAt(i);
            if (o != source) {
                ((GButton)o).setLocked(false);
                continue;
            }
            this.selectedIndex = i;
        }
        ItemEvent e = new ItemEvent(this, 701, source, 1);
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    public final Object[] getSelectedObjects() {
        return new Object[]{this.buttons.elementAt(this.selectedIndex)};
    }

    public final int getSelectedIndex() {
        return this.selectedIndex;
    }
}

