/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gfx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

public final class GfxTools {
    private static final BasicStroke BROKEN_LINE_STROKE = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{3.0f, 4.0f}, 1.0f);

    private GfxTools() {
    }

    public static final double distance(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }

    public static final void drawDottedRectangle(Graphics g, int x, int y, int width, int height) {
        GfxTools.drawBrokenHorizontalLine(g, x, x + width, y, 1, 0);
        GfxTools.drawBrokenHorizontalLine(g, x, x + width, y + height, 1, 0);
        GfxTools.drawBrokenVerticalLine(g, x, y, y + height, 1, 0);
        GfxTools.drawBrokenVerticalLine(g, x + width, y, y + height, 1, 0);
    }

    public static final void drawBrokenLine(Graphics2D g, int x1, int y1, int x2, int y2, int offset) {
        if (y2 == y1) {
            GfxTools.drawBrokenHorizontalLine(g, x1, x2, y1, 3, offset);
            return;
        }
        if (x2 == x1) {
            GfxTools.drawBrokenVerticalLine(g, x1, y1, y2, 3, offset);
            return;
        }
        Stroke previousStroke = g.getStroke();
        g.setStroke(BROKEN_LINE_STROKE);
        g.drawLine(x1, y1, x2, y2);
        g.setStroke(previousStroke);
    }

    public static final void drawBrokenHorizontalLine(Graphics g, int x1, int x2, int y1, int strokeLength, int offset) {
        int count = 0;
        int x = 0;
        for (x = x1; x <= x2; ++x) {
            int pos = (x + strokeLength * 2 - offset) % (strokeLength * 2);
            if (pos < strokeLength) {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            g.drawLine(x - count, y1, x - 1, y1);
            count = 0;
        }
        if (count > 0) {
            g.drawLine(x - count, y1, x - 1, y1);
        }
    }

    public static final void drawBrokenVerticalLine(Graphics g, int x1, int y1, int y2, int strokeLength, int offset) {
        int count = 0;
        int y = 0;
        for (y = y1; y <= y2; ++y) {
            int pos = (y + strokeLength * 2 - offset) % (strokeLength * 2);
            if (pos < strokeLength) {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            g.drawLine(x1, y - count, x1, y - 1);
            count = 0;
        }
        if (count > 0) {
            g.drawLine(x1, y - count, x1, y - 1);
        }
    }

    public static final void drawBrokenRectangle(Graphics2D g, Color color1, Color color2, int x, int y, int width, int height, int offset) {
        g.setColor(color1);
        g.drawRect(x, y, width, height);
        g.setColor(color2);
        GfxTools.drawBrokenRectangle(g, x, y, width, height, offset);
    }

    public static final void drawBrokenRectangle(Graphics2D g, int x, int y, int width, int height) {
        GfxTools.drawBrokenRectangle(g, x, y, width, height, 0);
    }

    public static final void drawBrokenRectangle(Graphics2D g, int x, int y, int width, int height, int offset) {
        GfxTools.drawBrokenHorizontalLine(g, x, x + width, y, 3, offset);
        GfxTools.drawBrokenHorizontalLine(g, x, x + width, y + height, 3, offset);
        GfxTools.drawBrokenVerticalLine(g, x, y, y + height, 3, offset);
        GfxTools.drawBrokenVerticalLine(g, x + width, y, y + height, 3, offset);
    }

    public static final void drawBrokenLine(Graphics2D g, int x1, int y1, int x2, int y2) {
        GfxTools.drawBrokenLine(g, x1, y1, x2, y2, 0);
    }

    public static final void paintArrow(Graphics g, int x1, int y1, int x2, int y2) {
        double vx = x1 - x2;
        double vy = y1 - y2;
        double scale = Math.sqrt(vx * vx + vy * vy);
        double nx = -(vy /= scale) * 3.0;
        double ny = (vx /= scale) * 3.0;
        g.drawLine(x2, y2, x2 + (int)((vx *= 8.0) + nx), y2 + (int)((vy *= 8.0) + ny));
        g.drawLine(x2, y2, x2 + (int)(vx - nx), y2 + (int)(vy - ny));
    }

    public static final boolean clipLine(Point p1, Point p2, Rectangle clip) {
        int yMin = clip.y;
        int yMax = clip.y + clip.height;
        int xMin = clip.x;
        int xMax = clip.x + clip.width;
        int i1 = GfxTools.computeOutCode(p1, xMin, xMax, yMin, yMax);
        int i2 = GfxTools.computeOutCode(p2, xMin, xMax, yMin, yMax);
        int x = 0;
        int y = 0;
        while (i1 != 0 || i2 != 0) {
            if ((i1 & i2) != 0) {
                return false;
            }
            int out = i1 != 0 ? i1 : i2;
            if ((out & 8) > 0) {
                x = p1.x + (p2.x - p1.x) * (yMin - p1.y) / (p2.y - p1.y);
                y = yMin;
            } else if ((out & 4) > 0) {
                x = p1.x + (p2.x - p1.x) * (yMax - p1.y) / (p2.y - p1.y);
                y = yMax;
            } else if ((out & 1) > 0) {
                y = p1.y + (p2.y - p1.y) * (xMax - p1.x) / (p2.x - p1.x);
                x = xMax;
            } else if ((out & 2) > 0) {
                y = p1.y + (p2.y - p1.y) * (xMin - p1.x) / (p2.x - p1.x);
                x = xMin;
            }
            if (out == i1) {
                p1.x = x;
                p1.y = y;
                i1 = GfxTools.computeOutCode(p1, xMin, xMax, yMin, yMax);
                continue;
            }
            p2.x = x;
            p2.y = y;
            i2 = GfxTools.computeOutCode(p2, xMin, xMax, yMin, yMax);
        }
        return true;
    }

    protected static final int computeOutCode(Point p, int xMin, int xMax, int yMin, int yMax) {
        int out = 0;
        if (p.y < yMin) {
            out = 8;
        } else if (p.y > yMax) {
            out = 4;
        }
        if (p.x < xMin) {
            out += 2;
        } else if (p.x > xMax) {
            ++out;
        }
        return out;
    }

    public static final void drawArc(Graphics g, int oX, int oY, int radius, double angle, double arcAngle) {
        GfxTools.drawArc(g, oX, oY, radius, radius, angle, arcAngle);
    }

    public static final void drawArc(Graphics g, int oX, int oY, int radiusX, int radiusY, double angle, double arcAngle) {
        double endAngle;
        double startAngle;
        double d;
        if ((double)radiusX == 0.0 || (double)radiusY == 0.0) {
            GfxTools.set(g, oX, oY, oX, oX, oY, oY);
            return;
        }
        if (arcAngle < 0.0) {
            angle += arcAngle;
            arcAngle = -arcAngle;
        }
        angle %= 360.0;
        if (d + arcAngle >= 270.0 && angle <= 360.0 || angle + arcAngle >= 630.0 && angle <= 720.0) {
            double d2;
            startAngle = angle - 270.0;
            endAngle = (angle + arcAngle) % 360.0;
            endAngle = d2 < 270.0 ? 90.0 : (endAngle %= 270.0);
            if (startAngle < 0.0) {
                startAngle = 0.0;
            }
            if (endAngle < 0.0) {
                endAngle = 0.0;
            }
            if (startAngle > 90.0) {
                startAngle = 90.0;
            }
            if (endAngle > 90.0) {
                endAngle = 90.0;
            }
            if (endAngle < startAngle) {
                GfxTools.drawArcSE(g, oX, oY, radiusX, radiusY, 0.0, endAngle);
                GfxTools.drawArcSE(g, oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                GfxTools.drawArcSE(g, oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
        if (angle + arcAngle >= 180.0 && angle <= 270.0 || angle + arcAngle >= 540.0 && angle <= 630.0) {
            double d3;
            startAngle = angle - 180.0;
            endAngle = (angle + arcAngle) % 360.0;
            endAngle = d3 < 180.0 ? 90.0 : (endAngle %= 180.0);
            if (startAngle < 0.0 || startAngle > 90.0) {
                startAngle = 0.0;
            }
            if (endAngle < 0.0) {
                endAngle = 0.0;
            }
            if (endAngle > 90.0) {
                endAngle = 90.0;
            }
            if (endAngle < startAngle) {
                GfxTools.drawArcSW(g, oX, oY, radiusX, radiusY, 0.0, endAngle);
                GfxTools.drawArcSW(g, oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                GfxTools.drawArcSW(g, oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
        if (angle + arcAngle >= 90.0 && angle <= 180.0 || angle + arcAngle >= 450.0 && angle <= 540.0) {
            double d4;
            startAngle = angle - 90.0;
            if (angle < 90.0) {
                startAngle = 0.0;
            } else if (angle > 180.0) {
                startAngle = 0.0;
            }
            endAngle = (angle + arcAngle) % 360.0;
            endAngle = d4 > 180.0 ? 90.0 : (endAngle < 90.0 ? 90.0 : (endAngle %= 90.0));
            if (endAngle < startAngle) {
                GfxTools.drawArcNW(g, oX, oY, radiusX, radiusY, 0.0, endAngle);
                GfxTools.drawArcNW(g, oX, oY, radiusX, radiusY, startAngle, 90.0);
            } else {
                GfxTools.drawArcNW(g, oX, oY, radiusX, radiusY, startAngle, endAngle);
            }
        }
        if (angle + arcAngle >= 0.0 && angle <= 90.0 || angle + arcAngle >= 360.0 && angle <= 450.0) {
            startAngle = angle;
            endAngle = (angle + arcAngle) % 360.0;
            if (startAngle > 90.0) {
                startAngle = 0.0;
            }
            if (endAngle > 90.0) {
                endAngle = 90.0;
            }
            if (endAngle < startAngle) {
                GfxTools.drawArcNE(g, oX, oY, radiusX, radiusY, 0.0, endAngle);
                GfxTools.drawArcNE(g, oX, oY, radiusX, radiusY, startAngle, 90.0);
                return;
            }
            GfxTools.drawArcNE(g, oX, oY, radiusX, radiusY, startAngle, endAngle);
        }
    }

    protected static final void drawArcSE(Graphics g, int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX;
        int maxX = oX + radiusX;
        int minY = oY;
        int maxY = oY + radiusY;
        if (startAngle > 0.0) {
            minX = oX + (int)((double)radiusX * Math.sin(startAngle / 180.0 * Math.PI));
            maxY = oY + (int)((double)radiusY * Math.cos(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            maxX = oX + (int)((double)radiusX * Math.sin(endAngle / 180.0 * Math.PI));
            minY = oY + (int)((double)radiusY * Math.cos(endAngle / 180.0 * Math.PI));
        }
        Rectangle clip = g.getClipBounds();
        if (clip.x > minX) {
            minX = clip.x;
        }
        if (clip.x + clip.width < maxX) {
            maxX = clip.x + clip.width;
        }
        if (clip.y > minY) {
            minY = clip.y;
        }
        if (clip.y + clip.height < maxY) {
            maxY = clip.y + clip.height;
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        GfxTools.set(g, oX + x, oY + y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    GfxTools.set(g, oX + x, oY + y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            GfxTools.set(g, oX + x, oY, minX, maxX, minY, maxY);
            return;
        }
        int x = 0;
        int y = radiusX;
        int xE = 0;
        int yE = radiusY * radiusY;
        int e = -yE / 2;
        int c = yE / radiusX;
        do {
            if (e <= 0) {
                do {
                    GfxTools.set(g, oX + y, oY + x, minX, maxX, minY, maxY);
                    ++x;
                } while ((e += (xE += radiusX)) <= 0);
            } else {
                GfxTools.set(g, oX + y, oY + x, minX, maxX, minY, maxY);
            }
            e -= (yE -= c);
        } while (--y != 0);
        GfxTools.set(g, oX, oY + x, minX, maxX, minY, maxY);
    }

    protected static final void drawArcSW(Graphics g, int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX - radiusX;
        int maxX = oX;
        int minY = oY;
        int maxY = oY + radiusY;
        if (startAngle > 0.0) {
            minX = oX - (int)((double)radiusX * Math.cos(startAngle / 180.0 * Math.PI));
            minY = oY + (int)((double)radiusY * Math.sin(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            maxX = oX - (int)((double)radiusX * Math.cos(endAngle / 180.0 * Math.PI));
            maxY = oY + (int)((double)radiusY * Math.sin(endAngle / 180.0 * Math.PI));
        }
        Rectangle clip = g.getClipBounds();
        if (clip.x > minX) {
            minX = clip.x;
        }
        if (clip.x + clip.width < maxX) {
            maxX = clip.x + clip.width;
        }
        if (clip.y > minY) {
            minY = clip.y;
        }
        if (clip.y + clip.height < maxY) {
            maxY = clip.y + clip.height;
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        GfxTools.set(g, oX - x, oY + y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    GfxTools.set(g, oX - x, oY + y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            GfxTools.set(g, oX - x, oY, minX, maxX, minY, maxY);
            return;
        }
        int x = 0;
        int y = radiusX;
        int xE = 0;
        int yE = radiusY * radiusY;
        int e = -yE / 2;
        int c = yE / radiusX;
        do {
            if (e <= 0) {
                do {
                    GfxTools.set(g, oX - y, oY + x, minX, maxX, minY, maxY);
                    ++x;
                } while ((e += (xE += radiusX)) <= 0);
            } else {
                GfxTools.set(g, oX - y, oY + x, minX, maxX, minY, maxY);
            }
            e -= (yE -= c);
        } while (--y != 0);
        GfxTools.set(g, oX, oY + x, minX, maxX, minY, maxY);
    }

    protected static final void drawArcNW(Graphics g, int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX - radiusX;
        int maxX = oX;
        int minY = oY - radiusY;
        int maxY = oY;
        if (startAngle > 0.0) {
            maxX = oX - (int)((double)radiusX * Math.sin(startAngle / 180.0 * Math.PI));
            minY = oY - (int)((double)radiusY * Math.cos(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            minX = oX - (int)((double)radiusX * Math.sin(endAngle / 180.0 * Math.PI));
            maxY = oY - (int)((double)radiusY * Math.cos(endAngle / 180.0 * Math.PI));
        }
        Rectangle clip = g.getClipBounds();
        if (clip.x > minX) {
            minX = clip.x;
        }
        if (clip.x + clip.width < maxX) {
            maxX = clip.x + clip.width;
        }
        if (clip.y > minY) {
            minY = clip.y;
        }
        if (clip.y + clip.height < maxY) {
            maxY = clip.y + clip.height;
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        GfxTools.set(g, oX - x, oY - y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    GfxTools.set(g, oX - x, oY - y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            return;
        }
        int x = 0;
        int y = radiusX;
        int xE = 0;
        int yE = radiusY * radiusY;
        int e = -yE / 2;
        int c = yE / radiusX;
        do {
            if (e <= 0) {
                do {
                    GfxTools.set(g, oX - y, oY - x, minX, maxX, minY, maxY);
                    ++x;
                } while ((e += (xE += radiusX)) <= 0);
            } else {
                GfxTools.set(g, oX - y, oY - x, minX, maxX, minY, maxY);
            }
            e -= (yE -= c);
        } while (--y != 0);
        GfxTools.set(g, oX, oY - x, minX, maxX, minY, maxY);
    }

    protected static final void drawArcNE(Graphics g, int oX, int oY, int radiusX, int radiusY, double startAngle, double endAngle) {
        int minX = oX;
        int maxX = oX + radiusX;
        int minY = oY - radiusY;
        int maxY = oY;
        if (startAngle > 0.0) {
            maxX = oX + (int)((double)radiusX * Math.cos(startAngle / 180.0 * Math.PI));
            maxY = oY - (int)((double)radiusY * Math.sin(startAngle / 180.0 * Math.PI));
        }
        if (endAngle < 90.0) {
            minX = oX + (int)((double)radiusX * Math.cos(endAngle / 180.0 * Math.PI));
            minY = oY - (int)((double)radiusY * Math.sin(endAngle / 180.0 * Math.PI));
        }
        Rectangle clip = g.getClipBounds();
        if (clip.x > minX) {
            minX = clip.x;
        }
        if (clip.x + clip.width < maxX) {
            maxX = clip.x + clip.width;
        }
        if (clip.y > minY) {
            minY = clip.y;
        }
        if (clip.y + clip.height < maxY) {
            maxY = clip.y + clip.height;
        }
        if (maxX < minX || maxY < minY) {
            return;
        }
        if (radiusY <= radiusX) {
            int x = 0;
            int y = radiusY;
            int xE = 0;
            int yE = radiusX * radiusX;
            int e = -yE / 2;
            int c = yE / radiusY;
            do {
                if (e <= 0) {
                    do {
                        GfxTools.set(g, oX + x, oY - y, minX, maxX, minY, maxY);
                        ++x;
                    } while ((e += (xE += radiusY)) <= 0);
                } else {
                    GfxTools.set(g, oX + x, oY - y, minX, maxX, minY, maxY);
                }
                e -= (yE -= c);
            } while (--y != 0);
            return;
        }
        int x = 0;
        int y = radiusX;
        int xE = 0;
        int yE = radiusY * radiusY;
        int e = -yE / 2;
        int c = yE / radiusX;
        do {
            if (e <= 0) {
                do {
                    GfxTools.set(g, oX + y, oY - x, minX, maxX, minY, maxY);
                    ++x;
                } while ((e += (xE += radiusX)) <= 0);
            } else {
                GfxTools.set(g, oX + y, oY - x, minX, maxX, minY, maxY);
            }
            e -= (yE -= c);
        } while (--y != 0);
        GfxTools.set(g, oX, oY - x, minX, maxX, minY, maxY);
    }

    protected static final void set(Graphics g, int x, int y, int minX, int maxX, int minY, int maxY) {
        if (x < minX && y < minY || y > maxY && x > maxX || x < minX - 1 || x > maxX + 1 || y < minY - 1 || y > maxY + 1) {
            return;
        }
        g.drawLine(x, y, x, y);
    }
}

