/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.io;

import de.jave.figlet.file.FigFontCategorization;
import de.jave.figlet.file.FigFontCategory;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.file.IFigFontCategoryContainer;
import de.jave.figlet.util.FigException;
import de.jave.figlet.util.FigFileFormatException;
import de.jave.lib.io.IoUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public final class FigCategoriesFileParser {
    public final FigFontCategorization loadCategoriesFile(String[] fontNames, IFigFileResource fileResource, String categoriesFileName) throws FigException {
        HashSet<String> unusedFontNames = new HashSet<String>(Arrays.asList(fontNames));
        HashSet<String> allFontNames = new HashSet<String>(Arrays.asList(fontNames));
        FigFontCategorization categorization = null;
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String line;
            inputStream = fileResource.openConfigurationFileInputStream(categoriesFileName);
            if (inputStream == null) {
                throw new FigException("No categories file '" + categoriesFileName + "' existing (" + fileResource.getRourceBaseDescription() + ")");
            }
            categorization = new FigFontCategorization();
            String defaultFontCategoryName = null;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            FigFontCategory currentCategory = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() < 1 || line.charAt(0) == '#') continue;
                if (line.charAt(0) == '[') {
                    String[] categoryNamePath = this.parseCategoryTreePath(line);
                    String description = this.parseDescription(line);
                    currentCategory = this.addCategory(categorization, categoryNamePath);
                    currentCategory.setDescription(description);
                    if (defaultFontCategoryName != null && !currentCategory.getName().equals("Outline")) continue;
                    defaultFontCategoryName = currentCategory.getName();
                    continue;
                }
                if (!allFontNames.contains(line)) continue;
                unusedFontNames.remove(line);
                if (currentCategory != null) {
                    currentCategory.addFontName(line);
                    continue;
                }
                throw new FigFileFormatException("No category defined for font " + line);
            }
            if (unusedFontNames.size() > 0) {
                currentCategory = new FigFontCategory("New fonts");
                currentCategory.setDynamicallyGenerated(true);
                Iterator<String> iter = unusedFontNames.iterator();
                while (iter.hasNext()) {
                    String element = iter.next();
                    currentCategory.addFontName(element);
                }
                categorization.addChild(currentCategory);
            }
            currentCategory = new FigFontCategory("All fonts");
            currentCategory.setDynamicallyGenerated(true);
            for (int i = 0; i < fontNames.length; ++i) {
                currentCategory.addFontName(fontNames[i]);
            }
            categorization.addChild(currentCategory);
            categorization.setDefaultCategoryName(defaultFontCategoryName);
        }
        catch (IOException e) {
            try {
                throw new FigException("Error reading categories file (" + fileResource.getRourceBaseDescription() + ")", e);
            }
            catch (Throwable throwable) {
                IoUtilities.close(reader);
                IoUtilities.close(inputStream);
                throw throwable;
            }
        }
        IoUtilities.close(reader);
        IoUtilities.close(inputStream);
        return categorization;
    }

    public final FigFontCategory addCategory(FigFontCategorization categorization, String[] categoryNamePath) {
        IFigFontCategoryContainer parent = categorization;
        for (int i = 0; i < categoryNamePath.length; ++i) {
            FigFontCategory child = parent.getChildCategory(categoryNamePath[i]);
            if (child == null) {
                child = new FigFontCategory(categoryNamePath[i]);
                parent.addChild(child);
            }
            parent = child;
        }
        return (FigFontCategory)parent;
    }

    public final String[] parseCategoryTreePath(String line) throws FigFileFormatException {
        if (!line.startsWith("[") || line.indexOf("]") == -1) {
            throw new FigFileFormatException("Illegal format for category specification '" + line + "'");
        }
        line = line.substring(1, line.indexOf(93));
        ArrayList<String> pathelements = new ArrayList<String>();
        int startIndex = 0;
        int endIndex = -1;
        while (true) {
            if ((endIndex = line.indexOf(124, startIndex = endIndex + 1)) == -1) break;
            pathelements.add(line.substring(startIndex, endIndex));
        }
        pathelements.add(line.substring(startIndex));
        return pathelements.toArray(new String[pathelements.size()]);
    }

    private String parseDescription(String line) {
        int startIndex = line.indexOf(93);
        int i1 = line.indexOf("{", startIndex);
        if (i1 == -1) {
            return null;
        }
        int i2 = line.indexOf("}", i1);
        if (i2 == -1) {
            return null;
        }
        return line.substring(i1 + 1, i2);
    }
}

