/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.file;

import de.jave.figlet.file.FigFontCategory;
import de.jave.figlet.file.IFigFontCategorization;
import de.jave.figlet.file.IFigFontCategoryContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.disy.commons.core.util.Ensure;

public final class FigFontCategorization
implements IFigFontCategorization {
    private String defaultCategoryName = "All fonts";
    private List categories = new ArrayList();
    private Map categoriesByName = new HashMap();

    public static final FigFontCategorization createFallBackCategorization(String[] fontNames) {
        String name = "All fonts";
        FigFontCategory singleCategory = new FigFontCategory(name);
        singleCategory.addFontNames(fontNames);
        FigFontCategorization categorization = new FigFontCategorization();
        categorization.addChild(singleCategory);
        categorization.setDefaultCategoryName(name);
        return categorization;
    }

    public final Object clone() {
        FigFontCategorization clone = new FigFontCategorization();
        clone.setDefaultCategoryName(this.defaultCategoryName);
        FigFontCategory[] childCategories = this.getChildCategories();
        for (int i = 0; i < this.getChildCategoryCount(); ++i) {
            clone.addChild((FigFontCategory)childCategories[i].clone());
        }
        return clone;
    }

    public final void setDefaultCategoryName(String name) {
        Ensure.ensureArgumentNotNull(name);
        this.defaultCategoryName = name;
    }

    public final FigFontCategory[] getAllNonEmptyCategories() {
        ArrayList<FigFontCategory> nonEmpty = new ArrayList<FigFontCategory>();
        for (int i = 0; i < this.categories.size(); ++i) {
            FigFontCategory category = (FigFontCategory)this.categories.get(i);
            if (category.getFontCount() <= 0) continue;
            nonEmpty.add(category);
        }
        return nonEmpty.toArray(new FigFontCategory[nonEmpty.size()]);
    }

    public final FigFontCategory getDefaultCategory() {
        return this.getCategory(this.defaultCategoryName);
    }

    public final FigFontCategory getCategory(String name) {
        return FigFontCategorization.getCategory(this, name);
    }

    private static FigFontCategory getCategory(IFigFontCategoryContainer container, String name) {
        if (container instanceof FigFontCategory && ((FigFontCategory)container).getName().equals(name)) {
            return (FigFontCategory)container;
        }
        FigFontCategory[] childCategories = container.getChildCategories();
        for (int i = 0; i < childCategories.length; ++i) {
            FigFontCategory category = FigFontCategorization.getCategory(childCategories[i], name);
            if (category == null) continue;
            return category;
        }
        return null;
    }

    public final int getChildCategoryCount() {
        return this.categories.size();
    }

    public final FigFontCategory[] getChildCategories() {
        return this.categories.toArray(new FigFontCategory[this.categories.size()]);
    }

    public final void addChild(FigFontCategory child) {
        this.categories.add(child);
        this.categoriesByName.put(child.getName(), child);
    }

    public final FigFontCategory getChildCategory(String name) {
        Iterator iter = this.categories.iterator();
        while (iter.hasNext()) {
            FigFontCategory element = (FigFontCategory)iter.next();
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }
}

