/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.file;

import de.jave.figlet.file.AbstractFigFileResource;
import de.jave.figlet.file.FigFileName;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.util.FigException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.disy.commons.core.util.Ensure;

public final class BaseUrlFigFileResource
extends AbstractFigFileResource
implements IFigFileResource {
    private URL baseUrl;

    public BaseUrlFigFileResource(URL baseUrl) {
        Ensure.ensureArgumentNotNull(baseUrl);
        this.baseUrl = baseUrl;
    }

    public final InputStream openConfigurationFileInputStream(String fileName) throws FigException {
        return this.openFileInputStream(fileName);
    }

    private InputStream openFileInputStream(String inputFileName) throws FigException {
        try {
            URL url = null;
            url = new URL(this.baseUrl, inputFileName);
            return url.openStream();
        }
        catch (MalformedURLException e) {
            throw new FigException("Unable to create url for input file '" + inputFileName + "'", e);
        }
        catch (IOException e) {
            throw new FigException("Unable to connect to url for input file '" + inputFileName + "'", e);
        }
    }

    public final FigFileName[] loadFigletFileNames() throws FigException {
        return this.loadFigletFileNames(this.openFileInputStream("files.txt"));
    }

    public final InputStream openFigFileInputStream(FigFileName fileDescription) throws FigException {
        return this.openFileInputStream(fileDescription.getName());
    }

    public final String getRourceBaseDescription() {
        return "Url " + this.baseUrl.toString();
    }
}

