/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine.primitives;

import de.jave.figlet.engine.layout.PrintDirection;
import de.jave.figlet.engine.primitives.HorizontalLayoutMode;
import de.jave.figlet.engine.primitives.HorizontalSmushingRules;
import de.jave.figlet.engine.primitives.VerticalLayoutMode;
import de.jave.figlet.engine.primitives.VerticalSmushingRules;
import de.jave.lib.IPublicCloneable;
import de.jave.text.QuickString;
import net.disy.commons.core.util.Ensure;

public final class FigLayout
implements IPublicCloneable {
    private HorizontalLayoutMode horizontalMode;
    private VerticalLayoutMode verticalMode;
    private HorizontalSmushingRules horizontalRules;
    private VerticalSmushingRules verticalRules;
    private int horizontalSupersmushingDepth = 2;
    private int verticalSupersmushingDepth = 2;
    private PrintDirection printDirection = PrintDirection.LEFT_TO_RIGHT;

    public final PrintDirection getPrintDirection() {
        return this.printDirection;
    }

    public FigLayout(HorizontalLayoutMode horizontalLayoutMode, HorizontalSmushingRules horizontalRules, VerticalLayoutMode verticalLayoutMode, VerticalSmushingRules verticalRules) {
        this.horizontalMode = horizontalLayoutMode;
        this.verticalMode = verticalLayoutMode;
        this.verticalRules = verticalRules;
        this.horizontalRules = horizontalRules;
    }

    public FigLayout() {
        this(HorizontalLayoutMode.KERNING, new HorizontalSmushingRules(), VerticalLayoutMode.VERTICAL_FITTING, new VerticalSmushingRules());
    }

    public final FigLayout intersect(FigLayout other) {
        FigLayout layout = new FigLayout(this.getHorizontalLayoutMode().intersect(other.getHorizontalLayoutMode()), this.getHorizontalSmushingRules().intersect(other.getHorizontalSmushingRules()), this.getVerticalLayoutMode().intersect(other.getVerticalLayoutMode()), this.getVerticalSmushingRules().intersect(other.getVerticalSmushingRules()));
        layout.setHorizontalSupersmushingDepth(Math.min(this.getHorizontalSupersmushingDepth(), other.getHorizontalSupersmushingDepth()));
        layout.setVerticalSupersmushingDepth(Math.min(this.getVerticalSupersmushingDepth(), other.getVerticalSupersmushingDepth()));
        return layout;
    }

    public final int getMaximalVerticalSmushingDepth(QuickString c, QuickString d) {
        int cB;
        int cA;
        if (this.verticalMode == VerticalLayoutMode.FULL_HEIGHT) {
            return 0;
        }
        int count = 0;
        while (c.length() > 0 && c.lastChar() == ' ') {
            ++count;
            c = c.substring(0, c.length() - 1);
        }
        while (d.length() > 0 && d.firstChar() == ' ') {
            ++count;
            d = d.substring(1);
        }
        if (c.length() == 0 || d.length() == 0) {
            return count;
        }
        if (this.verticalMode == VerticalLayoutMode.VERTICAL_FITTING) {
            return count;
        }
        if (this.verticalMode == VerticalLayoutMode.SPACED_VERTICAL_FITTING) {
            return count - 1;
        }
        if (this.verticalMode == VerticalLayoutMode.SUPERSMUSHING) {
            for (int i = 0; i < this.verticalSupersmushingDepth && c.length() > i && c.charAt(c.length() - 1 - i) != '\u007f'; ++i) {
                ++count;
            }
            return count;
        }
        if (this.verticalMode == VerticalLayoutMode.REVERSE_SUPERSMUSHING) {
            for (int i = 0; i < this.verticalSupersmushingDepth && d.length() > i && d.charAt(i) != '\u007f'; ++i) {
                ++count;
            }
            return count;
        }
        char chA = c.lastChar();
        char chB = d.firstChar();
        if (this.verticalRules.isNoRulesSpecified()) {
            return count + 1;
        }
        if (this.verticalRules.isEqualCharacter() && chA == chB && chA != '\u007f') {
            return count + 1;
        }
        if (this.verticalRules.isUnderscore()) {
            if (chA == '_' && "|/\\[]{}()<>".indexOf(chB) != -1) {
                return count + 1;
            }
            if (chB == '_' && "|/\\[]{}()<>".indexOf(chA) != -1) {
                return count + 1;
            }
        }
        if (this.verticalRules.isHierarchy() && (cA = this.getHierarchyClass(chA)) != (cB = this.getHierarchyClass(chB)) && cA != -1 && cB != -1) {
            return count + 1;
        }
        if (this.verticalRules.isHorizontalLine()) {
            if (chA == '_' && chB == '-') {
                return count + 1;
            }
            if (chA == '-' && chB == '_') {
                return count + 1;
            }
        }
        if (this.verticalRules.isVerticalLine() && chA == '|' && chB != '\u007f') {
            ++count;
            while (c.length() > 0 && c.lastChar() == '|') {
                ++count;
                c = c.substring(0, c.length() - 1);
            }
            return count;
        }
        return count;
    }

    public final int getMaximalHorizontalSmushingDepth(QuickString a, QuickString b) {
        int cB;
        int cA;
        if (this.horizontalMode == HorizontalLayoutMode.FULL_WIDTH || this.horizontalMode == HorizontalLayoutMode.FIXED_WIDTH) {
            return 0;
        }
        QuickString c = new QuickString(a);
        QuickString d = new QuickString(b);
        int count = 0;
        while (c.length() > 0 && c.lastChar() == ' ') {
            ++count;
            c = c.substring(0, c.length() - 1);
        }
        while (d.length() > 0 && d.firstChar() == ' ') {
            ++count;
            d = d.substring(1);
        }
        if (this.horizontalMode == HorizontalLayoutMode.KERNING) {
            return count;
        }
        if (this.horizontalMode == HorizontalLayoutMode.SPACED_KERNING) {
            return count - 1;
        }
        if (c.length() == 0 || d.length() == 0) {
            return count;
        }
        if (this.horizontalMode == HorizontalLayoutMode.SUPERSMUSHING) {
            for (int i = 0; i < this.horizontalSupersmushingDepth && c.length() > i && c.charAt(c.length() - 1 - i) != '\u007f'; ++i) {
                ++count;
            }
            return count;
        }
        if (this.horizontalMode == HorizontalLayoutMode.REVERSE_SUPERSMUSHING) {
            for (int i = 0; i < this.horizontalSupersmushingDepth && d.length() > i && d.charAt(i) != '\u007f'; ++i) {
                ++count;
            }
            return count;
        }
        if (this.horizontalRules.isNoRulesSpecified()) {
            return count + 1;
        }
        char chA = c.lastChar();
        char chB = d.firstChar();
        c = c.substring(0, c.length() - 1);
        d = d.substring(1);
        if (this.horizontalRules.isEqualCharacter() && chA == chB && chA != '\u007f') {
            return count + 1;
        }
        if (this.horizontalRules.isUnderscore()) {
            if (chA == '_' && "|/\\[]{}()<>".indexOf(chB) != -1) {
                return count + 1;
            }
            if (chB == '_' && "|/\\[]{}()<>".indexOf(chA) != -1) {
                return count + 1;
            }
        }
        if (this.horizontalRules.isHierarchy() && (cA = this.getHierarchyClass(chA)) != (cB = this.getHierarchyClass(chB)) && cA != -1 && cB != -1) {
            return count + 1;
        }
        if (this.horizontalRules.isOppositePair()) {
            if (chA == ']' && chB == '[') {
                return count + 1;
            }
            if (chA == '[' && chB == ']') {
                return count + 1;
            }
            if (chA == '(' && chB == ')') {
                return count + 1;
            }
            if (chA == ')' && chB == '(') {
                return count + 1;
            }
            if (chA == '{' && chB == '}') {
                return count + 1;
            }
            if (chA == '}' && chB == '{') {
                return count + 1;
            }
        }
        if (this.horizontalRules.isBigX()) {
            if (chA == '/' && chB == '\\') {
                return count + 1;
            }
            if (chA == '\\' && chB == '/') {
                return count + 1;
            }
            if (chA == '>' && chB == '<') {
                return count + 1;
            }
        }
        if (this.horizontalRules.isHardblank() && chA == '\u007f' && chB == '\u007f' && c.length() > 1 && d.length() > 1) {
            return count + 1;
        }
        return count;
    }

    private int getHierarchyClass(char ch) {
        int i = "||/\\[]{}()<>".indexOf(ch);
        if (i == -1) {
            return i;
        }
        return i / 2;
    }

    public final QuickString smushHorizontal(QuickString a, QuickString b, int depth) {
        QuickString c = new QuickString(a);
        QuickString d = new QuickString(b);
        if (depth < 0) {
            for (int i = 0; i < -depth; ++i) {
                c.append(' ');
            }
            return c.add(d);
        }
        if (c.length() + d.length() == depth) {
            return c.add(d);
        }
        while (depth > 0 && c.length() > 0 && c.lastChar() == ' ') {
            --depth;
            c.cropLastChar();
        }
        while (depth > 0 && d.length() > 0 && d.firstChar() == ' ') {
            --depth;
            d.crop(1);
        }
        if (depth == 0) {
            return c.add(d);
        }
        if (this.horizontalMode == HorizontalLayoutMode.SUPERSMUSHING) {
            while (depth > 0 && d.length() > 0 && (d.firstChar() == ' ' || d.firstChar() == '\u007f')) {
                --depth;
                d.cropFirstChar();
            }
            c.crop(0, c.length() - depth);
            return c.add(d);
        }
        if (this.horizontalMode == HorizontalLayoutMode.REVERSE_SUPERSMUSHING) {
            while (depth > 0 && c.length() > 0 && (c.lastChar() == ' ' || c.lastChar() == '\u007f')) {
                --depth;
                c.cropLastChar();
            }
            d.crop(depth);
            return c.add(d);
        }
        if (depth > 1) {
            throw new RuntimeException();
        }
        char chA = c.lastChar();
        char chB = d.firstChar();
        c.cropLastChar();
        d.crop(1);
        if (this.horizontalRules.isNoRulesSpecified()) {
            return c.add(chB, d);
        }
        if (this.horizontalRules.isEqualCharacter() && chA == chB && chA != '\u007f') {
            return c.add(chA, d);
        }
        if (this.horizontalRules.isUnderscore()) {
            if (chA == '_' && "|/\\[]{}()<>".indexOf(chB) != -1) {
                return c.add(chB, d);
            }
            if (chB == '_' && "|/\\[]{}()<>".indexOf(chA) != -1) {
                return c.add(chA, d);
            }
        }
        if (this.horizontalRules.isHierarchy()) {
            int cA = this.getHierarchyClass(chA);
            int cB = this.getHierarchyClass(chB);
            if (cA != -1 && cB != -1 && cA != cB) {
                if (cA > cB) {
                    return c.add(chA, d);
                }
                return c.add(chB, d);
            }
        }
        if (this.horizontalRules.isOppositePair() && (chA == ']' && chB == '[' || chA == '[' && chB == ']' || chA == '(' && chB == ')' || chA == ')' && chB == '(' || chA == '{' && chB == '}' || chA == '}' && chB == '{')) {
            return c.add('|', d);
        }
        if (this.horizontalRules.isBigX()) {
            if (chA == '/' && chB == '\\') {
                return c.add('|', d);
            }
            if (chA == '\\' && chB == '/') {
                return c.add('Y', d);
            }
            if (chA == '>' && chB == '<') {
                return c.add('X', d);
            }
        }
        if (this.horizontalRules.isHardblank() && chA == '\u007f' && chB == '\u007f' && c.length() > 1 && d.length() > 1) {
            return c.add('\u007f', d);
        }
        throw new RuntimeException();
    }

    public final QuickString smushVertical(QuickString a, QuickString b, int depth) {
        if (a.length() + b.length() == depth) {
            return a.add(b);
        }
        QuickString c = new QuickString(a);
        QuickString d = new QuickString(b);
        while (depth > 0 && c.length() > 0 && c.lastChar() == ' ') {
            --depth;
            c.cropLastChar();
        }
        while (depth > 0 && d.length() > 0 && d.firstChar() == ' ') {
            --depth;
            d.crop(1);
        }
        if (depth == 0) {
            return c.add(d);
        }
        if (this.verticalMode == VerticalLayoutMode.SUPERSMUSHING) {
            c.crop(0, c.length() - depth);
            return c.add(d);
        }
        if (this.verticalMode == VerticalLayoutMode.REVERSE_SUPERSMUSHING) {
            d.crop(depth);
            return c.add(d);
        }
        if (depth > 1) {
            throw new RuntimeException();
        }
        char chA = c.lastChar();
        char chB = d.firstChar();
        c.cropLastChar();
        d.crop(1);
        if (this.verticalRules.isNoRulesSpecified()) {
            return c.add(chB, d);
        }
        if (this.verticalRules.isEqualCharacter() && chA == chB && chA != '\u007f') {
            return c.add(chA, d);
        }
        if (this.verticalRules.isUnderscore()) {
            if (chA == '_' && "|/\\[]{}()<>".indexOf(chB) != -1) {
                return c.add(chB, d);
            }
            if (chB == '_' && "|/\\[]{}()<>".indexOf(chA) != -1) {
                return c.add(chA, d);
            }
        }
        if (this.verticalRules.isHierarchy()) {
            int cA = this.getHierarchyClass(chA);
            int cB = this.getHierarchyClass(chB);
            if (cA != -1 && cB != -1 && cA != cB) {
                if (cA > cB) {
                    return c.add(chA, d);
                }
                return c.add(chB, d);
            }
        }
        if (this.verticalRules.isHorizontalLine()) {
            if (chA == '_' && chB == '-') {
                return c.add('=', d);
            }
            if (chA == '-' && chB == '_') {
                return c.add('=', d);
            }
        }
        if (this.verticalRules.isVerticalLine() && chA == '|' && chB != '\u007f') {
            while (c.length() > 0 && c.lastChar() == '|') {
                c.cropLastChar();
            }
            return c.add(d);
        }
        throw new RuntimeException();
    }

    public final String toString() {
        return "FigLayout{horizontalMode=" + this.getHorizontalLayoutMode() + "; horizontalSmushingRules=" + this.getHorizontalSmushingRules() + "; supersmushingDepth=" + this.getHorizontalSupersmushingDepth() + "; verticalMode=" + this.getVerticalLayoutMode() + "; verticalSmushingRules=" + this.getHorizontalSmushingRules() + "}";
    }

    public final HorizontalLayoutMode getHorizontalLayoutMode() {
        return this.horizontalMode;
    }

    public final VerticalLayoutMode getVerticalLayoutMode() {
        return this.verticalMode;
    }

    public final VerticalSmushingRules getVerticalSmushingRules() {
        return this.verticalRules;
    }

    public final HorizontalSmushingRules getHorizontalSmushingRules() {
        return this.horizontalRules;
    }

    public final void setHorizontalMode(HorizontalLayoutMode mode) {
        this.horizontalMode = mode;
    }

    public final void setVerticalMode(VerticalLayoutMode mode) {
        this.verticalMode = mode;
    }

    public final int getHorizontalSupersmushingDepth() {
        return this.horizontalSupersmushingDepth;
    }

    public final void setHorizontalSupersmushingDepth(int supersmushingDepth) {
        this.horizontalSupersmushingDepth = supersmushingDepth;
    }

    public final Object clone() {
        FigLayout clone = new FigLayout(this.getHorizontalLayoutMode(), (HorizontalSmushingRules)this.getHorizontalSmushingRules().clone(), this.getVerticalLayoutMode(), (VerticalSmushingRules)this.getVerticalSmushingRules().clone());
        clone.setHorizontalSupersmushingDepth(this.getHorizontalSupersmushingDepth());
        return clone;
    }

    public final void setHorizontalSmushingRules(HorizontalSmushingRules rules) {
        this.horizontalRules = rules;
    }

    public final void setVerticalSmushingRules(VerticalSmushingRules rules) {
        this.verticalRules = rules;
    }

    public final int getVerticalSupersmushingDepth() {
        return this.verticalSupersmushingDepth;
    }

    public final void setVerticalSupersmushingDepth(int supersmushingDepth) {
        this.verticalSupersmushingDepth = supersmushingDepth;
    }

    public final void setPrintDirection(PrintDirection printDirection) {
        Ensure.ensureArgumentNotNull(printDirection);
        this.printDirection = printDirection;
    }
}

