/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine.primitives;

import de.jave.figlet.engine.layout.HorizontalAlignment;
import de.jave.figlet.engine.layout.PrintDirection;
import de.jave.figlet.engine.layout.VerticalAlignment;
import de.jave.figlet.engine.primitives.FigCharacter;
import de.jave.figlet.engine.primitives.FigLayout;
import de.jave.text.QuickString;
import net.disy.commons.core.util.Ensure;

public final class FigFragment
implements Cloneable {
    private QuickString[] lines;
    private FigLayout[] layoutTop;
    private FigLayout[] layoutBottom;
    private FigLayout[] layoutLeft;
    private FigLayout[] layoutRight;
    private int height;
    private int width;
    private int underLength;
    private VerticalAlignment verticalAlignment = VerticalAlignment.BOTTOM;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    private int maxLineLength;
    private PrintDirection printDirection;

    public FigFragment(QuickString[] lines, FigLayout[] layoutLeft, FigLayout[] layoutRight, int height, int width, FigLayout[] layoutTop, FigLayout[] layoutBottom, int underLength, int maxLineLength, PrintDirection printDirection) {
        this.lines = lines;
        this.layoutLeft = layoutLeft;
        this.layoutRight = layoutRight;
        this.height = height;
        this.width = width;
        this.layoutTop = layoutTop;
        this.layoutBottom = layoutBottom;
        this.underLength = underLength;
        this.maxLineLength = maxLineLength;
        this.printDirection = printDirection;
        this.checkIntegrity();
    }

    public FigFragment(FigCharacter ch, FigLayout layout, int underLength, int maxLineLength) {
        int i;
        this.printDirection = layout.getPrintDirection();
        this.maxLineLength = maxLineLength;
        if (ch == null) {
            System.err.println("WARNING: FIGCharacter==null in FIGFragment(ch,layout)");
            String[] stringArray = new String[1];
            String[] s = stringArray;
            stringArray[0] = " ";
            ch = new FigCharacter(32, s);
        }
        this.underLength = underLength;
        this.height = ch.getHeight();
        this.lines = new QuickString[this.height];
        for (i = 0; i < this.height; ++i) {
            this.lines[i] = new QuickString(ch.getLine(i));
        }
        this.width = this.lines[0].length();
        this.layoutLeft = new FigLayout[this.height];
        this.layoutRight = new FigLayout[this.height];
        for (i = 0; i < this.height; ++i) {
            this.layoutLeft[i] = layout;
            this.layoutRight[i] = layout;
        }
        this.layoutTop = new FigLayout[this.width];
        this.layoutBottom = new FigLayout[this.width];
        for (i = 0; i < this.width; ++i) {
            this.layoutTop[i] = layout;
            this.layoutBottom[i] = layout;
        }
        this.verticalAlignment = VerticalAlignment.BOTTOM;
        this.checkIntegrity();
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final void ensureUnsmushability() {
        if (this.lines[0].firstChar() == ' ') {
            this.lines[0].setCharAt(0, '\u007f');
        }
    }

    public final void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public final VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public final HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public final QuickString[] getLines() {
        return this.lines;
    }

    public final int getUnderLength() {
        return this.underLength;
    }

    public final FigLayout[] getLayoutRight() {
        return this.layoutRight;
    }

    public final FigLayout[] getLayoutLeft() {
        return this.layoutLeft;
    }

    public final int getMaxLineLength() {
        return this.maxLineLength;
    }

    public final FigLayout getTopLayout(int i) {
        return this.layoutTop[i];
    }

    public final FigLayout getBottomLayout(int i) {
        return this.layoutBottom[i];
    }

    public final void setTopLayout(int i, FigLayout layout) {
        this.layoutTop[i] = layout;
    }

    public final void setBottomLayout(int i, FigLayout layout) {
        this.layoutBottom[i] = layout;
    }

    public final FigLayout[] getLayoutTop() {
        return this.layoutTop;
    }

    public final FigLayout[] getLayoutBottom() {
        return this.layoutBottom;
    }

    public final void addColumnsRight(int columnCount) {
        QuickString gap = FigFragment.createEmptyString(columnCount);
        for (int i = 0; i < this.getHeight(); ++i) {
            this.getLines()[i].append(gap);
        }
        FigLayout addedTopLayout = this.width == 0 ? this.layoutRight[0] : this.layoutTop[this.width - 1];
        this.layoutTop = FigFragment.append(this.layoutTop, columnCount, addedTopLayout);
        FigLayout addedBottomLayout = this.width == 0 ? this.layoutRight[0] : this.layoutBottom[this.width - 1];
        this.layoutBottom = FigFragment.append(this.layoutBottom, columnCount, addedBottomLayout);
        this.width += columnCount;
        this.checkIntegrity();
    }

    public final void addColumnsLeft(int columnCount) {
        QuickString gap = FigFragment.createEmptyString(columnCount);
        for (int i = 0; i < this.getHeight(); ++i) {
            this.getLines()[i].prepend(gap);
        }
        FigLayout addedTopLayout = this.width == 0 ? this.layoutLeft[0] : this.layoutTop[0];
        this.layoutTop = FigFragment.prepend(this.layoutTop, columnCount, addedTopLayout);
        FigLayout addedBottomLayout = this.width == 0 ? this.layoutLeft[0] : this.layoutBottom[0];
        this.layoutBottom = FigFragment.prepend(this.layoutBottom, columnCount, addedBottomLayout);
        this.width += columnCount;
        this.checkIntegrity();
    }

    public final void addRowsBottom(int rowCount) {
        QuickString[] newLines = new QuickString[this.lines.length + rowCount];
        System.arraycopy(this.lines, 0, newLines, 0, this.lines.length);
        QuickString gap = FigFragment.createEmptyString(this.width);
        for (int i = 0; i < rowCount; ++i) {
            newLines[this.lines.length + i] = new QuickString(gap);
        }
        FigLayout addedLeftLayout = this.height == 0 ? this.layoutBottom[0] : this.layoutLeft[this.height - 1];
        this.layoutLeft = FigFragment.append(this.layoutLeft, rowCount, addedLeftLayout);
        FigLayout addedRightLayout = this.height == 0 ? this.layoutBottom[0] : this.layoutRight[this.height - 1];
        this.layoutRight = FigFragment.append(this.layoutRight, rowCount, addedRightLayout);
        this.lines = newLines;
        this.height += rowCount;
        this.checkIntegrity();
    }

    public final void addRowsTop(int rowCount) {
        QuickString[] newLines = new QuickString[this.lines.length + rowCount];
        System.arraycopy(this.lines, 0, newLines, rowCount, this.lines.length);
        QuickString gap = FigFragment.createEmptyString(this.width);
        for (int i = 0; i < rowCount; ++i) {
            newLines[i] = new QuickString(gap);
        }
        FigLayout addedLeftLayout = this.height == 0 ? this.layoutTop[0] : this.layoutLeft[0];
        this.layoutLeft = FigFragment.prepend(this.layoutLeft, rowCount, addedLeftLayout);
        FigLayout addedRightLayout = this.height == 0 ? this.layoutTop[0] : this.layoutRight[0];
        this.layoutRight = FigFragment.prepend(this.layoutRight, rowCount, addedRightLayout);
        this.lines = newLines;
        this.height += rowCount;
        this.checkIntegrity();
    }

    private void checkIntegrity() {
        Ensure.ensureArgumentTrue(this.width == this.layoutTop.length);
        Ensure.ensureArgumentTrue(this.width == this.layoutBottom.length);
        Ensure.ensureArgumentTrue(this.height == this.layoutLeft.length);
        Ensure.ensureArgumentTrue(this.height == this.layoutRight.length);
        Ensure.ensureArgumentTrue(this.height == this.lines.length);
        for (int i = 0; i < this.lines.length; ++i) {
            Ensure.ensureArgumentNotNull(this.lines[i]);
        }
    }

    private static FigLayout[] append(FigLayout[] oldLayouts, int length, FigLayout addedLayout) {
        FigLayout[] result = new FigLayout[oldLayouts.length + length];
        System.arraycopy(oldLayouts, 0, result, 0, oldLayouts.length);
        for (int i = 0; i < length; ++i) {
            result[oldLayouts.length + i] = addedLayout;
        }
        return result;
    }

    private static FigLayout[] prepend(FigLayout[] oldLayouts, int length, FigLayout addedLayout) {
        FigLayout[] result = new FigLayout[oldLayouts.length + length];
        System.arraycopy(oldLayouts, 0, result, length, oldLayouts.length);
        for (int i = 0; i < length; ++i) {
            result[i] = addedLayout;
        }
        return result;
    }

    private static QuickString createEmptyString(int length) {
        QuickString string = new QuickString(length);
        for (int i = 0; i < length; ++i) {
            string.append(' ');
        }
        return string;
    }

    public final void setHorizontalAlignment(HorizontalAlignment alignment) {
        this.horizontalAlignment = alignment;
    }

    public final boolean isEmpty() {
        return this.getHeight() == 0 || this.getWidth() == 0;
    }

    public final PrintDirection getPrintDirection() {
        return this.printDirection;
    }
}

