/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine.controlfile;

import de.jave.core.io.zip.ZipUtilities;
import de.jave.figlet.engine.DefaultConversionContext;
import de.jave.figlet.engine.controlfile.FigControlRegionTranslation;
import de.jave.figlet.engine.controlfile.FigControlRule;
import de.jave.figlet.engine.controlfile.FigControlStageSeparator;
import de.jave.figlet.engine.controlfile.FigControlTranslation;
import de.jave.lib.io.IoUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;

public final class FigControlFile {
    private String name;
    private FigControlRule[] rules;

    public FigControlFile(String name) {
        if (!name.endsWith(".flc")) {
            this.name = name + ".flc";
            return;
        }
        this.name = name;
    }

    public final int map(int character, DefaultConversionContext context) {
        int result = -1;
        boolean stageFullFilled = false;
        for (int i = 0; i < this.rules.length; ++i) {
            FigControlRule r = this.rules[i];
            if (r instanceof FigControlStageSeparator) {
                stageFullFilled = false;
                continue;
            }
            int a = r.map(character, context);
            if (a == -1 || stageFullFilled) continue;
            result = a;
            stageFullFilled = true;
        }
        if (result == -1) {
            return character;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean load(DefaultConversionContext context) {
        ArrayList<FigControlRule> vRules = new ArrayList<FigControlRule>();
        InputStream inputStream = null;
        try {
            URL url = IoUtilities.toUrl(this.name);
            inputStream = url.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(ZipUtilities.openPossiblyZipped(inputStream)));
            String line = reader.readLine();
            while (line != null) {
                if (line.length() != 0 && line.charAt(0) != '#' && !line.startsWith("flc")) {
                    switch (line.charAt(0)) {
                        case 't': {
                            int i1 = 0;
                            if (line.startsWith("\\-")) {
                                i1 = 2;
                            }
                            if (line.indexOf(45, i1) == -1) {
                                vRules.add(new FigControlTranslation(line, context));
                                break;
                            }
                            vRules.add(new FigControlRegionTranslation(line, context));
                            break;
                        }
                        case 'f': {
                            vRules.add(new FigControlStageSeparator());
                            break;
                        }
                        case 'h': {
                            this.createWarning("Option 'h' not yet implemented - ignored.");
                            break;
                        }
                        case 'j': {
                            this.createWarning("Option 'j' not yet implemented - ignored.");
                            break;
                        }
                        case 'b': {
                            this.createWarning("Option 'b' not yet implemented - ignored.");
                            break;
                        }
                        case 'u': {
                            this.createWarning("Option 'u' not yet implemented - ignored.");
                            break;
                        }
                        case 'g': {
                            this.createWarning("Option 'g' not yet implemented - ignored.");
                            break;
                        }
                        default: {
                            this.createWarning("'number number' not yet implemented - ignored.");
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException me) {
            try {
                String cfr_ignored_0 = "Error loading FIGLet control file: " + me;
                boolean bl = false;
            }
            catch (Throwable throwable) {
                IoUtilities.close(inputStream);
                throw throwable;
            }
            IoUtilities.close(inputStream);
            return false;
        }
        IoUtilities.close(inputStream);
        this.rules = vRules.toArray(new FigControlRule[vRules.size()]);
        return true;
    }

    private String createWarning(String message) {
        return "figlet control file " + this.name + ", " + message;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FIGLet control file '" + this.getName() + "' containing rules:\n");
        for (int i = 0; i < this.rules.length; ++i) {
            sb.append(" " + i + " " + this.rules[i].toString() + "\n");
        }
        return sb.toString();
    }

    public final String getName() {
        return this.name;
    }
}

